--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 爸爸类
----------------------
local M     = class("AniDad", import("app.common.node.BaseDad"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos  = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
	--缩放大小
	self._scaleSize = ifnil(params.scaleSize, 1)
	-- 类型 1：前情 2：倒计时
	self._type      = ifnil(params.type, 1)
	--是否结束
	self._finish    = ifnil(params.finish, false)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathAni()
end

function M:walkOutScreen()
	--出场
    local effectTb = { cj_qq = "sfx05706010", cj_mm = "sfx05706007", cj_qmm = "sfx05706013", cj_qmb = "sfx05706004",}
    soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
    -- 走
    self:walkAni()
    self:line({
        { "union", {
            { "scaleto", 1.5, self._scaleSize * 1.5 },
            { "moveto", 1.5, cc.p(self._enterPos.x, self._enterPos.y - 600) }
        } },
        { "fn", function()

		end },
		{ "hide",}
        -- { "remove",}
    })
end

--走路
function M:walkAni()
	self:play("qmb_zou1")
end

--呼吸
function M:breathAni()
	self:play("qmb_hx2")
end

--抬头看烟花（开始）
function M:riseAni1()
	self:play("qmb_tt1")
end

--抬头看天（循环）
function M:riseAni2()
    self:play("qmb_tt1_1")
end

-- --抬头看天（结束）
-- function M:riseAni3()
--     self:play("qmb_tt1_2")
-- end

--转头看妈妈
function M:lookMomAni1()
    self:play("qmb_tt1_2")
end

--看妈妈循环
function M:lookMomAni2()
    self:play("qmb_tt1_3")
end

--看妈妈结束
function M:lookMomAni3()
    self:play("qmb_tt1_4")
end

--低头说话（开始）
function M:bowTalkAni1()
    self:play("qmb_dtsh1")
end

--低头说话（循环）
function M:bowTalkAni2()
    self:play("qmb_dtsh1_1")
end

--低头说话（结束）
function M:bowTalkAni3()
    self:play("qmb_dtsh1_2")
end

-- 看老婆笑（开始）
function M:watchSmileAni1()
 	self:play("qmb_kt")
end

-- 看老婆笑（循环）
function M:watchSmileAni2()
    self:play("qmb_kt_1")
end

-- 看老婆笑（结束）
function M:watchSmileAni3()
    self:play("qmb_kt_2")
end

--鼓掌
function M:clapAni()
 	self:play("qmb_gz")
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		-- if __moveId == "qmb_kt" then
		if __moveId == "qmb_gz" then
			self:breathAni()
			if not self._finish then
				--开始说话
				self._layer:startTalk()
			end
		elseif __moveId == "qmb_dtsh1" then
			-- --说话动作
			-- --宝贝们，烟花是很危险的，要站远一点看鸭”
			-- self._layer:momAndDadTalkAct()
		elseif __moveId == "qmb_dtsh1_2" then
			-- self:walkOutScreen()
		elseif __moveId == "qmb_tt1" then
   			--抬头看天（循环）
			self:riseAni2()
		elseif __moveId == "qmb_tt1_2" then
   			--看妈妈循环
			self:lookMomAni2()
		elseif __moveId == "qmb_tt1_4" then
			--抬头看天（循环）
			self:riseAni2()
		elseif __moveId == "qmb_kt" then
			-- 看老婆笑（循环）
			self:watchSmileAni2()
		elseif __moveId == "qmb_kt_2" then
			self:breathAni()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
