--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妙妙类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(780 + X_OFFSET, 90))
	--缩放大小
	self._scaleSize = ifnil(params.scaleSize, 1)
	--是否结束
	self._finish = ifnil(params.finish, false)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--换装
	self:changeClose()
	-- 呼吸
	self:breathAni()
end

--换装
function M:changeClose()
	self._armature:getBone("cmm_wq"):hide()
end


function M:walkOutScreen()
    --出场
    local effectTb = { cj_qq = "sfx05706010", cj_mm = "sfx05706007", cj_qmm = "sfx05706013", cj_qmb = "sfx05706004",}
    soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
    -- 走
    self:walkAni()
    self:line({
        { "union", {
            { "scaleto", 1.3, self._scaleSize * 1.5 },
            { "moveto", 1.3, cc.p(self._enterPos.x, self._enterPos.y - 600) }
        } },
        { "fn", function()

		end },
		{"hide",}
    -- { "remove",}
    })
end

--走路
function M:walkAni()
    self:play("mm_zou1")
end

--呼吸
function M:breathAni()
    self:play("mm_hx2")
end

--抬头看烟花（开始）
function M:riseAni1()
    self:play("mm_tt1")
end

--抬头看天（循环）
function M:riseAni2()
    self:play("mm_tt1_1")
end

--抬头看天（结束）
function M:riseAni3()
    self:play("mm_tt1_2")
end

--蹦跳
function M:jumpAni()
    self:play("mm_tiao")
end

-- 听话（开始）
function M:listenAni1()
	self:play("mm_ting1")
end

-- 听话（循环）
function M:listenAni2()
	self:play("mm_ting1_1")
end

-- 听话（结束）
function M:listenAni3()
	self:play("mm_ting1_2")
end

-- 看妈妈（开始）
function M:watchAni1()
	self:play("mm_tt2")
end

-- 看妈妈（循环）
function M:watchAni2()
    self:play("mm_tt2_1")
end

-- 看妈妈（循环）说话
function M:watchAni3()
    self:play("mm_tt2_2")
end

-- 看妈妈（结束）
function M:watchAni4()
    self:play("mm_tt2_3")
end

-- 说话1（开始）
function M:talkAni1()
	self:play("mm_sh2")
end

-- 说话1（循环）
function M:talkAni2()
    self:play("mm_sh2_1")
end

-- 说话1（开结束）
function M:talkAni3()
    self:play("mm_sh2_2")
end



function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_tiao" then
			--呼吸
			self:breathAni()
		elseif __moveId == "mm_ting1" then
			-- 听话（循环）
			self:listenAni2()
		elseif __moveId == "mm_ting1_2" then
			-- self:walkOutScreen()
		elseif __moveId == "mm_tt1" then
			--抬头看天（循环）
			self:riseAni2()
		elseif __moveId == "mm_tt2" then
   			-- 看妈妈（循环）
			self:watchAni2()
		elseif __moveId == "mm_tt2_3" then
			--抬头看天（循环）
			self:riseAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
