--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
--妈妈类
----------------------
local M     = class("AniMom", import("app.common.node.BaseMom"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos  = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
	--缩放大小
	self._scaleSize = ifnil(params.scaleSize, 1)
	--是否结束
	self._finish    = ifnil(params.finish, false)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--呼吸
	self:breathAni()
end

--说话动作“除夕就要结束，新的一年要到啦，咱们一家人来倒计时吧~”
function M:talkAct()
	--看着天空说话
	self:watchSkyTalkAni()
	-- 播放配音[v057097]除夕就要结束，新的一年要到啦，咱们一家人来倒计时吧~
	soundVoice:playEffectv057097()
	local time = soundVoice:soundDuration("v057097", 5)
    self:line({
        { "Delay", time },
        { "fn", function()
			--抬头看天（结束）
			self:riseAni2()
			-- “好耶好耶！”
			self._layer:qqAndMmTalk()
        end }
    })
end

function M:walkOutScreen()
    --出场
    local effectTb = { cj_qq = "sfx05706010", cj_mm = "sfx05706007", cj_qmm = "sfx05706013", cj_qmb = "sfx05706004",}
    soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
    -- 走
    self:walkAni()
    self:line({
        { "union", {
            { "scaleto", 1.5, self._scaleSize * 1.5 },
            { "moveto", 1.5, cc.p(self._enterPos.x, self._enterPos.y - 600) }
        } },
		{ "hide",}
    -- { "remove",}
    })
end

--走路
function M:walkAni()
    self:play("qmm_zou1")
end

--呼吸
function M:breathAni()
    self:play("qmm_hx2")
end

--抬头看烟花（开始）
function M:riseAni1()
    self:play("qmm_tt1")
end

--抬头看天（循环）
function M:riseAni2()
    self:play("qmm_tt1_1")
end

--抬头看天（结束）
function M:riseAni3()
    self:play("qmm_tt1_2")
end

--低头说话（开始）
function M:bowTalkAni1()
    self:play("qmm_dtsh1")
end

--低头说话（循环）
function M:bowTalkAni2()
    self:play("qmm_dtsh1_1")
end

--低头说话（结束）
function M:bowTalkAni3()
    self:play("qmm_dtsh1_2")
end

-- 看老婆笑
function M:watchSmileAni()
    self:play("qmm_kt")
end

--鼓掌
function M:clapAni()
    self:play("qmm_gz")
end

--看着天空说话
function M:watchSkyTalkAni()
    self:play("qmm_ttsh")
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmm_gz" then
			self:breathAni()
		elseif __moveId == "qmm_dtsh1" then
			--宝贝们，烟花是很危险的，要站远一点看鸭”
			self._layer:momAndDadTalkAct()
		elseif __moveId == "qmm_dtsh1_2" then
			-- self:walkOutScreen()
			--说话动作
		elseif __moveId == "qmm_tt1" then
			--抬头看天（循环）
			self:riseAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
