--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 大门 类 
----------------------
local M     = classSpriteTouch("Door")
M.TAG       = "Door"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    --父节点
    self._parent    = params.parent
    --缩小倍数
    self._scaleSize = ifnil(params.scaleSize, 0.58)
    --图片缩小倍数（超过2048， 缩小了0.9）
    self._smallSize = ifnil(params.smallSize, 0.9)
    --春联放置区域
    self._coupletsAreaTb = {}
    --灯笼放置区域
    self._lanternAreaTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    --房子主题
    self:display("evefireworkput/bg/1.png")
    local light = D.img("evefireworkput/bg/3.png"):to(self, 20):p(self:cw() / 2,  15.2)
end

--加载结点
function M:loadPageNode()
    --加载房顶
    self:loadRoof()
    --加载屋顶雪
    self:loadSnow()
    --加载地面
    self:loadGround()
    --加载墙壁
    self:loadWall()
    --加载灯笼
    self:loadLantern()
end

--加载房顶
function M:loadRoof()
    local roof = D.img("evefireworkput/bg/2.png"):to(self, 10):p(self:cw() / 2, 330)
    self._roof = roof
end

--加载屋顶雪
function M:loadSnow()
    local posTab = { ccp(151.6, 127.2), ccp(272, 127), ccp(338.5, 127.6), ccp(170.1, 26.2)  }
    for i, v in ipairs(posTab) do
        local snow = D.img("evefireworkput/bg/snow/"..i..".png"):to(self._roof, 10):anchor(cc.p(0.5, 1)):p(posTab[i]):scale(0.77)
        snow._size = 0.77
        -- self:snowAct(snow)
    end
end

-- 雪的动作
function M:snowAct(node)
    local num = math.random(110, 120) / 100
    local time = 1.4
    self._snowAct = A.line({
        { "scaleTo", time, node._size, node._size * num },
        { "scaleTo", time, node._size },
        { "scaleTo", time, node._size, node._size * num },
        { "scaleTo", time, node._size },
        { "fn", function()
            return self:snowAct(node)
        end }
    }):at(node)
end

--加载地面
function M:loadGround()
    --地面
    local ground = D.img("evefireworkput/bg/ground.png"):to(self, -1)
    :scale(1.1):anchor(cc.p(0.5, 0.9)):p(212, 23.8)

    local snow   = D.img("evefireworkput/bg/snow.png"):to(ground):p(178.1, 37.7)
    local snow = D.img("evefireworkput/bg/snow.png"):to(ground):p(896.8, 45.5)
end

--加载墙壁
function M:loadWall()
    local wallL = D.img("evefireworkput/bg/left.png"):to(self, -2):p(-270.4, 115):scale(1)
    local wallR = D.img("evefireworkput/bg/right.png"):to(self, -2):p(658.2, 115):scale(1)
end

--加载灯笼
function M:loadLantern()
    local points = { cc.p(20.8, 251.5), cc.p(355, 251.5),}
    for i, v in ipairs(points) do
        local lantern = D.img("evefireworkput/bg/lantern/1.png"):to(self, 2):p(v):anchor(cc.p(0.45, 0.96))
        local light1 = D.img("evefireworkput/bg/lantern/light1.png"):to(self, 1):p(v.x, v.y - 30)
        local light2 = D.img("evefireworkput/bg/lantern/light2.png"):to(lantern, 3):p(lantern:cw()/2, lantern:ch() / 2 - 10)
        lantern._light = light2
        light1:cycle({
            { "scaleto", 1, 1.05 },
            { "scaleto", 1, 0.95 },
        })
        light2:cycle({
            { "scaleto", 1, 1.1 },
            { "scaleto", 1, 0.9 },
        })

        local light2 = D.img("evefireworkput/bg/light.png"):to(self, 1):p(v.x, v.y - 30)
        --摇摆动作
        self:swingAction(lantern)
    end
end


-- --摇摆动作
-- function M:swingAction(lantern)
--     local num = math.random(5, 8)
--     local time = math.random(8, 12) / 10
--     lantern._swingAct = A.line({
--         { "rotateby", time, -num },
--         { "rotateby", time, num },
--         { "rotateby", time, num },
--         { "rotateby", time, -num },
--         { "fn", function()
--             return self:swingAction(lantern)
--         end }
--     }):at(lantern)

--     lantern._light:line({
--         { "rotateby", time, num },
--         { "rotateby", time, -num },
--         { "rotateby", time, -num },
--         { "rotateby", time, num },
--     })
-- end

--摇摆动作
function M:swingAction(lantern)
    local num = math.random(5, 8)
    local time = math.random(8, 12) / 10
    lantern._swingAct = A.cycle({
        { "rotateby", time, -num },
        { "rotateby", time, num },
        { "rotateby", time, num },
        { "rotateby", time, -num },
    }):at(lantern)

    lantern._light:cycle({
        { "rotateby", time, num },
        { "rotateby", time, -num },
        { "rotateby", time, -num },
        { "rotateby", time, num },
    })
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
