--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 天空类
----------------------
local M     = classSpriteTouch("Sky")
M.TAG       = "Sky"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --属于
    self._belong = params.belong
    --触控
    self._canTouch = false
    --缩放大小
    self._scaleSize= ifnil(params.scaleSize, BG_SCALE)
    --位置
    self._pos   = ifnil(params.pos, cc.p(V.w_2, V.h_2))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evefireworkput/bg/sky/1.png"):anchor(cc.p(0.5, 0)):p(self._pos):scale(self._scaleSize)
    self:getParent():bindTouch()
    local sky2 = D.img("evefireworkput/bg/sky/2.png"):to(self):anchor(cc.p(0.5, 0)):p(self:cw() / 2, self:ch())
    local sky3 = D.img("evefireworkput/bg/sky/3.png"):to(self):anchor(cc.p(0.5, 0)):p(self:cw() / 2, self:ch() + sky2:ch())--:bindTouch()

    --加载灯笼
    self:loadLanternSky(sky2, sky3)
    --加载天空的烟花
    self:loadFireWorkSky(sky2, sky3)
end

--加载灯笼
function M:loadLanternSky(sky2, sky3)
    local posTb1 = { cc.p(218.9, 373.4), cc.p(416.2, 81), cc.p(336.9, 467), cc.p(356.9, 286.8),
                    cc.p(669.5, 417.7), cc.p(605, 106.5), cc.p(790.1, 314.6), cc.p(826.4, 156),}
    self:loadLantern1(sky2, posTb1)
    local posTb2 = { cc.p(193.4, 56.5), cc.p(268, 239.2), cc.p(371.3, 105.7), cc.p(493.9, 312.7),
    cc.p(685.8, 411.6), cc.p(599.4, 192.7), cc.p(764.2, 42.8), cc.p(805.3, 206.9),}
    self:loadLantern1(sky3, posTb2)
end

--加载天空灯笼
function M:loadLantern1(parent, posTb)
    for i, v in ipairs(posTb) do
        local lantern = D.img("common/win/lantern/" .. math.random(1, 3) .. ".png"):to(parent, 1):p(v.x + X_OFFSET, v.y):scale(self._scaleSize)
        --灯笼运动
        self:lanternAct(lantern)
    end
end

--加载天空的烟花
function M:loadFireWorkSky(sky2, sky3)
    local posTb1 = {
        cc.p(187.3, 43.3), cc.p(403.7, 93.4), cc.p(229.7, 363.8), cc.p(621.6, 369.8),
        cc.p(553.6, -1.2), cc.p(461.5, 228.3), cc.p(706.3, 96.1), cc.p(757.9, 282.2),
    }
    --加载烟花
    self:loadFireWork(sky2, posTb1)

    local posTb = {
        cc.p(229.1, 58.4), cc.p(719.3, 94.8), cc.p(214.8, 334.5), cc.p(852.6, 258.6), cc.p(491.6, 178.4),
        cc.p(632.7, 364.3), cc.p(253, -160.1), cc.p(596.2, -155),  
    }
    local opciatyTb = { 80, 80, 80, 80, 80, 80, 200, 170, 140, 100 }
    self:loadFireWork(sky3, posTb, opciatyTb)

    self:cycle({
        { "Delay", 1.3 },
        { "fn", function()
            self:loadFireWork(sky2, posTb1, nil)
            local opciatyTb = { 80, 80, 80, 80, 80, 80, 200, 170, 140, 100 }
            self:loadFireWork(sky3, posTb, opciatyTb)
        end },
    })
end

--加载烟花
function M:loadFireWork(parent, posTb, opciatyTb)
    -- parent:bindTouch()
    -- -- local aaa = {}
    -- Tools:loadTestNode(parent, 10, posTb)
    opciatyTb = ifnil(opciatyTb , { 255, 255, 255, 255, 255, 255, 255, 255, 255, 255 })
    for i, v in ipairs(posTb) do
        local id = math.random(1, 4)
        local fireworks = D.img("common/win/" .. id .. "/" .. id .. "_1.png"):scale(1.7)
        :to(parent, 999):p(v.x + math.random(-50, 50), v.y + math.random(-50, 50)):hide():opacity(opciatyTb[i])
        fireworks._id = id
        fireworks:line({
            { "Delay", math.random(0, 100) / 100 },
            { "fn", function()
                self:fireworksAct(fireworks)
            end }
        })
    end
end

--烟花动作
function M:fireworksAct(fireworks)
    fireworks:line({
        { "show"},
        { "image", "common/win/" .. fireworks._id .. "/" .. fireworks._id .. "_", 15, 1 / 12 },
        { "remove",},
    })
end

-- 加载结点
function M:loadPageNode()
    --加载云
    self:loadCloud()
    --加载灯笼
    self:loadLantern()
end

--加载灯笼
function M:loadLantern()
    local posTb = { cc.p(119.4, 520.4), cc.p(175.6, 584.7), cc.p(255.3, 579.7), cc.p(794.6, 504.3), cc.p(701.2, 596.7), cc.p(406.3, 684.1) }
    local idTb = { 1, 3, 2, 2, 1, 1 }
    for i, v in ipairs(posTb) do
        local lantern = D.img("common/win/lantern/" .. idTb[i] .. ".png"):to(self._belong, 1):p(v.x + X_OFFSET, v.y):scale(self._scaleSize)
        --灯笼运动
        self:lanternAct(lantern)
    end
end

--灯笼运动
function M:lanternAct(lantern)
    local time = math.random(150, 200) / 100
    lantern:cycle({
        { "moveBY", time, cc.p(0, 10) },
        { "moveBY", time, cc.p(0, -10) },
        { "moveBY", time, cc.p(0, 10) },
        { "moveBY", time, cc.p(0, -10) },
    })
end

--加载云
function M:loadCloud()
    local points    = { cc.p(550.7, 670.6), cc.p(350.4, 640.8), cc.p(130.4, 655.8) }
    local ids    = { 1, 2, 2 }
    local isMoveTb = {true, true, true }
    local zorder    = { 1, 1, 1 }
    local sizes    = { 1, 1, 0.8 }
    for k, v in pairs(points) do
        local cloud = D.img("common/win/cloud/" .. math.random(1, 2) .. ".png"):anchor(cc.p(0, 0)):to(self._belong, 1):scale(sizes[k]):p(v)
        if isMoveTb[k] then
            --云朵移动
            self:cloudMove1(cloud)
        end
    end

    local points    = { cc.p(550.7 - V.w, 670.6), cc.p(350.4 - V.w, 640.8), cc.p(130.4 - V.w, 655.8),}
    local ids    = { 1, 2, 2 }
    local isMoveTb = {true, true, true }
    local zorder    = { 1, 1, 1 }
    local sizes    = { 1, 1, 0.8,}
    for k, v in pairs(points) do
        local cloud = D.img("common/win/cloud/" .. math.random(1, 2) .. ".png"):anchor(cc.p(0, 0)):to(self._belong, 1):scale(sizes[k]):p(v)
        if isMoveTb[k] then
            --云朵移动
            self:cloudMove(cloud)
        end
    end
end

--云朵移动
function M:cloudMove1(cloud)
    local pos = cloud:worldpoint()
    local speed = 25--(V.h - pos.y) / V.h * 100
    local time = V.w / speed
    local dis = V.w
    cloud:line({
        { "moveBy", time, cc.p(dis, 0) },
        { "fn", function()
            cloud:px(cloud:px() - dis * 2)
            --云朵移动
            self:cloudMove(cloud)
        end }
    })
end

--云朵移动
function M:cloudMove(cloud)
    local pos = cloud:worldpoint()
    local speed = 25--(V.h - pos.y) / V.h * 100
    local time = V.w * 2 / speed
    local dis = V.w * 2
    cloud:cycle({
        { "moveBy", time, cc.p(dis, 0) },
        { "fn", function()
            cloud:px(cloud:px() - dis)
        end }
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
