--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = class("Progress", import("app.common.node.BaseProgress"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --进度条信息
    self._info        = params.info or {
        imgName       = "evefireworkcut/progress/3.png",
        mode          = kCCProgressTimerTypeBar,
        midpoint      = ccp(0, 0),
        barChangeRate = ccp(0, 1),
        isAutoRun     = false
    }
    --背景图片
    self._baseImg    = params.baseImg or "evefireworkcut/progress/1.png"
    --数量
    self._num = 0
    --偏移量
    self._offset = ifnil(params.offset, cc.p(-1.5, 5))
    --退场位置
    self._quitDir    = "left"
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

function M:enterEvent()
    --粒子显示
    self:particleShow()
end

function M:loadParticle()
    --  加载粒子
    local paricle = P.newParticle("particle/jiangjiu2.plist")
    :to(self._progressBar, 200):p(self._progressBar:cw() / 2, 0):bindTouch():hide()
    Tools:insertParticleTb(self, paricle)
    self._particle = paricle 
    
    --  加载粒子
    local paricle = P.newParticle("particle/jindutiao_up2.plist")
    :to(self._progressBar, 200):p(self._progressBar:cw() / 2, 0):bindTouch():hide()
    Tools:insertParticleTb(self, paricle)
    self._showParticle = paricle
    self._isResetParticle = true
    --停止增加粒子
    self:stopParticle()
end

--粒子显示
function M:particleShow()
    if self._particleShow then return end
    self._particleShow = true
    self._particle:show()
    self._showParticle:show()
    --粒子移动
    self:updateParticle()
end

--粒子移动
function M:updateParticle()
    self:cycle({
        { "delay", 1 / 60 },
        { "fn", function()
            --获取进度
            local pencent = self:getPencent()
            local rate = pencent / 100
            local y = self._progressBar:ch() * rate
            self._particle:py(y + 1)
            self._showParticle:py(y + 1)
        end }
    })
end

--显示增加粒子
function M:resetParticle()
    if self._isResetParticle then
        return 
    end
    self._isResetParticle = true
    self._showParticle:resetSystem()
end

--停止增加粒子
function M:stopParticle()
    if self._isResetParticle then
        self._isResetParticle = false
        self._showParticle:stopSystem()
    end
end

-- 进度条增长
function M:progressRise()
    self._num = self._num + 1
    local num = 100 / 31
    self._progressBar:line({
        { "delay", 0.5},
        {"fn", function ()
            --显示增加粒子
            self:resetParticle()
        end},
        { "ProgressTo", 0.5, num * self._num },
        { "fn", function()
            --停止增加粒子
            self:stopParticle()
        end }
    })
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if self._particle  and not tolua.isnull(self._particle) then
        self._particle:remove()
        self._particle = nil
    end
    if self._showParticle  and not tolua.isnull(self._showParticle) then
        self._showParticle:remove()
        self._showParticle = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
