--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Special")
M.TAG       = "Special"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --裂开
    self._splitTb = {}
    --切的次数
    self._count = 0
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evefireworkcut/firework/11/1.png")
end

-- 加载结点
function M:loadPageNode()
    --加载裂开
    self:loadSplit()
    --加载背景灯
    self:loadLight()
end

--加载背景灯
function M:loadLight()
    local light = D.img("evefireworkcut/firework/11/light.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2)
end

--加载裂开
function M:loadSplit()
    local pointTb = {cc.p(94.5, 142.9),cc.p(25.6, 114.4),cc.p(28.8, 44.7),cc.p(54.5, 20.2),
                    cc.p(110.6, 23.6), cc.p(69, 78), cc.p(143.1, 71), cc.p(132.5, 111.9),}
    for i = 1, 8 do
        local split = D.img("evefireworkcut/firework/11/" .. (i + 1) .. ".png"):to(self, 9999):p(pointTb[i]):hide()
        table.insert(self._splitTb, split)
    end
end

--显示裂开状态
function M:showSplit()
    self:opacity(0)
    for i, v in ipairs(self._splitTb) do
        v:show()
    end
end

--加载裂开音效
function M:playSplitEffect()
    local effectIdTb = {"sfx05709035", "sfx05709036", "sfx05709037"}
    effectIdTb = T.shuffle(effectIdTb, 5)
    soundEffect["playEffect" .. effectIdTb[1]](soundEffect)
end

-- 刀碰撞巨型烟花1
function M:playCutSpecialEffect()
    local id = 1
    if self._count % 4 == 0 then
        id = 2
    end
    --加载裂开音效
    local effectIdTb = { "sfx05709033", "sfx05709034" }
    soundEffect["playEffect" .. effectIdTb[id]](soundEffect)
end

--烈开
function M:splitAct()
    self._count = self._count + 1
    -- 刀碰撞巨型烟花1
    self:playCutSpecialEffect()
    if self._count > 8 then
        return
    end
    if self._count % 3 == 0 then
        --加载裂开音效
        self:playSplitEffect()
    end
    local offset = { cc.p(0, 3), cc.p(-2, 2), cc.p(-2, -2), cc.p(-1, -2),
                    cc.p(1, -2), cc.p(0, 0), cc.p(2, -1), cc.p(1, 1),}
    for i, v in ipairs(self._splitTb) do
        local pos = offset[i]
        v:line({
            { "moveBy", 0.1, cc.p(pos.x * 0.2, pos.y * 0.2) },
        })
    end
end

-- 特殊烟花炸开
function M:specialBomb()
    -- 播放音效[sfx05709021]巨型烟花弹炸开
    soundEffect:playEffectsfx05709021()
    local offset = { cc.p(0, 3), cc.p(-2, 2), cc.p(-2, -2), cc.p(-1, -2),
                    cc.p(1, -2), cc.p(0, 0), cc.p(2, -1), cc.p(1, 1),}
    local time = 0.3
    for i, v in ipairs(self._splitTb) do
        local pos = offset[i]
        local newPos = cc.p(pos.x * 100, pos.y * 100)
        local angle = N.random(1, 90)
        v:line({
            {"union", {
                { "moveby", time, newPos },
                { "easing", "SINEOUT", { "fadeTo", time, 100 },},
                { "rotateTo", time, angle}
            }},
            {"fn", function ()
                Tools:removeNode(self)
            end}
        })
    end
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
