--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 星星类
----------------------
local M     = classArmatureTouch("Star")
M.TAG       = "Star"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	-- 骨骼信息
    self._file 	=  "bone/cj_xx"
	self._armatureName =  "cj_xx"
	
	--编号
	self._id	= ifnil(params.id, 1)
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(V.w_2, V.h_2))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathAni()
end

-- 呼吸
function M:breathAni()
	local speedTb = {1, 0.9, 0.95}
	self:play("xx_hx", speedTb[self._id])
end

-- 说话
function M:talkAni()
    self:play("xx_sh")
end

-- 反馈1——简单
function M:feedbackAni1()
	self:play("xx_fk1")
end

-- 反馈2——中等
function M:feedbackAni2()
 	self:play("xx_fk2", nil, { loop = 0 })
end

-- 反馈3——复杂
function M:feedbackAni3()
	self:play("xx_fk3", nil, { loop = 0 })
end

function M:enter()
	-- 反馈3——复杂
	-- self:feedbackAni3()

	self:line({
		{ "show" },
		{"union", {
			-- { "jumpto", 0.5, self._enterPos, 100, 1},
			{ "easing", "backout", { "scaleto", 0.5, 1 },},
		}}
		-- { "easing", "backout", {"moveto", 0.8, self._enterPos },}
	})
	self:line({
		{ "jumpto", 1, self._enterPos, 100, 1 },
		{ "jumpto", 1, self._enterPos, 100, 1 },
		{ "jumpto", 1, self._enterPos, 100, 1 },
		{ "jumpto", 1, self._enterPos, 100, 1 },
		{ "jumpto", 1, self._enterPos, 100, 1 },
	})
	-- 说话
	self:talkAni()
	self:line({
		{ "delay", 5 },
		{ "fn", function()
			-- 呼吸
			-- self:breathAni()
			self["feedbackAni"..self._id](self)
			-- self:feedbackAni2()
		end }
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "xx_fk3" or __moveId == "xx_fk1" or __moveId == "xx_fk2"   then
			-- 呼吸
			self:breathAni()
		elseif __moveId == "xx_sh" then
    		self:feedbackAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	self:line({
		{ "scaleTo", 0.1, 1.1 },
		{ "fn", function()
			-- 反馈1——简单
			self:feedbackAni3()    
		end }
	})
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
