--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 烟花类
----------------------
local M     = classSprite("Firework")
M.TAG       = "Firework"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --主层
    self._mainLayer = params.mainLayer
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    --类型
    self._type     = ifnil(params.type, 1)
    --画板集合
    self._renderTextureTb = {}
    --火星集合
    self._fireTb = {}
    --烟花集合
    self._fireworkTb = {}
    --需要火星
    self._needFire = ifnil(params.needFire, true)
    --粒子表
    self._particleTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
end

-- 图片渲染
function M:loadDisplay()
    self["loadType"..self._type](self)
end

--加载引线画板
function M:loadWireRender(pos, z, parent)
    pos = ifnil(pos, cc.p(183.9, 18.3))
    z = ifnil(z, -1)
    parent = ifnil(parent, self)
    local wire = D.img("evefireworkput/firework/" .. self._type .. "/wire.png"):to(parent, z):p(pos):opacity(0)
    -- 创建一个画布
    local renderTexture    = CCNodeExtend.extend(cc.RenderTexture:create(wire:cw(), wire:ch()))
    :p(wire:cw() / 2, wire:ch() / 2):bindTouch()
    -- 添加画布到裁剪节点上
    renderTexture:to(wire, 1)
    renderTexture:begin()
    local node = D.img("evefireworkput/firework/"..self._type.."/wire.png"):p(cc.p(wire:cw() / 2, wire:ch() / 2))
    node:visit()
    renderTexture:endToLua()
    table.insert(self._renderTextureTb, renderTexture)
end

--加载火星子
function M:loadFire(pos, z, parent)
    if not self._needFire then return end
    parent = ifnil(parent, self)
    --火星子
    local fire = D.img("evefireworkput/firework/fire/1.png"):to(parent, z):p(pos)
    table.insert(self._fireTb, fire)
end

--火星子隐藏
function M:fireHide()
    for i, v in ipairs(self._fireTb) do
        v:scale(0):hide():opacity(0)
    end
end

--火星子出现
function M:fireShow()
    for i, v in ipairs(self._fireTb) do
        v:line({
            {"show"},
            {"union", {
                { "scaleto", 0.4, 1},
                { "fadeto", 0.4, 255 },
            }}
        })
    end
end

--加载孔雀烟花
function M:loadType1()
    self:display("evefireworkput/firework/1/1.png")
    local shadow = D.img("evefireworkput/firework/1/shadow.png"):to(self, -1):p(cc.p(self:cw() / 2, -2))
    self._shadow = shadow
    --加载引线画板
    self:loadWireRender(cc.p(183.9, 18.3), -1)
    --加载火星子
    self:loadFire(cc.p(193, 21.3), -1)
end

--加载彩菊烟花
function M:loadType2()
    self:display("evefireworkput/firework/2/1.png")
    local shadow = D.img("evefireworkput/firework/2/shadow.png"):to(self, -1):p(cc.p(self:cw() / 2, -2)):scale(1.2)
    self._shadow = shadow
    --加载引线画板
    self:loadWireRender(cc.p(106.3, 25.3), -1)
    --加载火星子
    self:loadFire(cc.p(125.9, 35.3), -1)
end

--加载飞碟烟花
function M:loadType3()
    self:display("evefireworkput/firework/3/1.png")
    local shadow = D.img("evefireworkput/firework/3/shadow.png"):to(self, -1):p(cc.p(self:cw() / 2, self:ch()/2 - 5))
    self._shadow = shadow
    --加载引线画板
    self:loadWireRender(cc.p(74.6, 71.6), 1)
    --加载火星子
    self:loadFire(cc.p(83, 86.4), 1)
end

--加载窜天猴烟花
function M:loadType4()
    self._wireTb = {}
    local function loadAlone(type, pos)
        local firework1 = D.img("evefireworkput/firework/4/"..type..".png"):to(self):p(pos)
        local stick = D.img("evefireworkput/firework/4/stick.png"):to(firework1, -1):p(9.8, -11.8)
        --加载引线画板
        self:loadWireRender(cc.p(28, -3.7), -1, firework1)
        --加载火星子
        self:loadFire(cc.p(35, -15), -1, firework1)

        table.insert(self._fireworkTb, firework1)
    end
    loadAlone(1, cc.p(0 - 35, 20))
    loadAlone(2, cc.p(0, 20))
    loadAlone(3, cc.p(0 + 35, 20))

    local shadow = D.img("evefireworkput/firework/4/shadow.png"):to(self, -1):p(cc.p(-10, -55))
    self._shadow = shadow
end

--隐藏影子
function M:shadowHide()
    self._shadow:hide()
end

--影子显示
function M:shadowShow()
    self._shadow:show()
end

--切换影子父节点
function M:shadowChangeParent()
    Tools:resetParent(self._shadow,self._mainLayer._bgNodeNear, self:z()-1)
end

--烟花绽放
function M:fireworkBlossom()
    self["blossom" .. self._type](self)
end

--播放绽放音效
function M:playBoomEffect()
    local num = self._type + 1
    soundEffect["playEffectsfx0570900" .. num](soundEffect)
end

--擦除引线
function M:earseWire(fire, index)
    if fire._earseUpdate then return end
    fire._earseUpdate = A.cycle({
        {"Delay", 1/60},
        {"fn", function ()
            local render = self._renderTextureTb[index]
            local pos = render:getParent():convertToNodeSpace(fire:worldpoint())
            -- 绘图
            render:begin()
            local node = D.img("common/help.png"):p(pos)
            node:setBlendFunc(GL_ZERO, GL_ONE_MINUS_SRC_ALPHA)
            node:visit()
            render:endToLua()
        end}
    }):at(self)
end

--停止擦除引线
function M:stopEarseWire(fire)
    if fire._earseUpdate then 
        fire:stopAction(fire._earseUpdate)
        fire._earseUpdate = nil
    end
end

--引线点火
function M:fireAct(offsetP, callBack)
    self._layer:maskFadeIn()
    local newPos = self:worldpoint()
    local smokeParticle = Tools:newParticle("particle/low_smoke.plist", newPos.x, newPos.y):to(self._layer, self:z() - 1)
    Tools:insertParticleTb(self._layer, smokeParticle)
    for i, fire in ipairs(self._fireTb) do
        fire:line({
            { "Delay", (i - 1) * 0.1 },
            {"fn", function ()
                offsetP = ifnil(offsetP, cc.p(-20, -5))
                fire:cycle({
                    { "image", "evefireworkput/firework/fire/", 4, 1 / 15 }
                })
                --擦除引线
                self:earseWire(fire, i)
                local time = 0.6
                fire:line({
                    { "moveBy", time, offsetP },
                    { "union", {
                        { "fadeto", 0.2, 0 },
                        { "scaleto", 0.2, 0 },
                    } },
                    { "hide" },
                    { "fn", function()
                        fire:stopAllActions()
                        --停止擦除引线
                        self:stopEarseWire(fire)
                        smokeParticle:stopSystem()
                        smokeParticle:line({
                            { "delay", 1 },
                            { "remove",}
                        })
                        if i == 1 and callBack then
                            callBack()
                        end
                    end }
                })
            end}
        })
    end
end

--孔雀烟花绽放
function M:blossom1()
    --引线点火
    self:fireAct(cc.p(-20, -5), function ()
        local configTb = { 
            { pos = ccp(86.7, 71.2), angle = 180 },{ pos = ccp(39.2, 59.8), angle = 150 },
            { pos = ccp(135.7, 55.8), angle = 210 },
            { pos = ccp(10.2, 22.1), angle = 110 },{ pos = ccp(170.4, 19.8), angle = 250 },
        }
        for i, v in ipairs(configTb) do
            local fire = D.img("evefireworkput/firework/1/1/1.png"):to(self, -1):p(v.pos):rotate(v.angle):anchor(cc.p(0.5, 0.9)):scale(0)
            if i == 1 then
                fire._id = math.random(1, 4)
                --孔雀烟花环境亮起来
                self:lightShow()
                self:blossom1FireAct(fire, function ()
                    -- 孔雀烟花停止
                    self:blossom1Over()
                end)
            else
                fire._id = i - 1
                self:blossom1FireAct(fire)
            end
        end
        local num = 0.8
        self:cycle({
            { "moveBy", 1 / 60, cc.p(2 * num, 0) },
            { "moveBy", 1 / 60, cc.p(-2 * num, 0) },
            { "moveBy", 1 / 60, cc.p(3 * num, 0) },
            { "moveBy", 1 / 60, cc.p(-3 * num, 0) },
        })
    end)
end

--颜色渐变
function M:fireColorChange(fire)
    local fireIdTb = { 1, 2, 3, 4 }
    fireIdTb = T.shuffle(fireIdTb, 5)
    local action1 = A.cycle({
        { "image", "evefireworkput/firework/1/" .. fireIdTb[fire._id] .. "/", 7, 1 / 15 },
    }):at(fire)
    fire:cycle({
        { "fadeto", 0.8, 255 },
        { "Delay", 0.2 },
        { "fadeto", 1, 0 },
        { "fn", function()
            fire._id = (fire._id + 1) <= 4 and (fire._id + 1) or 1
            fire:stopAction(action1)
            action1 = A.cycle({
                { "image", "evefireworkput/firework/1/" .. fireIdTb[fire._id] .. "/", 7, 1 / 15 },
            }):at(fire)
        end },
    })

    local nextId = (fire._id + 1) <= 4 and (fire._id + 1) or 1
    local action2 = A.cycle({
        { "image", "evefireworkput/firework/1/" .. fireIdTb[nextId] .. "/", 7, 1 / 15 },
    }):at(fire._fireNext)
    fire._fireNext:cycle({
        { "fadeto", 1, 0 },
        { "fn", function()
            nextId = (nextId + 1) <= 4 and (nextId + 1) or 1
            fire._fireNext:stopAction(action2)
            action2 = A.cycle({
                { "image", "evefireworkput/firework/1/" .. fireIdTb[fire._id] .. "/", 7, 1 / 15 },
            }):at(fire._fireNext)
        end },
        { "fadeto", 0.8, 255 },
        { "Delay", 0.2 },
    })
end

--孔雀烟花的动作
function M:blossom1FireAct(fire,  callBack)
    local helpFire = D.img("evefireworkput/firework/1/1/1.png"):to(self, -1):p(fire:p()):rotate(fire:rotate()):anchor(cc.p(0.5, 0.9)):hide()
    local newPos   = helpFire:worldpoint()
    local nextP    = helpFire:convertToWorldSpace(cc.p(42, -49))
    --孔雀烟花粒子
    self:blowUpParticleMove(newPos, nextP)
    local fireNext = D.img("evefireworkput/firework/1/1/1.png"):to(fire, -1):p(fire:cw() / 2, fire:ch() / 2):opacity(0)
    fire._id = math.random(1, 4)
    fire._fireNext = fireNext
    --颜色渐变
    self:fireColorChange(fire)
    fire:opacity(0)
    fire:line({
        { "union", {
            { "easing", "sinein", { "scaleto", 0.5, 1 } },
            { "fadeto", 1, 255 }
        } },
        { "delay", 3 },
        { "fn", function()
            self._isOver = true
            self._layer:maskFadeOut()
            if callBack then
                callBack()
            end
        end },
        { "union", {
            { "scaleto", 1.5, 0 },
            { "fadeto", 1, 0 }
        } },
    })
end

--孔雀烟花环境亮起来
function M:lightShow()
    --亮起来
    self._layer._light:line({
        { "fadeto", 1.6, 200 },
        { "fn", function()
            self._layer._light:cycle({
                { "fadeto", 0.8, 180 },
                { "fadeto", 0.8, 200 },
            })
        end }
    })
end

--孔雀烟花环境暗下来
function M:lightHide()
    self._layer._light:stopAllActions()
    self._layer._light:line({
        { "fadeto", 1, 0 },
    })
end

--孔雀烟花粒子
function M:blowUpParticleMove(startP, endP)
    if self._isOver then return end
    local particle = Tools:newParticle("particle/low_kongque.plist", startP.x, startP.y):to(self._layer, self:z())
    Tools:insertParticleTb(self._layer, particle)
    particle:line({
        { "moveto", 0.5, endP },
        { "fn", function()
            --求两点间任意点的坐标
            local p1 = Tools:getPointBetweenTwo(startP, endP)
            local particle1 = Tools:newParticle("particle/low_kongque_boom.plist", p1.x + math.random(-80, 80), p1.y):to(self._layer, self:z())
            Tools:insertParticleTb(self._layer, particle)
            self:insertParticleTb(particle1)
            --求两点间任意点的坐标
            local p2 = Tools:getPointBetweenTwo(startP, endP)
            local particle1 = Tools:newParticle("particle/low_kongque_boom2.plist", p2.x + math.random(-80, 80), p2.y):to(self._layer, self:z())
            Tools:insertParticleTb(self._layer, particle1)
            self:insertParticleTb(particle1)
            particle:stopSystem()
            self:blowUpParticleMove(startP, endP)
        end },
        { "delay", 1 },
        { "remove",}
    })
end

-- 孔雀烟花停止
function M:blossom1Over()
    --孔雀烟花环境暗下来
    self:lightHide()
    self:stopAllActions()
    self:line({
        { "delay", 1 },
        { "fadeto", 0.5, 0 },
        { "fn", function()
            --ui退场
            self._layer:uiEnter()
        end },
        { "remove" }
    })
    self._shadow:line({
        { "delay", 1 },
        { "fadeto", 0.5, 0 },
    })
end


---------------------------
-- 彩菊烟花
---------------------------
function M:blossom2()
    --引线点火
    self:fireAct(cc.p(-30, -17), function()
        --加载采菊烟花粒子
        self:loadBlossom2Particle()
        --加载采菊烟花效果
        self:loadFireworkEffect2()
        --采菊烟花开始帧动画
        self:blossom2Ani()

        local dis1    = 100
        local dis2    = 50
        local height  = 10
        local time    = 1
        self:line({
            { "scaleto", time, 1.06 },
            { "scaleto", time * 0.8, 0.9 },
            { "scaleto", time * 0.7, 1.06 },
            { "scaleto", time * 0.6, 0.9 },
            { "scaleto", time * 0.5, 1 },
        })
        self:line({
            { "sinBy", time, ccp(    dis1, -dis2), height, 2 },
            { "sinBy", time* 0.8, ccp(    0, dis2*2), height, 2 },
            { "sinBy", time* 0.7, ccp(    -dis1*2, -dis2 * 2), height, 2 },
            { "sinBy", time* 0.6, ccp(    0, dis2 * 2), height, 2 },
            { "sinBy", time* 0.5, ccp(    dis1, -dis2), height, 2 },
            { "fn", function ()
                --采菊烟花结束
                self:blossom2Over()
            end}
        })
    end)
end

--采菊烟花结束
function M:blossom2Over()
    local dis1    = 100
    local dis2    = 50
    local height = 10
    local time    = 1
    local function stopAct(act)
        if act then
            self:stopAction(act)
        end
    end
    local action1 = A.cycle({
        { "sinBy", time * 0.4, ccp(    dis1, -dis2), height, 2 },
        { "sinBy", time * 0.4, ccp(    0, dis2 * 2), height, 2 },
        { "sinBy", time * 0.4, ccp(    - dis1 * 2, -dis2 * 2), height, 2 },
        { "sinBy", time * 0.4, ccp(    0, dis2 * 2), height, 2 },
        { "sinBy", time * 0.4, ccp(    dis1, -dis2), height, 2 },
    }):at(self)
    local action2 = A.cycle({
        { "scaleto", time * 0.4, 1.06 },
        { "scaleto", time * 0.4, 0.9 },
        { "scaleto", time * 0.4, 1.06 },
        { "scaleto", time * 0.4, 0.9 },
        { "scaleto", time * 0.4, 1 },
    }):at(self)
    self:line({
        { "Delay", 1.5 },
        { "fn", function()
            stopAct(action1)
            stopAct(action2)
            --停止加载采菊烟花粒子
            self:stopBlossom2Particle()
            --遮罩消失
            self._layer:maskFadeOut()
            --停止采菊烟花效果
            self:stopFireworkEffect2()
            --停止采菊烟花帧动画
            self:stopBlossom2Ani()
        end },
    })
end

--加载采菊烟花粒子
function M:loadBlossom2Particle()
    local pos = cc.p(55.2, 65.8)
    local particle1 = Tools:newParticle("particle/low_flower.plist", pos.x, pos.y):to(self, 10)
    local particle2 = Tools:newParticle("particle/low_flower_center.plist", pos.x, pos.y):to(self, 10)
    Tools:insertParticleTb(self, particle1)
    Tools:insertParticleTb(self, particle2)
    self._particle1 = particle1
    self._particle2 = particle2
    self:insertParticleTb(particle1)
    self:insertParticleTb(particle2)
end

--停止加载采菊烟花粒子
function M:stopBlossom2Particle()
    if self._particle1 then
        self._particle1:stopSystem()
    end
    if self._particle2 then
        self._particle2:stopSystem()
    end
end

--加载采菊烟花效果
function M:loadFireworkEffect2()
    local effect1 = D.img("evefireworkput/firework/3/fire/1/0.png"):scaleX(1.5):to(self, 1):p(58, 52.8):opacity(0):bindTouch()
    local vortex = D.img("evefireworkput/firework/3/fire/1/0.png"):to(effect1, 1):p(effect1:cw() / 2, effect1:ch() / 2):scale(0):opacity(0)--:opacity(0)    
    self._vortex = vortex
    vortex:cycle({
        { "rotateBy", 0.5, 360 }
    })
    vortex:line({
        { "union", {
            { "fadeto", 2, 250 },
            { "scaleto", 1, 0.6 },
        } }
    })
    --甩开的火花
    local fire = D.img("evefireworkput/firework/3/fire/1/1.png"):to(self, 1):p(56, 49):opacity(0):scale(0.95)
    self._fire = fire
    fire:cycle({
        { "image", "evefireworkput/firework/3/fire/1/", 8, 1 / 15 }
    })
    fire:line({
        { "fadeto", 2, 255 },
    })
end

--停止采菊烟花效果
function M:stopFireworkEffect2()
    self._fire:line({
        { "fadeto", 1, 0 },
    })
    self._vortex:line({
        { "fadeto", 1, 0 },
    })
end

--采菊烟花开始帧动画
function M:blossom2Ani()
    self:line({
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 9 },
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 10 },
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 11 },
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 12 },
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 13 },
        { "image", "evefireworkput/firework/2/act/", 3, 1 / 14 },
        { "fn", function()
            self._aniAct = A.cycle({
                { "image", "evefireworkput/firework/2/act/", 3, 1 / 15 },
            }):at(self)
        end }
    })
end

--停止采菊烟花帧动画
function M:stopBlossom2Ani()
    if self._aniAct then
        self:stopAction(self._aniAct)
        self._aniAct = nil
        self:line({
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 10 },
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 9 },
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 8 },
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 7 },
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 6 },
            { "image", "evefireworkput/firework/2/act/", 3, 1 / 5 },
            { "fn", function()
                self:stopAllActions()
                self:display("evefireworkput/firework/2/1.png")
            end }
        })
        self:line({
            { "fadeto", 1, 0 },
            { "fn", function()
                --ui进场
                self._layer:uiEnter()
            end },
            { "remove" }
        })
    end
end

--星星移动
function M:starMove(node, controlNode, dis, dis1)
    function creatStar(pos1, pos2)
        local angle = PT.quadAngle(pos1, pos2)
        local dis1 = dis

        local ddd = D.img("common/star.png"):to(self._layer, 10):p(pos1):scale(math.random(80, 200) / 100)
        local colrRGBTb = { cc.c3b(233, 242, 255), cc.c3b(255, 181, 222) }
        ddd:setColor(T.random(colrRGBTb))
        --已知三角形的两点坐标,和三个边长,求第三点的坐标  point1：以此来判定下一点 point2：第二点  lenth1：point1距离所求点的距离  lenth2：point2距离所求点的距离
        local endP = Tools:calculateTriangleThirdPoint(pos1, pos2, dis, dis1)
        ddd:line({
            { "union", {
                { "moveto", 0.3, endP },
                { "scaleto", 0.3, 0 }
            } },
            { "remove",}
        })
    end
    local pos1 = controlNode:worldpoint()
    local pos2 = node:worldpoint()
    local dis = 10
    creatStar(cc.p(pos1.x, pos1.y), pos2)
    creatStar(cc.p(pos1.x + math.random(-dis, dis), pos1.y + math.random(-dis, dis)), pos2)
    creatStar(cc.p(pos1.x + math.random(-dis, dis), pos1.y + math.random(-dis, dis)), pos2)
    creatStar(cc.p(pos1.x + math.random(-dis, dis), pos1.y + math.random(-dis, dis)), pos2)
    creatStar(cc.p(pos1.x + math.random(-dis, dis), pos1.y + math.random(-dis, dis)), pos2)
end

--加载旋转粒子
function M:loadRotateEffect(node)
    local helpNodeTb = {}
    local posTb = {cc.p(199.5, 261.6), cc.p(142.8, 201.3), cc.p(261.7, 203.9), cc.p(203.3, 147.3),}
    for i, v in ipairs(posTb) do
        local help = D.img("common/help.png"):to(node):p(v):opacity(0)
        table.insert(helpNodeTb, help)
    end

    --直角边
    local r = 80
    local d = -100
    local aaa = (r * r + d * d)
    local dis = math.sqrt(aaa)
    -- self:cycle({
    --     {"Delay", 1/60},
    --     {"fn", function ()
    --         for i, v in ipairs(helpNodeTb) do
    --             self:starMove(node,v, d, dis)
    --         end
    --     end}
    -- })

    local boomPTb = {}
    local posTb = { cc.p(200.1, 306.3), cc.p(84.7, 203.2), cc.p(317.4, 201.9), cc.p(204.6, 91.1),}
    for i, v in ipairs(posTb) do
        local help = D.img("common/help.png"):to(node):p(v):opacity(0)
        table.insert(boomPTb, help)
    end
    local function boomP()
        self:line({
            { "delay", math.random(30, 50) / 100 },
            { "fn", function()
                for i, v in ipairs(boomPTb) do
                    local pos = v:worldpoint()
                    local particle1 = Tools:newParticle("particle/low_kongque_boom.plist", pos.x, pos.y):to(self._layer, self:z())
                    Tools:insertParticleTb(self._layer, particle1)
                    local particle2 = Tools:newParticle("particle/low_kongque_boom2.plist", pos.x, pos.y):to(self._layer, self:z())
                    Tools:insertParticleTb(self._layer, particle2)
                    self:insertParticleTb(particle1)
                    self:insertParticleTb(particle2)
                end
                if not self._isOver then
                    boomP()
                end
            end }
        })
    end
    boomP()
end

---------------------------
-- 飞碟烟花
---------------------------
function M:blossom3()
    self:bindTouch()
    self:fireAct(cc.p(-18, -18), function()
        local pos = cc.p(55.2, 50.8)
        local centerParticle = Tools:newParticle("particle/low_ufo.plist", pos.x, pos.y + 5):to(self, 10)
        Tools:insertParticleTb(self, centerParticle)
        self._centerParticle = centerParticle
        --黑幕遮罩消失
        self._layer:maskFadeOut()
        --画面上移
        self._layer:screenUp()
        --飞碟影子消失
        self:blossom3ShadowHide()
        --加载飞碟烟花效果
        self:loadFireworkEffect3()
        --飞碟烟花路线
        self:blossom3FlyRoute()
        --飞碟烟花开始帧动画
        self:blossom3Ani()
        local dis    = 0
        local height = 10
        local time = 1
        self:line({
            { "sinBy", time, ccp(    dis, 10), height, 2 },
            { "sinBy", time * 0.8, ccp(    -dis, 10), height, 2 },
            { "sinBy", time * 0.6, ccp(    dis, 10), height, 2 },
            { "sinBy", time * 0.4, ccp(    -dis, 10), height, 2 },
            { "fn", function ()
                self:cycle({
                    { "sinBy", time * 0.5, ccp(    0, -20), height, 2 },
                    { "sinBy", time * 0.5, ccp(    0, 20), height, 2 },
                })
                self:line({
                    {"Delay", 1},
                    {"fn", function ()
                        self._isOver = true
                        centerParticle:stopSystem()
                        --停止飞碟烟花帧动画
                        self:stopBlossom3Ani()
                        --停止飞碟烟花效果
                        self:stopFireworkEffect3()
                        -- 飞碟烟花停止
                        self:blossom3Over()
                    end},
                })
            end}
        })
    end)
end

--加载飞碟烟花效果
function M:loadFireworkEffect3()
    --压扁旋转
    local effect1 = D.img("evefireworkput/firework/3/fire/1/0.png"):scaleX(-1.5):to(self, 1):p(58, 52.8):opacity(0):bindTouch()
    local vortex = D.img("evefireworkput/firework/3/fire/1/0.png"):to(effect1, 1):p(effect1:cw() / 2, effect1:ch() / 2):scale(0):bindTouch():opacity(0)--:opacity(0)    
    self._vortex  = vortex
    vortex:cycle({
        { "rotateBy", 0.5, 360 }
    })
    vortex:line({
        { "union", {
            { "fadeto", 2, 255 },
            { "scaleto", 1, 0.6 },
        } }
    })
    --加载旋转粒子
    self:loadRotateEffect(vortex)

    --火花
    local fire = D.img("evefireworkput/firework/3/fire/1/1.png"):to(self, 1):p(56, 49):opacity(0)
    self._fire = fire
    fire:cycle({
        { "image", "evefireworkput/firework/3/fire/1/", 8, 1 / 15 },
        { "fn", function()
            vortex:display("evefireworkput/firework/3/fire/2/0.png")
        end },
        { "image", "evefireworkput/firework/3/fire/2/", 8, 1 / 15 },
        { "fn", function()
            vortex:display("evefireworkput/firework/3/fire/3/0.png")
        end },
        { "image", "evefireworkput/firework/3/fire/3/", 8, 1 / 15 },
        { "fn", function()
            vortex:display("evefireworkput/firework/3/fire/1/0.png")
        end },
    })
    fire:line({
        { "fadeto", 2, 255 },
    })
end

-- 停止飞碟烟花效果
function M:stopFireworkEffect3()
    self._fire:line({
        { "fadeto", 2, 0 },
    })
    self._vortex:line({
        { "fadeto", 2, 0 },
    })
end

--飞碟影子消失
function M:blossom3ShadowHide()
    --切换影子父节点
    self:shadowChangeParent()
    self._shadow:line({
        { "union", {
            { "line", {
                { "moveBy", 0.4, cc.p(100, 10) },
                { "moveBy", 0.4, cc.p(-200, -10) },
            } },
            { "scaleto", 0.8, 0 },
        } },
        { "hide" }
    })
end

--飞碟影子出现
function M:blossom3ShadowShow()
    --影子
    self._shadow:py(self._shadow:py() + 30)
    self._shadow:px(self._shadow:px() + 100)
    self._shadow:line({
        { "delay", 1 },
        { "show" },
        { "scaleto", 0.7, 1 },
        { "fadeto", 0.3, 0 },
        { "remove",}
    })
end

--飞碟烟花路线
function M:blossom3FlyRoute()
    -- 创建点集
    local array = { cc.p(0, 0), cc.p(100, 50), cc.p(-100, 70), cc.p(150, 100), cc.p(-150, 120), cc.p(200, 140), cc.p(0, V.h_2 - 120) }
    -- 构建动作
    local action = A.actionCardinalSpline({
        time     = 2,
        tension   = -1,
        points    = array,
        relative = false,
        fnCallback = function(sender)
            -- self._isOver = true
        end,
    })
    self._layer._putAreaNode:runAction(action)
    self:line({
        { "scaleto", 0.4, 0.9 },
        { "scaleto", 0.4, 1.1 },
        { "scaleto", 0.4, 0.8 },
        { "scaleto", 0.4, 1.2 },
        { "scaleto", 0.4, 1 },
    })
end

--飞碟烟花开始帧动画
function M:blossom3Ani()
    self:line({
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 9 },
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 10 },
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 11 },
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 12 },
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 13 },
        { "image", "evefireworkput/firework/3/act/", 3, 1 / 14 },
        { "fn", function()
            self._aniAct = A.cycle({
                { "image", "evefireworkput/firework/3/act/", 3, 1 / 15 },
            }):at(self)
        end }
    })
end

--停止飞碟烟花帧动画
function M:stopBlossom3Ani()
    if self._aniAct then
        self:stopAction(self._aniAct)
        self._aniAct = nil
        self:line({
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 14 },
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 13 },
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 12 },
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 11 },
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 10 },
            { "image", "evefireworkput/firework/3/act/", 3, 1 / 9 },
            { "fn", function()
                self:stopAllActions()
                self:display("evefireworkput/firework/3/1.png")
            end }
        })
    end
end

-- 飞碟烟花停止
function M:blossom3Over()
    self._layer._putAreaNode:line({
        { "moveto", 2, cc.p(0, 0) }
    })
 
    --画面下移
    self._layer:screenDown(function ()
        self:line({
            { "fadeto", 0.5, 0 },
            { "remove" },
            { "fn", function()
                --ui退场
                self._layer:uiEnter()
            end },
        })
    end)
    --飞碟影子出现
    self:blossom3ShadowShow()
end


---------------------------
-- 窜天猴烟花
---------------------------
function M:blossom4()
    self:bindTouch()
    self:fireAct(cc.p(-18, 18), function()
        local posTb = { cc.p(-200, 0), cc.p(0, 0), cc.p(200, 0),}
        local angleTb = { -30, - 10, 0,}
        local delayTb = {0.1, 0, 0.1}
        local timeTb = { 1, 0.5, 1 }
        local higeTb = {ccp(250, 300), ccp(300, 350), ccp(250, 300), }
        for i, firework in ipairs(self._fireworkTb) do
            Tools:changeAnchorP(firework, cc.p(0.5, -0.5))
            firework:line({
                { "Delay", delayTb[i]},
                { "scaleto", 0.2, 1, 0.8},
                { "fn", function()
                    local path = i == 2 and "low_monkey_tuowei" or "low_monkey_tuowei2"
                    local pos = cc.p(firework:cw() / 2, 80)
                    local flyParticle = Tools:newParticle("particle/" .. path .. ".plist", pos.x, pos.y):to(firework, 10)
                    Tools:insertParticleTb(self, flyParticle)
                    firework._flyParticle = flyParticle
                end },
                { "scaleto", 0.2, 1, 1.1 },
                { "union", {
                    {"moveBy", timeTb[i], cc.p(posTb[i].x, math.random(higeTb[i].x, higeTb[i].x))},
                    { "scaleto", 0.1, 1 },
                    {"rotateTo", 0.5, angleTb[i]}
                }},
                {"fn", function ()
                    local path = i == 2 and "low_monkey" or "low_monkey2"
                    local pos = firework:worldpoint()
                    local centerParticle = Tools:newParticle("particle/" .. path .. ".plist", pos.x, pos.y):to(self._layer, 100)
                    Tools:insertParticleTb(self._layer, centerParticle)
                    self:insertParticleTb(centerParticle)
                end},
                { "scaleto", 0.1, 1.2},
                { "hide",},
                { "fn", function ()
                    --移除粒子
                    Tools:removeParticle(firework._flyParticle)
                end},
                { "remove" }
            })
        end
        self._layer:maskFadeOut()
        --画面上移
        self._layer:screenUp(1.5, -700)
        --隐藏影子
        self:shadowHide()
        self:line({
            {"delay", 2},
            {"fn", function ()
                --画面下移
                self._layer:screenDown(function ()
                    --ui退场
                    self._layer:uiEnter()
                end)
            end}
        })
    end)
end

--加入粒子表
function M:insertParticleTb(particle)
    table.insert(self._particleTb, particle)
end




--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    -- self:removeParticle(self._centerParticle)
    -- self:removeParticle(self._particle1)
    -- self:removeParticle(self._particle2)
    for k, v in pairs(self._particleTb) do
        Tools:removeParticle(v)
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
