--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 选项类
----------------------
local M     = classSpriteTouch("Item")
M.TAG       = "Item"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = true
    --类型
    self._type      = ifnil(params.type, 1)
    -- 是否可以结束
    self._isEnd     = false
    --缩放大小
    self._scaleSize = 1
    --滚动栏
    self._bar       = params.bar
    --主层
    self._mainLayer = params.mainLayer
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    local sizeTb = {0.45, 0.7, 0.75, 0.6}
    self._scaleSize = sizeTb[self._type]
    local firework = import("app.evefireworkput.node.put.Firework").new({
        layer      = self,
        type       = self._type,
        needFire   = false
    }):to(self):p(self:cw() / 2, self:ch() / 2):scale(self._scaleSize)
    firework._shadow:hide()
    self._item = firework
end

--创建移动
function M:creatMove(pos)
    if self._moveItem then return end
    local moveItem = import("app.evefireworkput.node.put.Firework").new({
        mainLayer   = self._mainLayer,
        layer       = self._layer,
        type        = self._type,
    }):to(self._layer._putAreaNode, 999):p(pos)
    --隐藏影子
    moveItem:shadowHide()
    --火星子隐藏
    moveItem:fireHide()
    self._moveItem = moveItem
    --显示位置粒子
    self._layer:resetPlaceParticle()
end

--图标隐藏
function M:itemHide()
    self._item:hide()
end

--图标显示
function M:itemShow()
    self._item:show()
end

--碰撞检测
function M:collisionDetection()
    local targetP = cc.p(V.w_2, 150)
    local pos = self._moveItem:worldpoint()
    local dis = ccpDistance(pos, targetP)
    local disWeight = math.abs(pos.x - targetP.x)
    local disHigh = math.abs(pos.y - targetP.y)
    if dis < 250 or (disHigh < 600 and disWeight < 250) then
        --放置烟花
        self:putFirework()
    else
        --回到盘子里
        self:goBack()
    end
end


--放置烟花
function M:putFirework()
    if not self._moveItem then return end
    local targetP = self._moveItem._type ~= 4 and cc.p(V.w_2, 50) or cc.p(V.w_2, 100)
    --移除自身
    self:removeSelf()
    local  size = 1
    Tools:changeAnchorP(self._moveItem, cc.p(0.5, 0))
    --隐藏影子
    self._moveItem:shadowHide()   
    local item = self._moveItem
    self._moveItem:line({
        {"union", {
            {"jumpto", 0.5, targetP, 100, 1},
            { "scaleTo",0.5, 1},
        }},
        {"fn", function ()
            -- 播放音效[sfx05709001]放置烟花盒子
            soundEffect:playEffectsfx05709001()
            --火星子出现
            item:fireShow()
            --播放绽放音效
            item:playBoomEffect()
            if item._type ~= 2 then
                --影子显示
                item:shadowShow() 
            end
            if item._type == 4 then
               --切换影子父节点
                item:shadowChangeParent() 
            end
        end},
        { "scaleto", 0.1, size * 1.1, size * 0.95 },
        { "scaleto", 0.1, size * 0.98, size * 1.05 },
        { "scaleto", 0.1, size * 1.05, size * 0.95 },
        { "scaleto", 0.1, size, size },
        {"fn", function ()
            --烟花绽放
            item:fireworkBlossom()
        end}
    })
end

--移除自身
function M:removeSelf()
    local time = 0.4
    self:line({
        {"easing", "backin", {"scaleTo", time, 0}},
        {"hide"},
        {"fn", function ()
            self._bar._scrollView:removeItemFromScrollView(self)
            --ui退场
            self._layer:uiQuit()
        end},
        {"remove"},
    })
end

--返回
function M:goBack()
    if not self._moveItem then return end
    local worldPos = self:worldpoint()
    A.line({
        { "union", {
            { "scaleTo", 0.25, self._scaleSize * 0.8 },
            { "jumpto", 0.25, worldPos, 100, 1},
            { "fn", function()
                -- 音效[sfx05700008]
                soundEffect:playEffectsfx05700008()
            end }
        } },
        {"easing", "backout", { "scaleTo", 0.25, self._scaleSize },},
        {"hide"},
        { "fn", function()
            --图标显示
            self:itemShow()
            self._moveItem = nil
            self._layer._canTouch = true
        end },
        { "delay", 0.12 },
        { "remove" }
    }):at(self._moveItem)
end

-- 加载结点
function M:loadPageNode()
    
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._layer._canTouch then return end
    -- 音效[sfx05700001]
    soundEffect:playEffectsfx05700001()
    self._layer._canTouch = false
    self._isEnd = false
    self._item:scale(self._scaleSize * 1.2)
    self._startPos = ccp(x, y)
    -- 可穿透
    return SIGN_TOUCH_BEGAN_NO_SWALLOWS
end

function M:onTouchMoved(x, y, touches)
    local offset = ccpSub(self._startPos, ccp(x, y))
    if math.abs(offset.x) >= 40 or math.abs(offset.y) >= 40 then
        if not self._moveItem then
            self._isEnd = true
            self._bar._scrollView._canTouch = false
            self:creatMove(ccp(x, y))
            --图标隐藏
            self:itemHide()
        else
            self._moveItem:p(x - 50, y + 50)
            bb.si.Tool.limitRectMove({
                node = self._moveItem,
            -- marginTop = 80,
            -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
            })
            bb.si.Tool.limitButtonMove({node = self._moveItem})
            if self._type == 4 then
                local posY = self._moveItem:py()
                if posY > V.h - 130 then self._moveItem:py(V.h - 130) end
            end
        end
    else
        if self._moveItem then
            self._moveItem:p(x - 50, y + 50)
            bb.si.Tool.limitRectMove({
                node = self._moveItem,
            -- marginTop = 80,
            -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
            })
            bb.si.Tool.limitButtonMove({node = self._moveItem})
            if self._type == 4 then
                local posY = self._moveItem:py()
                if posY > V.h - 130 then self._moveItem:py(V.h - 130) end
            end
        end
    end
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    self._item:scale(self._scaleSize)
    if not self._isEnd then
        self._layer._canTouch = true
        return
    end
    --停止位置粒子
    self._layer:stopPlaceParticle()
    --碰撞检测
    self:collisionDetection()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
