--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    -- 阿拉伯语的标志位
    self._arFlag   = false
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)  
    -- 加载结点
    self:loadPageNode()
    -- 加载盘子和鱼
    self:loadPlate()
    -- 加载葱花
    self:loadGarlic()
    -- 加载鱼豉油
    self:loadJuice()
    -- 预加载帧动画
    self:prestrain()
    -- 去广告
    Tools:closeAd(true)
    -- 加载热油
    -- self:loadOil()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
   
end

-- 预加载帧动画
function M:prestrain()
    commonAct:addTexture("evefishingredient/add/oilfall/", 1, 25)
    commonAct:addTexture("evefishingredient/add/oilspread/", 1, 15)
    local fishParticle = P.newParticle("particle/zhureqi.plist"):p(250, 120):to(self._plate, 999):scale(1.2)
    Tools:insertParticleTb(self, fishParticle)
    self._fishParticle = fishParticle
end

-- 加载结点
function M:loadPageNode()
    -- 加载桌布
    local tablecloth = D.img("evefishingredient/tablecloth.png"):to(self):p(475 + X_OFFSET, 178.1)--:bindTouchLocate()
end

-- 加载盘子和鱼
function M:loadPlate()
    -- 加载盘子
    local plate = D.img("evefishingredient/show/plate.png"):to(self, 10):p(333.4 + X_OFFSET, 228.2)--:bindTouchLocate()
    self._plate = plate
    -- 加载调料
    self:loadIngredient()
    -- 加载鱼
    local fish  = D.img("evefishboil/claw/fish.png"):to(plate, 10):p(240.3, 152):scale(1.5)
    -- 加载底部的鱼鼓油
    local juicedown = D.img("evefishingredient/add/juicespread/1.png"):to(fish, -1):p(112, 60):scale(0.7)
    self._juicedown = juicedown
    -- 加载上层的鱼鼓油
    local juiceup = D.img("evefishingredient/add/juicesup/1.png"):to(fish):p(142, 65):scale(0.7):hide():opacity(0)
    self._juiceup = juiceup
    -- 加载最上成的热油
    local oilUp = D.img("evefishingredient/add/oilspread/1.png"):to(fish, 10):p(112, 60):scale(0.7):hide():opacity(0)
    self._oilUp = oilUp
    -- 加载高光
    local light = D.img("evefishingredient/add/light.png"):to(fish, 10):p(112, 60):scale(0.7):hide():opacity(0)
    self._light = light
end

-- 加载调料
function M:loadIngredient()
    for j = 3, 4 do 
        local scallion = D.img("evefishingredient/season/"..j..".png"):to(self._plate, 10):scale(1.5):p(240.3, 162)
        local pos = {ccp(184.3, 30), ccp(158.2, 15)}
        for i = 1, 2 do 
            local ginger = D.img("evefishingredient/season/"..i..".png"):to(scallion, -1):p(pos[i])
        end
    end
end

-- 加载葱花
function M:loadGarlic()
    local garlic = import("app.evefishadd.node.Garlic").new({
        layer    = self
    }):to(self, 200):p(323.5 + X_OFFSET, 465.6 + 450):bindTouch()
    self._garlic = garlic
end

-- 加载鱼豉油
function M:loadJuice()
    local juice = import("app.evefishadd.node.Juice").new({
        imgName = "evefishingredient/add/juicefall/1.png",
        layer    = self
    }):to(self, 9999):p(715 + X_OFFSET + 450, 280):bindTouch()
    self._juice = juice
end

-- 加载热油
function M:loadOil()
    local oil = import("app.evefishadd.node.Oil").new({
        imgName = "evefishingredient/add/pan/1.png",
        layer    = self
    }):to(self, 9999):p(880 + X_OFFSET + 450, 230):anchor(ccp(0.9, 0.5)):bindTouch()
    self._oil = oil
end

--所有退出
function M:allQuit()
    self._oil:quit(function ()
        -- 播放音效[sfx05704021]盘子居中展示
        soundEffect:playEffectsfx05704021()
        self._plate:line({
            { "jumpto", 0.5, cc.p(V.w_2, V.h_2), 100, 1 },
            { "fn", function()
                -- 加载居中展示的光和粒子
                Tools:loadLightAndParticle(self._plate, self, nil, 4, 2)
            end },
            { "delay", 2 },
            { "fn", function()
                --进入下个场景
                self:enterNextScene()
            end }
        })
    end)
end

--进入下个场景
function M:enterNextScene()
    G_DONE_FOOD_COPUNT = G_DONE_FOOD_COPUNT + 1
    if G_DONE_FOOD_COPUNT == 1 then
        game:enterScene("evekitchen", { enterNum = 2, fromWhere = 1 }, "fade", 0.5, COLOR3_WHITE)
        -- Tools.whiteEnterScene("evekitchen", self:getScene(), {enterNum = 2, fromWhere = 1})
    else
        G_DONE_FOOD_COPUNT = 0
        game:enterScene("eveputfood", {}, "fade", 0.5, COLOR3_WHITE)
        -- Tools.whiteEnterScene("eveputfood", self:getScene(), {})
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._fishParticle) then
        self._fishParticle:remove()
        self._fishParticle = nil
    end
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
