--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Juice")
M.TAG       = "JuiceNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 预加载帧动画
    self:prestrain()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    A.line({
        {"delay", 1.8},
        {"union",{
            {"easing", "ELASTICOUT", {"moveBy", .8, ccp(-450, 0)}, 2},
            {"fn", function()
                -- 播放配音
                soundVoice:playEffectv057089()
                -- 播放配音
                soundVoice:playEffectv057049()
                --音效
                soundEffect:playEffectsfx05700002()
            end},
        }},
        {"fn", function ()
            self._canTouch = true
            -- 开启引导
            guideFn:openGuide(self, 0.1, 3)
        end}
    }):at(self)
end

-- 加载结点
function M:loadPageNode()
    local under = D.img("evefishingredient/add/under.png"):to(self, -1):p(105, 30)
    self._under = under
end

-- 预加载帧动画
function M:prestrain()
    commonAct:addTexture("evefishingredient/add/juicefall/", 1, 18)
    commonAct:addTexture("evefishingredient/add/juicespread/", 1, 13)
    commonAct:addTexture("evefishingredient/add/juicesup/", 1, 15)
end

-- 放置成功
function M:putSucceed()
    self._canTouch = false
    local pos = ccp(435 + X_OFFSET, 360)
    A.line({
        {"moveTo", 0.3, pos},
        {"union",{
            {"imagerange", "evefishingredient/add/juicefall/", 1, 18, 0.1},
            {"fn", function ()
                -- 底部鱼鼓油铺开
                self:juiceDownAct()
                -- 上层的鱼鼓油铺开
                self:juiceUpAct()
            end}
        }},
        {"delay", 0.3},
        {"fn", function ()
            -- 标志位置换回来
            self:changeFlag()
            -- 结束返回
            self:back(false)
        end}
    }):at(self)
end

-- 油对移动
function M:juiceMoveAct()
    A.line({
        {"moveBy", 0.25, ccp(-40, 0)},
        {"moveBy", 0.5, ccp(80, 0)},
    }):at(self)
end

-- 上层的鱼鼓油铺开
function M:juiceUpAct()
    A.line({
        {"delay", 0.5},
        {"show"},
        {"fadein", 0.1},
        {"union",{
            {"imagerange", "evefishingredient/add/juicesup/", 1, 15, 0.1},
            {"fn", function()
                self:juiceMoveAct()
                --音效
                soundEffect:playEffectsfx05705010()
                -- 阿拉伯语的标志位
                self._layer._arFlag = true
            end},
        }},
    }):at(self._layer._juiceup)
end

-- 底部鱼鼓油铺开
function M:juiceDownAct()
    A.line({
        {"imagerange", "evefishingredient/add/juicespread/", 1, 13, 0.1},
    }):at(self._layer._juicedown)
end

-- 返回
function M:back(isFinish)
    isFinish = ifnil(isFinish, true)
    self._canTouch = false
    local pos = ccp(715 + X_OFFSET, 280)

    A.line({
        {"union",{
            {"jumpto", 0.3, pos, 50, 1},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700008()
            end},
        }},
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 20, 1},
            {"rotateTo", 0.2, 0},
            {"line", {
                {"delay", 0.02},
                {"fn", function()
                    self._under:show()
                    commonAct:nodeScale(self, 0.2, 0.2)
                end},
            }}
        }),
        {"fn", function ()
            self._canTouch = isFinish
            if not isFinish then 
                self:quit()
            end
        end}
    }):at(self)
end

--退场
function M:quit(callBack)
    self._canTouch = false
    --退场动作
    self:quitAction(callBack)
end

--退场动作
function M:quitAction(callBack)
    self:unbindTouch():stopAllActions()
    self:line({
        {"union",{
            {"moveby", 0.5, cc.p(V.w, 0)},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700007()
            end},
        }},
        {"fn", function()
            -- 加载热油
            self._layer:loadOil()
            if callBack then
                callBack()
            end
        end },
    })
end

-- 改变阿拉伯语重叠的标志位
function M:changeFlag()
    self._layer._arFlag = false
end


--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- 音效
    soundEffect:playEffectsfx05700001()
    self._under:hide()
    -- 关闭引导
    guideFn:stopGuide(self)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    if self:px() < 600 + X_OFFSET and self:px() > 157 + X_OFFSET and self:py() < 420 and self:py() > 130 then 
        -- 放置成功
        self:putSucceed()
    end
    self:p(x, y + 20)
    bb.si.Tool.limitRectMove({
        node      = self,
        marginTop = 0,
        boundingRect = cc.rect(20, 0, self:size().width, self:size().height - 50)
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end 
    if self:px() < 600 + X_OFFSET and self:px() > 157 + X_OFFSET and self:py() < 310 and self:py() > 130 then 
        
    else
        self:back()
        guideFn:openGuide(self, 0.1, 3, 1)
    end
    -- 开启引导
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
