--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Oil")
M.TAG       = "OilNode"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载节点
    self:loadNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    for i, v in ipairs(self._layer._garlic._eachTab) do
        Tools:resetParent(v, self._layer._plate, 93)
    end
    local time1
    local time2
    if device.language == "ar" then
        time1 = self:getVoiceTime("v057089", 0.6)
        time2 = self:getVoiceTime("v057054", 0.5)
    else
        time1 = 0
        time2 = 0
    end
    A.line({
        {"union",{
            {"easing", "ELASTICOUT", {"moveBy", .8, ccp(-450, 0)}, 2},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700002()
            end},
        }},
        {"fn", function ()
            self._canTouch = true
        end},
        {"delay", time1},
        {"fn", function ()
            -- 播放配音
            soundVoice:playEffectv057054()
            guideFn:openGuide(self, 0.1, 3, 1)
        end},
    }):at(self)
end

-- 加载节点
function M:loadNode()
    local panshadow = D.img("evefishingredient/add/panshadow.png"):to(self, -1):p(150, 75)
    self._panshadow = panshadow
    self._oilAct = A.cycle({
        {"imagerange", "evefishingredient/add/pan/", 1, 4, 0.1},
    }):at(self)
end

-- 放置成功
function M:putSucceed()
    -- 去广告
    Tools:closeAd(true)
    if self._oilAct then 
        self:stopAction(self._oilAct)
    end
    self._canTouch = false
    local pos = ccp(520 + X_OFFSET, 375)
    A.line({
        {"moveTo", 0.3, pos},
        {"union",{
            {"imagerange", "evefishingredient/add/panfall/", 1, 24, 0.1},
            {"fn", function ()
                -- 最上面的热油铺开
                self:oilAct()
            end},
        }},
        {"fn", function ()
            -- 结束返回
            self:back(false)
        end}
    }):at(self)
end


-- 最上面的热油
function M:oilAct()
    A.line({
        {"delay", 0.6},
        {"fn", function()
            -- 加载粒子
            self:loadParticle()
        end},
        {"fadein", 0.1},
        {"union", {
            {"fadeTo", 1.5, 150},
            {"imagerange", "evefishingredient/add/oilspread/", 1, 15, 0.1},
            {"line", {
                {"delay", 0.6},
                {"fn", function ()
                    self._particle1:remove()
                    --  加载粒子
                    self._particle2 = P.newParticle("particle/fish_oil_small.plist"):to(self._layer._plate, 999):p(235, 180):scale(1)
                    Tools:insertParticleTb(self, self._particle2)
                    self._particle:stopSystem()
                end}
            }},
            {"fn", function ()
                self:oilMoveAct()
            end}
        }},
        {"fn", function ()
            A.line({
                {"show"},
                {"fadein", 0.2},
            }):at(self._layer._light)
        end}
    }):at(self._layer._oilUp)
end

-- 加载粒子
function M:loadParticle()
    self._layer._oilUp:show()
    --  加载粒子
    self._particle1 = P.newParticle("particle/fish_oil_smoke.plist"):to(self._layer._plate, 999):p(235, 180):scale(1)
    --  加载粒子
    self._particle = P.newParticle("particle/fish_oil_big.plist"):to(self._layer._plate, 999):p(235, 180):scale(1)
    Tools:insertParticleTb(self, self._particl)
    Tools:insertParticleTb(self, self._particl1)
    --音效
    soundEffect:playEffectsfx05705011()
end

-- 获取时长
function M:getVoiceTime(fileName, t)
    local t = t or 2
    local time = NV.soundDuration("effect/"..fileName..".mp3", t)
    return time
end


-- 油对移动
function M:oilMoveAct()
    A.line({
        {"moveBy", 0.25, ccp(-40, 0)},
        {"moveBy", 0.55, ccp(100, 0)},
        {"moveBy", 0.3, ccp(-60, 0)},
    }):at(self)
end

-- 返回
function M:back(isFinish)
    isFinish = ifnil(isFinish, true)
    self._canTouch = false
    local pos = ccp(880 + X_OFFSET, 230)
    if not isFinish then 
        pos = ccp(880 + X_OFFSET, 150)
        self._panshadow:py(230)
    end
    -- 获取动作集合
    local action = self:actGather()
    A.line({
        {"union",{
            {"jumpto", 0.3, pos, 50, 1},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700008()
            end},
        }},
        action,
        {"fn", function ()
            self._canTouch = isFinish
            if not isFinish then 
                self._layer:allQuit()
            end
        end}
    }):at(self)
end

-- 回弹动作集合
function M:actGather()
    local action = A.union({
        {"jumpBy", 0.2, cc.p(0, 0), 20, 1},
        {"rotateTo", 0.2, 0},
        {"line", {
            {"delay", 0.02},
            {"fn", function()
                self._panshadow:show()
                commonAct:nodeScale(self, 0.2, 0.2, 1)
            end},
        }}
    })
    return action
end

--退场
function M:quit(callBack)
    self._canTouch = false
    --退场动作
    self:quitAction(callBack)
end

--退场动作
function M:quitAction(callBack)
    local time
    if device.language == "ar" then
    time = self:getVoiceTime("v057054", 2)
    else
        time = 0
    end
    self:unbindTouch():stopAllActions()
    self:line({
        {"delay", time},
        {"fn",function()
            soundVoice:playEffectv057047()
        end},
        {"union",{
            {"moveby", 0.5, cc.p(V.w, 0)},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700007()
            end},
        }},
        {"fn", function()
            if callBack then
                callBack()
            end
        end},
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self._panshadow:hide()
    -- 关闭引导
    guideFn:stopGuide(self)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    if self:px() < 600 + X_OFFSET and self:px() > 157 + X_OFFSET and self:py() < 420 and self:py() > 130 then 
        -- 放置成功
        self:putSucceed()
    end
    self:p(x, y)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end 
    if self:px() < 600 + X_OFFSET and self:px() > 157 + X_OFFSET and self:py() < 310 and self:py() > 130 then 
    else
        self:back()
        guideFn:openGuide(self, 0.1, 3, 1)
    end
    -- 开启引导
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    -- Tools:removeParticleTb(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._particle) then
        self._particle:remove()
        self._particle = nil
    end
    if not tolua.isnull(self._particle1) then
        self._particle2:remove()
        self._particle2 = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
