--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch     = true
    -- 虚线表
    self._circleTab    = {}
    -- 配料表
    self._scallionTab  = {}
    -- 计数
    self._count        = 0
    -- 是否停止烟雾
    self._isStopSmoke  = false 
    -- 烟雾索引
    self._smokeIndex   = 0      
    -- 盘中物表
    self._plateTab     = {}     
    -- 锅表
    self._potTab       = {}       
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    self._node:scale(1.1)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    guideFn:openGuide(self._btn, 0.1, 3)
    -- 加载盖子
    self:loadCover(1.2)
    -- 播放配音
    soundVoice:playEffectv057043()
end

-- 加载结点
function M:loadPageNode()
    -- 加载灶台
    self:loadOven()
    -- 加载按钮
    self:loadBtn()
    -- 加载蒸
    self:loadSteam()
    -- 加载爪子
    self:loadClaw()
    -- 鱼进场
    -- self:shotMove()
end


--镜头移动
function M:shotMove()
    A.line({
        {"union",{
            {"scaleTo", 0.5, 1},
            {"moveBy", 0.5, ccp(0, 0)}
        }},
        {"fn", function ()
            -- 加载盘子
            self:loadPlate()
            -- 盘子进场
            self._plate:plateEnter()
            -- 蒸进场
            self._steam:steamEnter()
        end}
    }):at(self._node)
end

-- 加载鱼
function M:loadPlate()
    -- 加载盘子
    local plate = import("app.evefishboil.node.Plate").new({
        imgName = "evefishingredient/show/plate.png",
        layer   = self,
    }):to(self, 60):p(770 + X_OFFSET + 450, 151.5):scale(0.6):bindTouch()
    self._plate = plate
end

-- 加载夹子
function M:loadClaw()
    local claw  = import("app.evefishboil.node.Claw").new({
        imgName = "evefishboil/claw/middle.png",
        layer   = self,
    }):to(self, 65):p(305 + X_OFFSET, 435 + 550):bindTouch()
    self._claw  = claw
end


-- 加载灶台
function M:loadOven()
    local oven  = D.img("evefishboil/oven.png"):to(self._node, 10):p(479.1 + X_OFFSET - 130, 143.2):scale(1.1):bindTouch()
    self._oven  = oven
    -- 加载锅
    local pot   = D.img("evefishboil/pot/pot.png"):to(oven, 10):p(199.8, 201.6)--:bindTouchLocate()
    table.insert(self._potTab, pot)
    self._pot   = pot
    local mask  = D.img("evefishboil/pot/mask.png"):to(self._node, 50):p(306 + X_OFFSET, 168.4):scale(1.1)--:bindTouchLocate()
    self._mask  = mask
    table.insert(self._potTab, mask)
    -- 加载水
    local water = D.img("evefishboil/pot/water/10001.png"):to(pot, 5):p(191 + 5, 130.0 + 20)
    self._water = water
    Tools:shaderWave(water, 0.01, 3, 6, 0)
    -- 加载火焰
    local fire  = D.img("evefishboil/fire/10001.png"):to(oven):p(195.2, 150):scale(0)
    self._fire  = fire
    -- 加载上泡泡
    local bubbleup = D.img("evefishboil/pot/bubbleup/10001.png"):to(pot, 7):p(195, 169.5 + 20):opacity(0)
    self._bubbleup = bubbleup
    -- 加载下泡泡
    local bubbledown = D.img("evefishboil/pot/bubbledown/10001.png"):to(pot, 7):p(189.4, 120.7):opacity(0)
    self._bubbledown = bubbledown
end

-- 加载按钮
function M:loadBtn()
    local btn   = import("app.evefishboil.node.Btn").new({
        imgName = "evefishboil/btn/10001.png",
        layer   = self,
    }):to(self._oven, 15):p(400, 104.4):bindTouch()
    self._btn   = btn
end

-- 加载锅盖
function M:loadCover(index, pos, isMove)
    isMove = ifnil(isMove, true)
    -- 加载锅盖
    local cover  = import("app.evefishboil.node.Cover").new({
        imgName  = "evefishboil/cover.png",
        isMove   = isMove,
        enterPos = pos,
        layer    = self,
    }):to(self, 100):p(350 + X_OFFSET, 365 + Y_OFFSET + 450):scale(index)
    self._cover  = cover
    -- 加载亮
    local light = D.img("evefishboil/light.png"):to(cover, 100):p(155.0, 110.7):hide():opacity(0)
    self._light = light
end

-- 加载蒸
function M:loadSteam()
    -- 加载蒸
    local steam = import("app.evefishboil.node.Steam").new({
        imgName = "evefishboil/steam.png",
        layer   = self,
    }):to(self, 6):p(350 + X_OFFSET, 365 + Y_OFFSET + 450):scale(0.9)--:bindTouchLocate()
    self._steam = steam
end

-- 加载ui
function M:loadUi()
    local ui = import("app.evefishboil.node.Ui").new({
        layer       = self,
        pos         = cc.p(850 + X_OFFSET, 250)
    }):to(self, 55)
    ui:p(V.w + ui:cw(), 250)
    self._ui = ui
end

-- 烧水过程
function M:boiling()
    -- 锅震动
    self:potAct()
    local time = 0
	self._boilingTimer = A.cycle({
		{"delay", 0.5},
        {"fn", function()
			time = time + 1
			-- 锅盖的反馈动画
            self._cover:shakeAct(time)
            -- self._steam:shakeAct(time)
			if time == 2 then
				-- 锅里冒烟
				self:loadSmoke()
				self:loadSteamParticle()
            elseif time % 7 == 0 then
                -- 加载结束
                self:boilFinish()
			end
        end},
	}, 12):at(self)
end

-- 锅震动 
function M:potAct()
    for i, v in ipairs(self._potTab) do
        v._potAct = A.cycle({
            {"union", {
                {"rotateTo", 0.05, 0.5},
                {"jumpBy", 0.1, cc.p(0, 0), 0.8, 1},
            }},
            { "rotateTo", 0.05, -0.5},
        }):at(v)
    end
end

-- 锅停止震动
function M:stopPotAct()
    for i, v in ipairs(self._potTab) do
        v:stopAction(v._potAct)
        v._potAct = nil
    end
end

-- 烧鱼过程
function M:fishing()
    local time = 0
	self._fishingTimer = A.cycle({
		{"delay", 0.5},
        {"fn", function()
			time = time + 1
			-- 锅盖的反馈动画
            self._cover:shakeAct(time)
            if time == 2 then
                -- 锅里鱼的晃动
                self._plate:foodActCooking()
                self._isStopSmoke = false
				-- 锅里冒烟
				self:loadSmoke(180)
            elseif time % 11 == 0 then
                sound.stopAllSounds()
                -- 播放配音
     	        soundVoice:playEffectv057048()
                --音效
                soundEffect:playEffectsfx05705005()
                -- 停止锅震动
                self:stopPotAct()
                -- -- 加载结束
                self:boilFinish()
                -- -- 关火
                self:btnClose()
			end
        end},
	}, 12):at(self)
end

-- 关火
function M:btnClose()
    self._steam:stopAllActions()
    self._plate:stopFoodActCooking()
    self._cover:stopShakeAct()
    -- 泡泡消失
    self:bubbleHide()
    -- 停止烟雾
    self:isStopSmokeFlag(true)
    local action = A.reverse({"file", "evefishboil/btn/1000", 6, 0.1})
    self._btn:runAction(action)
    A.line({
        {"scaleTo", 1, 0},
        {"hide"}
    }):at(self._fire)
end

-- 泡泡消失
function M:bubbleHide()
    A.line({
        {"fadeout", 1},
    }):at(self._bubbleup)
    A.line({
        {"fadeout", 1},
    }):at(self._bubbledown)
end

-- 加载结束
function M:boilFinish()
    self._cover._canTouch = true
    self._cover:onTouchBegan()
    --  加载粒子
    self._particle1 = P.newParticle("particle/fish_oil_smoke.plist"):to(self._pot, 999):p(235, 180):scale(1)
    Tools:insertParticleTb(self, self._particle1)
end

-- 锅盖引导
function M:coverGuide()
    self._coverGuideAct = A.cycle({
        {"fadein", 0.5},
        {"delay", .3},
        {"fadeTo", 0.5, 120},
    }):at(self._light)
end

-- 停止引导
function M:stopCoverGuide() 
    if not tolua.isnull(self._coverGuideAct) then 
        self:stopAction(self._coverGuideAct)
        self._coverGuideAct = nil
    end
end

--加载烟雾
function M:loadSmoke(offset)
    offset = ifnil(offset, 80)
    self._smokeIndex = self._smokeIndex + 1
    if self._smokeIndex > 3 then
        self._smokeIndex = 1
    end
    local index = self._smokeIndex
    local pos = {cc.p(350 + X_OFFSET, 230), cc.p(444 + X_OFFSET, 210), cc.p(535 + X_OFFSET, 235)}
    local moveByPos = { cc.p(-150, 350), cc.p(0, 350), cc.p(150, 350)}
    local smoke = D.img("evefishboil/smoke/"..index..".png"):p(pos[index].x - offset, pos[index].y):to(self, self:z() + 100):scale(0)
    smoke:line({
        {"union", {
            {"moveBy", 3, moveByPos[index]},
            {"line", {
                {"scaleTo", 2, 1},
                {"fadeOut", 1},
            }},
            {"line", {
                {"delay", 0.5},
                {"fn", function()
                    if not self._isStopSmoke then
                        self:loadSmoke(offset)
                    end
                end},
            }},
        }},
        {"remove"},
    })
end

-- 加载蒸汽粒子
function M:loadSteamParticle()
    local pos = self:convertToWorldSpace(cc.p(self:cw()/2 - 120, self:ch()/2))
    local steamParticle = Tools:newParticle("particle/zhureqi.plist", pos.x, pos.y):to(self._node, 110)
    Tools:insertParticleTb(self, steamParticle)
    steamParticle:setGlobalZOrder(10)
    self._steamParticle = steamParticle
end

-- 移除蒸汽粒子
function M:removeSteamParticle()
    if self._steamParticle then
        self._steamParticle:stopSystem()
        self._steamParticle:remove()
        self._steamParticle = nil
    end
end
-- 停止烟雾
function M:isStopSmokeFlag(isStop)
    self._isStopSmoke = isStop
end

-- 烧水
function M:stopBoiling()
	if self._boilingTimer then
		self:stopAction(self._boilingTimer)
		self._boilingTimer = nil
	end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._particle1) then
        self._particle1:remove()
        self._particle1 = nil
    end
    if not tolua.isnull(self._steamParticle) then
        self._steamParticle:remove()
        self._steamParticle = nil
    end 
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
    Tools:removeParticleTb(self)

end

return M
