--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Claw")
M.TAG       = "Claw"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    -- 广告限制
    self._fitCascade = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
    
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- self:clawEnter()
end


-- 图片渲染
function M:loadDisplay()
    local left      = D.img("evefishboil/claw/left.png"):to(self, -10):p(20.8, 27.1):anchor(ccp(0.95, 0.95)):rotate(5)--:bindTouchLocate()
    self._left      = left
    local leftmask  = D.img("evefishboil/claw/leftmask.png"):to(left):p(138.1, 215.2):anchor(ccp(0.95, 0.95)):scale(0.95)--:bindTouchLocate()
    self._leftmask  = leftmask
    local right     = D.img("evefishboil/claw/right.png"):to(self, -10):p(24.1, 30.0):anchor(ccp(0.05, 0.95)):rotate(-5)--:bindTouchLocate()
    self._right     = right
    local rightmask = D.img("evefishboil/claw/rightmask.png"):to(right):p(6.3, 216.6):anchor(ccp(0.05, 0.95)):scale(0.95)--:bindTouchLocate()
    self._rightmask = rightmask
end

-- 加载结点
function M:loadPageNode()
    -- 加载虚线
    local line = D.img("evefishboil/claw/line.png"):to(self._layer, 60):p(770 + X_OFFSET, 153):hide():opacity(0)--:bindTouchLocate()
    self._line = line
end

-- 虚线引导圈
function M:lineAct()
    if self._lineAct then return end
    self._lineAct = A.cycle({
        {"show"},
        {"fadein", 0.5},
        {"delay", .3},
        {"fadeout", 0.5},
    }):at(self._line)
end

-- 停止引导
function M:stopCircleAct() 
    if not self._lineAct then return end
    A.line({
        {"fadeout", 0.2},
    }):at(self._line)
    self:stopAction(self._lineAct)
    self._lineAct = nil
end

-- 加载进场
function M:clawEnter()
    A.line({
        {"union",{
            {"easing","ELASTICOUT",{"moveBy", .8, ccp(0, -570)}, 2},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700002()
            end},
        }},
        {"fn", function ()
            --音效
            soundEffect:playEffectsfx05705006()
            -- 下降层级改变
            self:fallingTierSwitch()
        end},
        {"delay", 0.5},
        {"fn", function ()
            -- 夹起来层级改变
            self:clipTierSwitch()
        end}
    }):at(self)
end

-- 下降层级改变
function M:fallingTierSwitch()
    Tools:resetParent(self._left, self._layer, 55)
    Tools:resetParent(self._right, self._layer, 55)
    Tools:resetParent(self._leftmask, self._layer, 60)
    Tools:resetParent(self._rightmask, self._layer, 60)
    self:clawClose(self._left, self._right)
    self:clawClose(self._leftmask, self._rightmask)
    self._layer._plate:foodShake()
end

-- 夹起来层级改变
function M:clipTierSwitch()
    Tools:resetParent(self._layer._plate, self, -5)
    self._layer._plate:unbindTouch()
    self._layer._halffish:show():opacity(255)
    Tools:resetParent(self._left, self, -10)
    Tools:resetParent(self._right, self, -10)
    Tools:resetParent(self._leftmask, self, -1)
    Tools:resetParent(self._rightmask, self, -1)
    self._canTouch = true
    --级联子节点
    self:setTouchCascadeDetected(true)
    -- 开启引导
    guideFn:openGuide(self, 0.01, 3)
    local fishParticle = P.newParticle("particle/zhureqi.plist"):p(250, 100):to(self._layer._plate, 999):scale(1.2)
    Tools:insertParticleTb(self, fishParticle)
    self._fishParticle = fishParticle
end

-- 加载关闭
function M:clawClose(node1, node2)
    A.line({
        {"rotateBy", 0.1, -5},
    }):at(node1)
    A.line({
        {"rotateBy", 0.1, 5},
    }):at(node2)
end

-- 放置成功
function M:putSucceed()
    -- 结束引导线
    self:stopCircleAct()
    self._canTouch = false
    local pos = ccp(773 + X_OFFSET, 333)
    local jumpOffset = 50
    if self:py() > 320 then 
        jumpOffset = 30
    end
    A.line({
        {"jumpto", 0.3, pos, jumpOffset, 1},
        {"fn", function()
            --音效
            soundEffect:playEffectsfx05705008()
            self._layer._plate:foodShake()
        end },
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.2, 0},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.15, cc.p(0, 0), 5, 1},
            {"rotateTo", 0.15, 0},
        }),
        {"rotateTo", 0.05, 0},
        {"fn", function ()
            -- 切换场景
            game:enterScene("evefishadd", {}, "fade", 1, COLOR3_WHITE)
        end}
    }):at(self)
end

-- 返回
function M:back()
    self._canTouch = false
    local pos = ccp(305 + X_OFFSET, 415)
    A.line({
        {"union",{
            {"jumpto", 0.3, pos, 10, 1},
            {"fn", function()
            --音效
            soundEffect:playEffectsfx05705007()
            end},
        }},
        {"fn", function()
            self._layer._mask:z(70)
            self._layer._plate:foodShake()
        end },
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.2, 0},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.15, cc.p(0, 0), 5, 1},
            {"rotateTo", 0.15, 0},
        }),
        {"rotateTo", 0.05, 0},
        {"fn", function ()
            self._canTouch = true
        end}
    }):at(self)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    --音效
    soundEffect:playEffectsfx05700001()
    self._layer._mask:z(60)
    self:lineAct()
    -- 关闭引导
    guideFn:stopGuide(self)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    self:p(x, y + 120)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    if self:px() < 922 and self:px() >  600 and self:py() < 450 and self:py() > 253 then 
        -- 放置成功
        self:putSucceed()
    else
        guideFn:openGuide(self, 0.1, 3)
        -- 返回
        self:back()
        -- 结束引导线
        self:stopCircleAct()
    end
   
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
    R.removeAllTextures()
    R.removeAllFrames()
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._fishParticle) then 
        self._fishParticle:remove()
        self._fishParticle = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
