--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Plate")
M.TAG       = "Plate"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
   self._layer._plateTab = {}
   -- 加载结点
   self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end

-- 加载结点
function M:loadPageNode()
    -- 加载调料 
    self:loadIngredient()
    -- 加载鱼
    local rawfish = D.img("evefishingredient/rawfish.png"):to(self, 10):p(260.0, 154.5)
    self._layer._rawfish = rawfish
    local halffish = D.img("evefishingredient/show/halffish.png"):to(rawfish, 10):p(202.8, 105.4):scale(1.16):opacity(0):hide()
    self._layer._halffish = halffish
    table.insert(self._layer._plateTab , rawfish)
end

-- 加载调料
function M:loadIngredient()
    for j = 3, 4 do 
        local scallion = D.img("evefishingredient/season/"..j..".png"):to(self, 10):scale(1.5):p(235, 160)
        local pos = {ccp(184.3, 30), ccp(158.2, 15)}
        for i = 1, 2 do 
            local ginger = D.img("evefishingredient/season/"..i..".png"):to(scallion, -1):p(pos[i])
        end
        table.insert(self._layer._plateTab , scallion)
    end
end

-- 盘子进场
function M:plateEnter()
    A.line({
        {"easing", "ELASTICOUT", {"moveBy", .8, ccp(-450, 0)}, 2},
        {"fn", function ()
            self._canTouch = true
            -- 开启引导
            guideFn:openGuide(self, 0.1, 3, 0.6)
        end}
    }):at(self)
end

-- 返回
function M:back()
    self._canTouch = false
    local pos = ccp(770 + X_OFFSET, 151.5)
    local jumpOffset = 30
    if self:py() > 320 then 
        jumpOffset = 5
    end
    A.line({
        {"union",{
            {"jumpto", 0.3, pos, jumpOffset, 1},
        }},
        {"fn", function()
            --音效
            soundEffect:playEffectsfx05705008()
            self:foodShake()
        end },
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 20, 1},
            {"rotateTo", 0.2, -3},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.15, cc.p(0, 0), 15, 1},
            {"rotateTo", 0.15, 3},
        }),
        {"rotateTo", 0.05, 0},
        {"fn", function ()
            -- 开启引导
            guideFn:openGuide(self, 0.1, 3, 0.6)
            self._canTouch = true
        end}
    }):at(self)
end

-- 食物晃动
function M:foodShake()
    local time = 0
    local tab = {0.15, 0.12, 0.07, 0.07}
    for k, v in pairs(self._layer._plateTab) do
        v:line({
            {"union", {
                {"moveBy", tab[k], cc.p(0, 25 + k)},
                {"rotateBy", tab[k], 4},
            } },
            {"delay", (k-1)/30},
            {"union", {
                {"moveBy", 0.05, cc.p(0, -25 - k)},
                {"rotateBy", 0.05, -4},
            }},
            {"union", {
                {"moveBy", 0.05, cc.p(0, 10)},
                {"rotateBy", 0.05, 3},
            }},
            {"union", {
                {"moveBy", 0.05, cc.p(0, -10)},
                {"rotateBy", 0.05, -3},
            }},
            {"union", {
                {"moveBy", 0.04, cc.p(0, 5)},
                {"rotateBy", 0.04, 1},
            }},
            {"union", {
                {"moveBy", 0.04, cc.p(0, -5)},
                {"rotateBy", 0.04, -1},
            }},
        })
    end
end

-- 蒸煮过程中食物晃动
function M:foodActCooking()
    for k, v in pairs(self._layer._plateTab) do
        v._foodShaketimer = A.line({
            {"delay", (k - 1) / 10},
            {"fn", function()
                v._foodShakeAct = A.cycle({
                    {"union", {
                        {"rotateTo", 0.075, 2},
                        {"jumpBy", 0.15, cc.p(0, 0), 3, 1},
                    }},
                    {"rotateTo", 0.05, -2},
                }):at(v)
            end},
        }):at(v)
    end
end

-- 停止食物晃动
function M:stopFoodActCooking()
    for k, v in pairs(self._layer._plateTab) do
        if v._foodShakeAct then
            v:stopAction(v._foodShakeAct)
            v._foodShakeAct = nil
        end
    end
end

-- 放鱼
function M:put()
    self._canTouch = false
    local pos = cc.p(300 + X_OFFSET, 235)
    -- 获取动作集合
    local action = self:actGather()
    local jumpOffset = 50
    if self:py() > 320 then 
        jumpOffset = 40
    end
    self:line({
        {"jumpto", 0.3, cc.p(pos.x, pos.y + 50), jumpOffset, 1},
        {"fn", function()
            --  加载粒子
            self._particle = P.newParticle("particle/fish_water.plist"):to(self, -1):p(200, 150):scale(2)
            Tools:insertParticleTb(self, self._particle)
            --音效
            soundEffect:playEffectsfx05705007()
            table.insert(self._layer._potTab, self)
            Tools:resetParent(self._layer._mask, self._layer, 70)
            self._layer:stopPotAct()
            self._layer:potAct()
        end},
        {"moveto", 0.1, pos},
        {"fn", function()
            self:foodShake()
        end},
        action,
        {"fn", function ()
            -- 结束放置
            self:putFinish()
            table.insert(self._layer._plateTab, self._layer._plate)
        end}
    })
end

-- 动作集合
function M:actGather()
    local action = A.line({
        A.union({
            {"jumpBy", 0.3, cc.p(0, 0), 20, 1},
            {"rotateTo", 0.15, -4},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.2, cc.p(0, 0), 15, 1},
            {"rotateTo", 0.1, 3},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.1, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.05, -2},
        }),
        {"rotateTo", 0.05, 2},
        {"rotateTo", 0.05, -2},
        {"rotateTo", 0.04, 1},
        {"rotateTo", 0.04, -1},
        {"rotateTo", 0.03, 1},
        {"rotateTo", 0.03, -1},
        {"rotateTo", 0.02, 0},
    })
    return action
end

function M:putFinish()
    -- 加载盖子
    self._layer:loadCover(1.1, ccp(305 + X_OFFSET, 265), false)
    -- 加载ui
    self._layer:loadUi()
    -- 加载进度条动作
    self._layer._ui:progressAct(4.5)
    -- 烧鱼过程
    self._layer:fishing()
    -- 鱼的变化动作
    self:fishAct()
end

-- 鱼的变化动作
function M:fishAct()
    A.line({
        {"show"},
        {"fadein", 4.5},
    }):at(self._layer._halffish)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end 
    -- 关闭引导
    guideFn:stopGuide(self)
    --音效
    soundEffect:playEffectsfx05700001()
    self:scale(0.65)
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end 
    self:p(x, y)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return  end
    self:scale(0.6)
    if self:px() < 500 + X_OFFSET and self:py() < 412 then 
        -- 放鱼
        self:put()
    else
        -- 放回
        self:back()
    end
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if not tolua.isnull(self._particle) then 
        self._particle:remove()
        self._particle = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
