--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Scallion")
M.TAG       = "Scallion"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false

end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 加载结点
function M:loadPageNode()
    local pos = {ccp(184.3, 30), ccp(158.2, 15)}
    for i = 1, 2 do 
        local ginger = D.img("evefishingredient/season/"..i..".png"):to(self, -1):p(pos[i])
    end
end


-- 虚线引导圈
function M:circleAct()
    for i, v in ipairs(self._layer._circleTab) do
        if v._circleAct then return end
        v._circleAct = A.cycle({
            {"fadein", 0.5},
            {"delay", .3},
            {"fadeout", 0.5},
        }):at(v)
    end
   
end

-- 停止引导
function M:stopCircleAct() 
    for i, v in ipairs(self._layer._circleTab) do
        if not v._circleAct then return end
        A.line({
            {"fadeout", 0.2},
        }):at(v)
        v:stopAction(v._circleAct)
        v._circleAct = nil
    end
end

-- 调料动作
function M:seasoningAct(pos1, pos2)
    -- 鱼的动作
    self:fishAct()
    A.line({
        {"easing", "backin",{"union",{
            {"moveTo", 0.3, pos1},
            {"scaleTo", 0.3, 0.9},
        }},},
        {"easing", "sineout",{"union",{
            {"moveBy", 0.5, pos2},
            {"fn", function ()
                self:z(5)
            end},
            {"line",{
                {"scaleTo", 0.25, 1},
                {"scaleTo", 0.25, 1.3}
            }}
        }},},
    }):at(self)
end

-- 鱼的动作
function M:fishAct()
    self._layer._count = self._layer._count + 1
    A.line({
        {"delay", 0.15},
        {"union",{
            {"jumpBy", 0.6 ,ccp(0,0), 35, 1},
            {"fn", function()
                -- 音效[sfx05705001]
                soundEffect:playEffectsfx05705001()
            end},
        }},
        {"fn", function ()
            commonAct:nodeScale(self._layer._rawfish, 0.5, 0.5)
            if self._layer._count == 1 then 
                guideFn:openGuide(self._layer._scallionTab[1], 0.1, 3)
            else
                A.line({
                    {"delay", 0.5},
                    {"fn", function ()
                        self:stopAllActions()
                        -- 切换场景
                        game:enterScene("evefishboil", {}, "fade", 1, COLOR3_WHITE)
                    end}
                }):at(self)
            end
        end}
    }):at(self._layer._rawfish)
end

-- 返回
function M:back()
    A.line({
        {"jumpTo", 0.25, ccp(750 + X_OFFSET, 168), 50, 1},
        {"fn", function ()
            commonAct:nodeScale(self, 0.5, 1)
        end},
        {"delay", 0.5},
        {"fn", function ()
            self._canTouch = true
        end}
    }):at(self)
end

-- 引导判断
function M:guideJudgment()
    if self._layer._count == 0 then 
        for i, v in ipairs(self._layer._scallionTab) do
            guideFn:openGuide(v, 0.1, 3)
        end
    else
        guideFn:openGuide(self, 0.1, 3)
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self._canTouch = false
    self:scale(1.2)
    -- 音效[sfx05700001]
    soundEffect:playEffectsfx05700001()
    for i, v in ipairs(self._layer._scallionTab) do
        guideFn:stopGuide(v)
    end
    -- 虚线引导圈
    self:circleAct()
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    self:p(x, y)
end

function M:onTouchEnded(x, y, touches)
    self:scale(1)
    if self:px() <= 515 + X_OFFSET and self:px() >= 115 + X_OFFSET  then 
        if self:py() <= 350 and self:py() >= 193 then 
            -- 调料动作
            self:seasoningAct(ccp(300 + X_OFFSET, 395), ccp(0, -200))
        elseif self:py() < 193 and self:py() >= 63 then 
            -- 调料动作
            self:seasoningAct(ccp(300 + X_OFFSET, 0), ccp(0, 200))
        else
            self:guideJudgment()
            self:back()
        end
    else
        self:guideJudgment()
        self:back()
    end
    -- 返回
    -- 停止引导
    self:stopCircleAct()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
