--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Steam")
M.TAG       = "Steam"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    -- 进入位置
    self._enterPos = ccp(305 + X_OFFSET * 1.1, 230)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 蒸进场
    -- self:steamEnter()
end


--蒸进场
function M:steamEnter()
    local pos = self._enterPos
    self:line({
        {"delay", 0.1},
        {"union",{
            {"jumpto", 0.3, cc.p(pos.x, pos.y + 50), 100, 1},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700002()
                -- 音效
                soundEffect:playEffectsfx05705002()
            end},
        }},
        {"moveto", 0.1, pos},
        {"fn", function ()
            Tools:resetParent(self, self._layer._pot, 6)
            self:scale(0.85)
            self:enterShake()
        end}
	})
end

function M:enterShake()
    -- 音效
    soundEffect:playEffectsfx05705003()
    self:line({
        A.union({
            {"jumpBy", 0.3, cc.p(0, 0), 10, 1},
            {"rotateTo", 0.1, 1},
        }),
        {"rotateTo", 0.05, 0},
        A.union({
            {"jumpBy", 0.1, cc.p(0, 0), 5, 1},
            {"rotateTo", 0.05, -1},
        }),
        {"rotateTo", 0.05, 2},
        {"rotateTo", 0.05, -2},
        {"rotateTo", 0.04, 2},
        {"rotateTo", 0.04, -2},
        {"rotateTo", 0.03, 1},
        {"rotateTo", 0.03, -1},    
        {"rotateTo", 0.02, 0},
        {"fn", function()
            self:shakeAct(4)
        end},
    })
end

-- 蒸跳动
function M:shakeAct(time)
    if time == 2 then 
        self:stopShakeAct()
        self._shake = A.cycle({
			{"union", {
            	{"rotateTo", 0.05, 2 },
				{"moveBy", 0.05, cc.p(0, -3)},
			}},
			{"union", {
            	{ "rotateTo", 0.05, -2 },
				{"moveBy", 0.05, cc.p(0, 3)},
			}},
            { "rotateTo", 0.04, 2 },
            { "rotateTo", 0.04, -2 },
			{"union", {
            	{ "rotateTo", 0.03, 1 },
				{"moveBy", 0.03, cc.p(0, -1.5)},
			}},
            { "rotateTo", 0.03, -1 },    
			{"union", {
            	{ "rotateTo", 0.02, 0 },
				{"moveBy", 0.02, cc.p(0, 1.5)},
			}},
        }):at(self)
    elseif time == 4 then
        self:stopShakeAct()
        self._shake = A.cycle({
            {"union", {
                { "rotateTo", 0.05, -3},
                {"jumpBy", 0.1, cc.p(0, 0), 4, 1},
            }},
            { "rotateTo", 0.05, 3},
        }):at(self)
    end
end

-- 停止跳动
function M:stopShakeAct()
    if self._shake then
        self:rotation(0)
        self:stopAction(self._shake)
        self._shake = nil
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
