--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class("Main", import("app.common.layer.BaseCookLayer"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch    = true
    -- 虚线表
    self._circleTab   = {}
    -- 配料表
    self._scallionTab = {}
    -- 计数
    self._count       = 0
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    local title = "common/help1.png"
    local time = 0.8
    Tools:enterSceneScale(self, title, time)
    self:line({
        {"delay", time - 0.3},
        {"fn", function()
            self:begin()
        end}
    })
end

-- 开始
function M:begin()
    A.line({
        {"union",{
            {"easing", "ELASTICOUT", { "moveTo", 0.8, ccp(758.1 + X_OFFSET, 150.2) }, 2 },
            {"fn", function()
                -- 播放配音
                self._startVoice = soundVoice:playEffectv057053()
                --音效
                soundEffect:playEffectsfx05700002()
            end},
        }},
        {"fn", function()
            for i, v in ipairs(self._scallionTab) do
                Tools:resetParent(v, self, 93)
                v._canTouch = true
            end
            self._canTouch = true
            -- 开启引导
            for i, v in ipairs(self._scallionTab) do
                guideFn:openGuide(v, 0.1, 3)
            end
        end}
    }):at(self._dish)
end

-- 加载结点
function M:loadPageNode()
    -- 加载生鱼
    self:loadRawfish()
    -- --加载盘子
    self:loadPlate()
    -- --加载碟子
    self:loadDish()
    -- 加载虚线
    self:loadLine()
    -- 加载料酒
    self:loadWine()
end

-- 加载料酒
function M:loadWine()
    local wine = import("app.evefishingredient.node.Wine").new({
        imgName = "evefishingredient/add/winefall/1.png",
        layer   = self
    }):to(self, 100):p(730 + X_OFFSET + 500, 150.2):anchor(ccp(0.6, 0.5)):bindTouch()
    local shadow = D.img("evefishingredient/shadow.png"):to(wine, -1):p(150, 40)
    wine._shadow = shadow
    self._wine = wine
end

-- 加载生鱼
function M:loadRawfish()
    local rawfish = D.img("evefishingredient/rawfish.png"):to(self, 10):p(312 + X_OFFSET, 182.2)
    self._rawfish = rawfish
    local winespread = D.img("evefishingredient/add/winespread/1.png"):to(rawfish, 10):p(205, 118.2):hide()
    self._winespread = winespread
end

--加载盘子
function M:loadPlate()
    local plate = D.img("evefishingredient/plate.png"):to(self):p(314.6 + X_OFFSET, 168.7):scale(1.05)
    self._plate = plate
end

--加载碟子
function M:loadDish()
    local dish = D.img("evefishingredient/dish.png"):to(self)--:p(758.1 + X_OFFSET + 550, 150.2)
    dish:p(V.w + dish:cw(), 150.2)
    self._dish = dish
    -- 加载调料
    for j = 3, 4 do 
        local scallion = import("app.evefishingredient.node.Scallion").new({
            imgName = "evefishingredient/season/"..j..".png",
            layer   = self
        }):to(self._dish, 50):p(153.6, 115):bindTouch()
        table.insert(self._scallionTab, scallion)
    end
end

-- 加载虚线
function M:loadLine()
    local line = D.img("evefishingredient/line.png"):to(self, 20):p(315 + X_OFFSET, 182.0):opacity(0)
    table.insert(self._circleTab, line)
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
