--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Wine")
M.TAG       = "Wine"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    
end

-- 进入
function M:enter()
    A.line({
        {"union",{
            {"easing", "ELASTICOUT", {"moveBy", 0.8, ccp(- 500 , 0)}, 1},
            {"fn", function()
                sound.stopSound(self._layer._startVoice)
                
                -- 播放配音
     	        soundVoice:playEffectv057182()
                --音效
                soundEffect:playEffectsfx05700002()
                self._canTouch = true
                -- 开启引导
                guideFn:openGuide(self, 0.1, 3)
            end},
        }},
    }):at(self)
end

-- 加载结点
function M:loadPageNode()
    -- 预加载帧动画
    commonAct:addTexture("evefishingredient/add/winefall/", 1, 18)
    commonAct:addTexture("evefishingredient/add/winespread/", 1, 13)
end


-- 返回
function M:back(isFinish)
    self._canTouch = false
    A.line({
        {"jumpTo", 0.3, ccp(730 + X_OFFSET, 150.2), 100, 1},
        {"fn", function ()
            self._shadow:show()
            commonAct:nodeScale(self, 0.5, 1)
            --音效
            soundEffect:playEffectsfx05700008()
        end},
        {"delay", 0.5},
        {"fn", function ()
            if not isFinish then
                -- 开启引导
                guideFn:openGuide(self, 0.1, 3, 1) 
                self._canTouch = true
            else
                -- 离场
                self:moveOut()
            end
        end}
    }):at(self)
end

-- 离场
function M:moveOut()
    self:line({
        {"union",{
            {"moveby", 0.5, cc.p(V.w, 0)},
            {"fn", function()
                --音效
                soundEffect:playEffectsfx05700007()
            end},
        }},
        {"fn", function ()
            -- 切换场景
            game:enterScene("evefishboil", {}, "fade", 1, COLOR3_WHITE)
        end}
    })
end

-- 放置成功
function M:put()
    self._canTouch = false
    local pos = ccp(405 + X_OFFSET, 300)
    A.line({
        {"moveTo", 0.3, pos},
        {"union",{
            {"imagerange", "evefishingredient/add/winefall/", 1, 18, 0.1},
            {"line", {
                {"delay", 0.5},
                {"fn", function ()
                    -- 料酒铺开
                    self:wineDownAct()
                end}
            }}
        }},
        {"fn", function ()
            -- 结束返回
            self:back(true)
        end}
    }):at(self)
end


-- 料酒铺开
function M:wineDownAct()
    A.line({
        {"show"},
        {"union",{
            --渐隐
            {"fadeTo", 1.3, 50},
            {"imagerange", "evefishingredient/add/winespread/", 1, 13, 0.1},
            {"fn", function ()
                -- 音效
     	        soundEffect:playEffectsfx05705010()
            end}
        }},
    }):at(self._layer._winespread)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    -- self._canTouch = false
    -- 关闭引导
    guideFn:stopGuide(self)
    -- 音效
    soundEffect:playEffectsfx05700001()
    self._shadow:hide()
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    if self:px() <= 515 + X_OFFSET and self:px() >= 115 + X_OFFSET and self:py() <= 350 and self:py() >= 63 then 
        -- 料酒动作
        self:put()
    end
    self:p(x, y)
    bb.si.Tool.limitRectMove({
        node      = self,
        -- marginTop = 80,
    })
    bb.si.Tool.limitButtonMove({node = self})
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    if self:px() <= 515 + X_OFFSET and self:px() >= 115 + X_OFFSET  then 
        -- 料酒动作
        self:put()
    else
        self:back()
    end 
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
