--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --浮想框
    self._boxTb     = {}
    --第几次进来
    self._enterNum  = self:getScene()._enterNum
    --从哪里来 1：鱼 2：饺子
    self._fromWhere = self:getScene()._fromWhere
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    collectgarbage("collect")
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    Tools:openAd()
    if self._enterNum == 1 then
        -- 播放音效[057BGM06]厨房做菜
        sound:play057BGM06()
        --发出疑问
        self._mm:talkAct1()
    else
        --夸奖妙妙
        self._mom:praiseAct()
    end
end

--加载背景
function M:loadBg()
    -- 加载一个空节点
    local bgNode = U.loadNode({}):to(self):bindTouch()
    self._bgNode = bgNode
    local bg = U.loadBg("evekitchen/bg.png"):to(self._bgNode):scaleX(BG_SCALE * 1.2)
end

-- 加载结点
function M:loadPageNode()
    --加载物品
    self:loadGoods()
    --加载窗户
    self:loadWindow()
    --加载妈妈
    self:loadMom()
    --加载妙妙
    self:loadMm()
    --加载浮想框
    self:loadThinkBox()
end

--加载物品
function M:loadGoods()
    local posTb = {cc.p(578.3 + X_OFFSET, 512.7),cc.p(63 + X_OFFSET, 695)}
    for k, v in ipairs(posTb) do
        local goods = D.img("evekitchen/goods/"..k..".png"):to(self._bgNode):p(v)
    end
    -- local iceBox = D.img("evekitchen/goods/icebox.png"):to(self._bgNode, 5):p(49.6 + X_OFFSET, 346.7)
    local light = D.img("evekitchen/goods/light.png"):to(self._bgNode, 5):p(337.9 + X_OFFSET, 595.1)
    local light = D.img("evekitchen/goods/light.png"):to(self._bgNode, 5):p(721.7 + X_OFFSET, 600.5)
end

--加载窗户
function M:loadWindow()
    local win = import("app.common.node.BaseWindow").new({
        layer = self,
    }):to(self._bgNode, 1)
    :p(861.1 + X_OFFSET, 589.4)
end

--加载妈妈
function M:loadMom()
    local enterPos = cc.p(583 + X_OFFSET, 162)
    local mom = import("app.evekitchen.node.AniMom").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNode, 100):scale(1.3):p(enterPos)
    self._mom = mom
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(300 + X_OFFSET, 107)
    local mm = import("app.evekitchen.node.AniMm").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bgNode, 100):scale(1.3):p(enterPos):flipX(true)
    self._mm = mm
end

--加载浮想框未打开
function M:loadThinkBox()
    local posTb = { cc.p(180.4+ X_OFFSET + 220, 256.6 + 40 + Y_OFFSET / 2 ), cc.p(339.8+ X_OFFSET + 220, 225.9 + 40 + Y_OFFSET/2)}
    for i, v in ipairs(posTb) do
        if self._enterNum == 2 and i ~= self._fromWhere then
            local thinkbox = import("app.evekitchen.node.ThinkBox").new({
                layer       = self,
                id          = i,
                pos         = v
            }):to(self, 200):p(v)
            table.insert(self._boxTb, thinkbox)
        elseif self._enterNum == 1 then
            local thinkbox = import("app.evekitchen.node.ThinkBox").new({
                layer      = self,
                id         = i,
                pos        = v
            }):to(self, 200):p(v)
            table.insert(self._boxTb, thinkbox)
        end
    end
end

--打开浮想框引导
function M:openBoxGuide()
    if self._guide then return end
    local index = 1
    self._guide = A.cycle({
        { "fn", function()
            self._boxTb[index]:openGuide()
            index = index + 1
            if index > #self._boxTb then
                index = 1
            end
        end },
        { "delay", 5 },
    }):at(self)
end

--关闭浮想框引导
function M:closeBoxGuide()
    if self._guide then
        self:stopAction(self._guide)
        self._guide = nil
    end
    for i, v in ipairs(self._boxTb) do
        v:closeGuide()
    end
end

--三秒未点击自动进入
function M:delayEnterNextScene()
    if self._delayEnterAct then return end
    self._delayEnterAct = A.line({
        {"delay", 3},
        {"fn", function ()
            if self._canTouch then
                self._canTouch = false
                Tools:changeAnchorP(self._boxTb[1], cc.p(0.5, 0.5))
                --关闭浮想框引导
                self:closeBoxGuide()
                self._boxTb[1]:touchEvent()
            end
        end}
    }):at(self)
end

--关闭自动进入
function M:closeDelayNextScene()
    if self._delayEnterAct then
        self:stopAction(self._delayEnterAct)
        self._delayEnterAct = nil
    end
end

--长时间没有选疑惑
function M:delayPlayAct()
    if self._delayPlayAct then return end
    self._delayPlayAct = A.line({
        {"delay", 3},
        {"fn", function ()
            --播放等待语音
            self:playWaitEffect()
            -- 疑问说话 (开始)
            self._mm:talkAni4_1()
        end}
    }):at(self)
end

--关闭延迟播放
function M:closeDelayPlayAct()
    if self._delayPlayAct then
        self:stopAction(self._delayPlayAct)
        self._delayPlayAct = nil
    end
end

--播放等待语音
function M:playWaitEffect()
    if self:getScene()._enterNum == 2 then return end
    if self._waitEffectAct then return end
    self._waitEffectAct = A.cycle({
        {"fn", function ()
            -- 播放音效[sfx05704023]妙妙思考等待
            self._waitEffect = soundEffect:playEffectsfx05704023()
        end},
        {"delay", 6.3}
    }):at(self)
end

--停止播放等待语音
function M:stopWaitEffect()
    if self._waitEffectAct then 
        self:stopAction(self._waitEffectAct)
        self._waitEffectAct = nil
    end
    if self._waitEffect then
        sound.stopSound(self._waitEffect)
        self._waitEffect = nil
    end
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    sound.stopAllSounds()
    collectgarbage("collect")
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
