--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妙妙类
----------------------
local M     = class("AniMm", import("app.common.node.BaseMm"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(780 + X_OFFSET, 90))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--换装
	self:changeClose()
	-- 呼吸
	self:breathAni()
end

--换装
function M:changeClose()
    self._armature:getBone("cmm_wq"):hide()
end

--发出疑问 “妈妈，为什么除夕要吃年夜饭呀”
function M:talkAct1()
	-- 播放配音[v057038]妈妈，为什么除夕要吃年夜饭呀
	soundVoice:playEffectv057038()
	-- 疑问说话 (开始)
	self:talkAni1_1()
end

--说话动作
function M:talkEvent1()
	-- 疑问说话 (循环)
	self:talkAni1_2()
	local time = soundVoice:soundDuration("v057038", 3) - 0.5
	self:line({
		{ "delay", time },
		{ "fn", function()
			-- 疑问说话 (结束)
			self:talkAni1_3()
			--妈妈说话 “宝贝问得好，年夜饭就是团圆饭，为了让一家人聚在一起，度过最美好的时光呀。”
			self._layer._mom:talkAct1()
		end }
	})
end

--发出疑问 真好，我也想学做年夜饭！”
function M:talkAct2()
	-- 播放配音[v057039]真好，我也想学做年夜饭！
	soundVoice:playEffectv057039()
	--厨房说话（开始）
	self:talkKitchenAni1_1()
end

--说话动作
function M:talkEvent2()
	--厨房说话（循环）
	self:talkKitchenAni1_2()
	local time = soundVoice:soundDuration("v057039", 3)
	self:line({
		{ "delay", time },
		{ "fn", function()
			--厨房说话（结束）
			self:talkKitchenAni1_3()
			--妈妈说话 “妙妙想做什么菜呢”
			self._layer._mom:talkAct2()
		end }
	})
end

--冒出浮想框
function M:thinkBoxEnter()
	self._layer._bgNode:line({
		{"union",{
			{ "scaleto", 0.5, 1.2 },
			{ "moveby", 0.5, cc.p(100, 0) },
		}},
		{"fn", function ()
			--音频
			self._layer._boxTb[1]:enterEffect()
			--长时间没有选疑惑
			self._layer:delayPlayAct()
			for i, v in ipairs(self._layer._boxTb) do
				v:enter()
			end
			--看着浮想框
			self:lookKitchenAni()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "mm_csh1" then
			--说话动作
			self:talkEvent1()
		elseif __moveId == "mm_csh5" then
			--说话动作
			self:talkEvent2()
		elseif __moveId == "mm_csh5_2" then
			-- 眯眼呼吸
			self:breathWinkAni()
		elseif __moveId == "mm_xiao" then
			-- --冒出浮想框
			-- self:thinkBoxEnter()
			-- 呼吸
			self:breathAni()
		elseif __moveId == "mm_csh4" then
			-- 疑问说话 (结束)
			self:talkAni4_3()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    self._armature:getAnimation():setMovementEventCallFunc(function()
    end)
    A.stopTarget(self)
    sound.stopAllSounds()
end


return M
