--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妈妈类
----------------------
local M     = class("AniMom", import("app.common.node.BaseMom"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	--呼吸厨房
	self:breathKitchenAni()
end

--妈妈说话 “宝贝问得好，年夜饭就是团圆饭，为了让一家人聚在一起，度过最美好的时光呀。”
function M:talkAct1()
	-- 播放配音[v057050]宝贝问得好，年夜饭就是团圆饭，为了让一家人聚在一起，度过最美好的时光呀。
	soundVoice:playEffectv057050()
	--厨房说话（开始）
	self:talkKitchenAni1_1()
end

--说话开始
function M:talkEvent1()
	--厨房说话（循环）
	self:talkKitchenAni1_2()

	local time1 = soundVoice:soundDuration("v057050", 7.4)
	local time2 = soundVoice:soundDuration("v057173", 4)

	self:line({
		{ "Delay", time1},
		{ "fn",function ()
			-- 播放配音[v057173]妙妙，你想跟妈妈一起学做年夜饭吗？
			soundVoice:playEffectv057173()
		end},
		{ "delay", time2},
		{ "fn", function()
			--厨房说话（结束）
			self:talkKitchenAni1_3()
			--发出疑问 真好，我也想学做年夜饭！”
			self._layer._mm:talkAct2()
		end }
	})
end


--妈妈说话 “妙妙想做什么菜呢”
function M:talkAct2()
	-- 播放配音[v057051]妙妙想做什么菜呢
	soundVoice:playEffectv057051()
    --厨房说话（开始）
    self:talkKitchenAni1_2()
	--说话开始
	self:talkEvent2()
end

--说话开始
function M:talkEvent2()

	local time = soundVoice:soundDuration("v057051", 3) - 0.8
	self:line({
		{ "Delay", time },
		{ "fn", function()
			--厨房说话（结束）
			self:talkKitchenAni1_3()
			--看着浮想框
			-- self._layer._mm:lookKitchenAni()
			--冒出浮想框
			self._layer._mm:thinkBoxEnter()
		end }
	})
end


--夸奖妙妙
function M:praiseAct()
	--厨房说话（开始）
	self:talkKitchenAni2_1()
end

--夸奖动作
function M:praiseEvent()
	--厨房说话（循环）
	self:talkKitchenAni2_2()
	-- 播放音效[sfx05704024]妈妈夸妙妙笑
	soundEffect:playEffectsfx05704024()
	-- 妙妙开心笑
	self._layer._mm:smileAni()
	-- 播放配音[v057055]宝贝太能干啦，我们继续下一道菜吧！
	soundVoice:playEffectv057055()
	local time = soundVoice:soundDuration("v057055", 3)
	self:line({
		{ "Delay", time },
		{ "fn", function()
			--厨房说话（结束）
			self:talkKitchenAni2_3()
			--冒出浮想框
			self._layer._mm:thinkBoxEnter()
			--看着浮想框
			-- self._layer._mm:lookKitchenAni()
		end }
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmm_csh2" then
			--说话开始
			self:talkEvent1()
			-- --点头
			self._layer._mm:nodeHeadAni()
		elseif __moveId == "qmm_csh3" then
			--夸奖动作
			self:praiseEvent()
		elseif __moveId == "qmm_csh3_2" then
			--呼吸厨房
			self:breathKitchenAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    self._armature:getAnimation():setMovementEventCallFunc(function()
    end)
    A.stopTarget(self)
    sound.stopAllSounds()
end

return M
