--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --红包第几轮次
    self._count    = 0
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()  
    -- 播放音效[057BGM08]压岁钱
    sound:play057BGM08()  
    -- “宝贝们，来拿新年红包啦”
    self._mom:talkAct(1)
end

-- 加载背景
function M:loadBg()
    local bg = U.loadBg("tfroom/bg.png"):to(self):bindTouch()
    if V.h < 640 then
        bg:py(-35)
    end
    self._bg = bg
end

-- 加载结点
function M:loadPageNode()
    -- 加载家具
    self:loadFurniture()
    -- 加载大花瓶
    self:loadBigVase()
    -- 加载小花瓶
    self:loadSmallVase()
    -- 加载窗户
    self:loadWindow()
    -- 加载挂饰
    self:loadDecorate()
    --加载灯
    self:loadLight()
    --加载爸爸
    self:loadDad()
    --加载妙妙
    self:loadMm()
    --加载妈妈
    self:loadMom()
    --加载奇奇
    self:loadQq()
end

-- 加载家具
function M:loadFurniture()
    -- 加载沙发
    local pos = { ccp(512.3, 202.6), ccp(754.7, 121.7), ccp(261.9, 120.8) }
    local zorder = {50, 100, 100}
    for i = 1, 3 do
        local sofa = D.img("tfroom/furniture/sofa" .. i .. ".png"):to(self._bg, zorder[i]):p(pos[i]):scale(0.86)
    end
    -- 加载桌子
    local desk    = D.img("tfroom/furniture/desk.png"):to(self._bg, 100):p(515.6, 95.4):scale(0.86)
    -- 加载抱枕
    -- local cushion = D.img("tfroom/furniture/cushion.png"):to(self._bg, 50):p(426.8, 222.9):scale(0.86)
end

-- 加载大花瓶
function M:loadBigVase()
    local bigFlowerConfig = G_ROOM_DECORATE_CONFIG["bigFlowerTb"]
    local pos = { ccp(140, 238.1), ccp(885, 238.1)}
    for i = 1, 2 do
        -- 加载瓶身
        local vase    = import("app.tfroom.node.BigVase").new({
            imgName = "tfroom/flower/big/vase.png",
            layer    = self,
            index    = i,
        }):to(self._bg, 50):p(pos[i]):scale(0.86)
        local vase1 = D.img("tfroom/flower/big/vase1.png"):to(vase, -2):p(41.8, 145.1):scale(1)
        for j = 1, 3 do 
            local flowerId = bigFlowerConfig[j]
            local flipX, angle, pos1, tier = Tools:getFlowerConfig(flowerId, j, 1)
            local flower = D.img("tfroom/flower/big/"..flowerId..".png")
            :anchor(ccp(0.5, 0)):to(vase, tier):p(pos1):flipX(flipX):rotate(angle)
        end
    end
end

-- 加载小花瓶
function M:loadSmallVase()
    -- 加载瓶身
    local smallVase = import("app.tfroom.node.SmallVase").new({
        imgName = "tfroom/flower/small/vase.png",
        layer    = self,
    }):to(self._bg, 100):p(578.6, 149.4):scale(0.86):bindTouch()
    local vase1    = D.img("tfroom/flower/small/vase1.png"):to(smallVase, -2):p(29.6, 66.2):scale(1)
    self._smallVase = smallVase

    local smallFlowerConfig = G_ROOM_DECORATE_CONFIG["smallFlowerTb"]
    for j = 1, 3 do 
        local flowerId = smallFlowerConfig[j]
        local flipX, angle, pos1, tier = Tools:getFlowerConfig(flowerId, j, 2)
        local flower = D.img("tfroom/flower/small/" .. flowerId .. ".png")
        :anchor(ccp(0.5, 0)):to(smallVase, tier):p(pos1):flipX(flipX):rotate(angle)
    end
end

-- 加载窗户
function M:loadWindow()
    local frame = D.img("tfroom/door/frame.png"):to(self._bg, 30):p(512.5, 414.6):scale(0.86)
    local windowbg = D.img("evemoney/win/winBg.png"):to(frame, -1):p(152, 150.9):scale(1.1)

    local pos = { ccp(205, 155), ccp(100, 155) }
    local decorateConfig = G_ROOM_DECORATE_CONFIG["decorateTb"]
    -- 加载窗花
    for i = 1, 2 do
        local windowFlower = D.img("tfroom/doorflower/" .. decorateConfig[i] .. ".png"):to(frame):p(pos[i]):scale(1.25)
    end

    local clipImg = D.img("evemoney/win/winBg.png"):p(0, 0)--:scaleX(0.08)
    local clip    = CCNodeExtend.extend(cc.ClippingNode:create(clipImg)):p(windowbg:cw() / 2, windowbg:ch() / 2):bindTouch()
    windowbg:addChild(clip, 1)
    -- 设置裁剪区域的显示，false为显示裁剪的区域，true为裁剪后的区域(很关键)
    clip:setInverted(false)
    clip:setAlphaThreshold(0)
    local tree = D.img("evemoney/win/1.png"):to(clip, 1):p(161.7, -43):anchor(cc.p(1,0))
    commonAct:breathing(tree)
    local tree = D.img("evemoney/win/2.png"):to(clip, 1):p(122.4, -79.2):anchor(cc.p(1, 0))
    commonAct:breathing(tree)

    Tools:loadSnows(clip, 13, nil, 5, nil, {
        posY = 100,
        offset1 = -windowbg:cw()/2, 
        offset2 = windowbg:cw()/2
    }, nil, true)
end

-- 加载装饰
function M:loadDecorate()
    local pos = { ccp(322.1, 390.2), ccp(241.1, 397.6), ccp(779, 397.6), ccp(696.9, 397.6) }
    local decorateConfig = G_ROOM_DECORATE_CONFIG["decorateTb"]
    for i = 1, 4 do
        local decorate = D.img("tfroom/decorate/" .. decorateConfig[i + 2] .. ".png"):to(self._bg):p(pos[i]):scale(0.86)
    end
end

--加载灯
function M:loadLight()
    local posTb = { cc.p(251.6, 596), cc.p(711.9, 604.8)}
    for i, v in ipairs(posTb) do
        local light = D.img("evemoney/light.png"):to(self, 10):p(v)
    end
end

--加载弹窗
function M:loadPopup()
    self._count = self._count + 1
    local popup = import("app.evemoney.node.Popup").new({
        layer   = self,
    }):to(self)
    self._popup = popup
    --谷歌去广告
    Tools:closeAd(false, false)
    popup:enter()
end

--加载爸爸
function M:loadDad()
    local enterPos = cc.p(452.5, 253)
    local dad = import("app.evemoney.node.AniDad").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 81):scale(0.8):p(enterPos)
    self._dad = dad
end

--加载妈妈
function M:loadMom()
    local enterPos = cc.p(585.7, 236.5)
    local mom = import("app.evemoney.node.AniMom").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 80):scale(0.8):p(enterPos)
    self._mom = mom
end

--加载妙妙
function M:loadMm()
    local enterPos = cc.p(718, 81)
    if V.h < 640 then
        enterPos = cc.p(718, 81 + 15)
    end
    local mm  = import("app.evemoney.node.AniMm").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 101):scale(0.8):p(enterPos)
    mm:p(enterPos.x + V.w_2, enterPos.y)
    self._mm = mm
end

--加载奇奇
function M:loadQq()
    local enterPos = cc.p(607, 90)
    if V.h < 640 then
        enterPos = cc.p(607, 90 + 15)
    end
    local qq = import("app.evemoney.node.AniQq").new({
        layer    = self,
        enterPos = enterPos
    }):to(self._bg, 100):scale(0.8)
    qq:p(enterPos.x + V.w_2, enterPos.y)
    self._qq = qq
end

--奇奇妙妙进场
function M:qqAndMmEnter()
    self._qq:enter()
    self._mm:enter()
end

--开始奇奇的红包
function M:startQqRedPackets()
    -- 接下来是奇奇的啦
    self._mom:talkAct(2)
end

--抽取失败，爸爸给红包
function M:chooseFail()
    --抽取失败给红包
    self._dad:giveRedPackets()
end

--结束鼓掌
function M:finishAct()
    self._isFinish = true
    --说话道谢
    self._qq:talkAct()
    --说话道谢
    self._mm:talkAct()
end


--红包完成激励
function M:judgeExcitation()
    if self._count == 1 then
        -- 跳跃激励
        self._mm:moneyexcitationAni()
        self._qq:moneySmile()
    else
        -- 跳跃激励
        self._qq:moneyexcitationAni()
        self._mm:moneySmile()
    end
end

--进入下个场景
function M:enterNextScene()
    game:enterScene("evefireworkput", { firstEnter = "put", directEnter = false }, "fade", 0.5, COLOR3_WHITE)
    -- game:enterSceneWithLoading("evefireworkput", {firstEnter = "put", directEnter = false}, {needScale = false})
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
end

return M
