--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 爸爸类
----------------------
local M     = class("AniDad", import("app.common.node.BaseDad"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:moneyBreathAni1()
end

-- 呼吸
function M:moneyBreathAni1()
	self:play("qmb_hx4")
end

-- 眯眼笑呼吸
function M:moneyBreathAni2()
    self:play("qmb_hx5")
end

-- 看老婆笑
function M:moneyBreathAni()
    self:play("qmb_kt0")
end

-- 说话（开始）
function M:moneyTalkAni1_1()
    self:play("qmb_sh3")
end

-- 说话（循环）
function M:moneyTalkAni1_2()
    self:play("qmb_sh3_1")
end

-- 说话（开始）
function M:moneyTalkAni2_1()
    self:play("qmb_sh3_2")
end

-- 说话（循环）
function M:moneyTalkAni2_2()
    self:play("qmb_sh3_3")
end

-- 掏出红包
function M:moneyPacket1_1()
    self:play("qmb_thb1")
end

-- 举着红包呼吸
function M:moneyPacket1_2()
    self:play("qmb_thb1_1")
end

-- 收回手
function M:moneyPacket1_3()
    self:play("qmb_thb1_2")
end

-- 鼓掌
function M:moneyApplause1_1()
    self:play("qmb_gz0")
end

-- 鼓掌说话（循环
function M:moneyApplause1_2()
    self:play("qmb_gzsh1")
end

-- 鼓掌说话（结束
function M:moneyApplause1_3()
    self:play("qmb_gzsh1_1")
end

-- 招手
function M:moneyWave1_3()
    self:play("qmb_zs")
end

--抽取失败给红包
function M:giveRedPackets()
	-- 说话（开始）
	self:moneyTalkAni1_1()
	-- 看老公笑
	self._layer._mom:moneyBreathAni()
end

--摇手
function M:shakeHands()
	-- 说话（循环）
	self:moneyTalkAni1_2()
	-- 播放配音[v057071]诶呀没关系~新年红包少不了
	soundVoice:playEffectv057071()
	local time1 = soundVoice:soundDuration("v057071", 4)/3
	local time2 = time1
	local time3 = time1
	self:line({
		{ "delay", time1 },
		{ "fn", function()
			-- 说话（开始）
			self:moneyTalkAni2_1()
		end },
		{ "delay", time2 },
		{ "fn", function()
			-- 掏出红包
			self:moneyPacket1_1()
		end },
		{ "delay", time3 },
		{ "fn", function()
			--加载飞行红包
			self:loadFlyRedPacket()
			-- 收回手
			self:moneyPacket1_3()
		end },
	})
end

--加载飞行红包
function M:loadFlyRedPacket()
	local bone = self._armature:getBone("qmb_hb")
	local pos = cc.p(bone:getPosition())

	 local flyPos = self._layer._count ~= 1 and self._layer._qq:worldpoint() or self._layer._mm:worldpoint()
  	flyPos = cc.p(flyPos.x, flyPos.y + 30)
	local redPackets = D.img("evemoney/redpackets/complete.png"):to(self._layer):p(pos):scale(0.3)
	-- 播放音效[sfx05707014]礼物蹦到奇妙口袋中
	soundEffect:playEffectsfx05707014()
	redPackets:line({
		{ "union", {
			{ "jumpto", 0.5, flyPos, 100, 1 },
			{ "scaleTo", 0.5, 0.1 },
		} },
		{"remove",},
		{"fn", function ()
			--红包完成激励
			self._layer:judgeExcitation()  
		end}
	})
end

--最后说话
function M:finishTalk()
	-- 播放音效[sfx05707015]爸妈拍手
	soundEffect:playEffectsfx05707015()
	-- 鼓掌
	self:moneyApplause1_1()
	-- 鼓掌
	self._layer._mom:moneyApplause()
end

--最后说话动作
function M:finishTalkEvent()
	-- 鼓掌说话（循环
	self:moneyApplause1_2()
	-- 播放配音[v057063]恭喜宝贝们又长大一岁！
	-- soundVoice:playEffectv057063()
	-- 播放配音[v057072]恭喜宝贝们又长大一岁！
	soundVoice:playEffectv057072()
	local time2 = soundVoice:soundDuration("v057072", 3)
	self:line({
		{ "delay", time2 },
		{ "fn", function()
			-- 鼓掌说话（结束
			self:moneyApplause1_3()
			-- 播放音效[sfx05707012]爸妈欢呼（复用）
			soundEffect:playEffectsfx05707012()
			-- 跳跃激励
			self._layer._qq:moneyexcitationAni(false)
			-- -- 跳跃激励
			self._layer._mm:moneyexcitationAni(false)
			self:line({
				{ "delay", 2 },
				{ "fn", function()
					--进入下个场景
					self._layer:enterNextScene()
				end }
			})
		end }
	})
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmb_kt0" then
			-- 眯眼笑呼吸
			self:moneyBreathAni2()
		elseif __moveId == "qmb_zs" then
			-- 呼吸
			self:moneyBreathAni1()
		elseif __moveId == "qmb_sh3" then
			--摇手
			self:shakeHands()
		elseif __moveId == "qmb_sh3_2" then
   			-- 说话（循环）
			self:moneyTalkAni2_2()
		elseif __moveId == "qmb_thb1" then
   			-- 举着红包呼吸
			self:moneyPacket1_2()
		elseif __moveId == "qmb_thb1_2" then
   			-- 眯眼笑呼吸
			self:moneyBreathAni2()
		elseif __moveId == "qmb_gz0" then
			--最后说话动作
			self:finishTalkEvent()
		elseif __moveId == "qmb_gzsh1_1" then
			-- 眯眼笑呼吸
			self:moneyBreathAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
