--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妈妈类
----------------------
local M     = class("AniMom", import("app.common.node.BaseMom"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:moneyBreathAni1()
end


-- 呼吸
function M:moneyBreathAni1()
    self:play("qmm_hx4")
end

-- 眯眼笑呼吸
function M:moneyBreathAni2()
    self:play("qmm_hx5")
end

-- 看老公笑
function M:moneyBreathAni()
    self:play("qmm_kt0")
end


-- 掏出红包
function M:moneyPacket1_1()
    self:play("qmm_sh3")
end

-- 举着红包呼吸
function M:moneyPacket1_2()
    self:play("qmm_sh3_1")
end

-- 收回手
function M:moneyPacket1_3()
    self:play("qmm_sh3_2")
end

-- 鼓掌
function M:moneyApplause()
    self:play("qmm_gz0")
end

-- 1:“宝贝们，来拿新年红包啦” 2:接下来是妙妙的啦
function M:talkAct(type)
	type = ifnil(type, 1)
	-- 掏出红包
	self:moneyPacket1_1()

	local time1=1.38
	local time = soundVoice:soundDuration("v057061", 3)
	self:line({
		{ "delay", time1},
		{"fn", function ()
			if type == 1 then
				-- 播放配音[v057061]宝贝们，来拿新年红包啦
				soundVoice:playEffectv057061()
			else
				-- 播放配音[v057062]接下来是奇奇的份哦~
				soundVoice:playEffectv057062()
			end
		end},
		{"delay", time},
		{"fn", function ()
			-- 收回手
			self:moneyPacket1_3()
			self:line({
				{"delay", 1},
				{"fn", function ()
					--移除红包的粒子
					self:removeRedParticle()
					-- 眯眼笑呼吸
					self:moneyBreathAni2()
				end},
			})
			--加载弹窗
			self._layer:loadPopup()
		end}
	})
end

--获取红包位置
function M:getRedPos()
	local boneName = "qmm_hb"
	local bone = self._armature:getBone(boneName)
	local pos = cc.p(bone:getPosition())
	return pos
end

--咀嚼粒子
function M:redParticle()
    --移除红包的粒子
    self:removeRedParticle()
    --获取红包位置
    local newPos = self:getRedPos()
    self._redParticle = Tools:newParticle("particle/hongbao.plist", newPos.x, newPos.y):to(self._layer, 1000)
	Tools:insertParticleTb(self._layer, self._redParticle)
end

--移除红包的粒子
function M:removeRedParticle()
    if self._redParticle then
        self._redParticle:remove()
        self._redParticle = nil
    end
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qmm_sh3" then
			--咀嚼粒子
			self:redParticle()
			-- 举着红包呼吸
			self:moneyPacket1_2()
			if self._layer._count == 0 then
				--奇奇妙妙进场
				self._layer:qqAndMmEnter()
				-- 招手
				self._layer._dad:moneyWave1_3()
			else
				-- 看老婆笑
				self._layer._dad:moneyBreathAni()
			end
		elseif __moveId == "qmm_kt0" then
			-- 眯眼笑呼吸
			self:moneyBreathAni2()
		elseif __moveId == "qmm_gz0" then
			-- 眯眼笑呼吸
			self:moneyBreathAni2()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
