--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 奇奇类
----------------------
local M     = class("AniQq", import("app.common.node.BaseQq"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer = params.layer
	--进场位置
	self._enterPos = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
end

-- 呼吸
function M:moneyBreathAni1()
    self:play("qq_bhx")
end

-- 走路
function M:moneyWalkAni()
    self:play("qq_bz")
end

-- 跑步
function M:moneyRunAni()
    self:play("qq_bz0")
end

-- 说话（开始）
function M:moneyTalkAni1_1()
    self:play("qq_bsh1")
end

-- 说话（循环）
function M:moneyTalkAni1_2()
    self:play("qq_bsh1_1")
end

-- 说话（开始）
function M:moneyTalkAni1_3()
    self:play("qq_bsh1_2")
end

--叉腰笑
function M:moneySmile()
    self:play("qq_bx")
end

-- 跳跃激励
function M:moneyexcitationAni(isTalk)
	isTalk = ifnil(isTalk, true)
	-- 播放音效[sfx05707011]奇奇欢呼
	-- soundEffect:playEffectsfx05707011()
	if isTalk then
		-- 播放配音[v057066]耶！红包！红包！
		soundVoice:playEffectv057066()
	else
		-- 播放音效[sfx05707013]奇妙欢呼（复用）
		soundEffect:playEffectsfx05707013()
	end
    self:play("qq_bjl")
end

--走入屏幕
function M:enter()
	-- 走路
	-- self:moneyWalkAni()
	-- 跑步
	self:moneyRunAni()
    self:line({
        { "moveto", 1.5, self._enterPos },
        { "fn", function()
			-- 呼吸
			self:moneyBreathAni1()
        end }
    })
end

--说话道谢
function M:talkAct()
	-- 播放配音[v057067]谢谢爸爸妈妈，祝你们财源滚滚来
	soundVoice:playEffectv057067()
	-- 说话（开始）
	self:moneyTalkAni1_1()
	local time = soundVoice:soundDuration("v057067", 3)
	self:line({
		{"delay", time},
		{"fn", function ()
			--最后说话
			self._layer._dad:finishTalk()
			-- 说话（开始）
			self:moneyTalkAni1_3()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "qq_bjl" then
			-- if self._layer._count == 1 then
				-- 呼吸
				self:moneyBreathAni1()
			-- end
			if not self._layer._isFinish then
				--结束鼓掌
				if device.language == "ru" or device.language == "ko" then
					A.line({
						{"delay", 3},
						{"fn", function ()
							self._layer:finishAct()
						end}
					}):at(self)
				else
					self._layer:finishAct()
				end
			end
		elseif __moveId == "qq_bx" then
			-- 呼吸
			self:moneyBreathAni1()
		elseif __moveId == "qq_bsh1" then
   			-- 说话（循环）
			self:moneyTalkAni1_2()
		elseif __moveId == "qq_bsh1_2" then
			-- 呼吸
			self:moneyBreathAni1()
		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)

	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
