--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 弹窗类
----------------------
local M     = class("Popup", import("app.common.node.BasePopup"))
M.TAG       = "Popup"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer        = params.layer
    --触控
    self._canTouch     = false
    --礼物
    self._giftTb       = {}
    --选中的礼物
    self._chooseGift   = nil
    --红包
    self._redPacketsTb = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 加载结点
function M:loadPageNode()
    --加载矩形裁剪
    self:loadClip2()
    --加载礼物
    self:loadGift()
    --加载红包
    self:loadRedPackets()
    --加载其他红包
    self:loadOtherRedPackets()
end

--加载礼物
function M:loadGift()
    local posTb = { cc.p(self:cw() / 2 - 210, self:ch() / 2 + 50), 
                    cc.p(self:cw() / 2,       self:ch() / 2 + 50), 
                    cc.p(self:cw() / 2 + 210, self:ch() / 2 + 50),}
    local giftIdTb = {1, 2, 3}
    T.shuffle(giftIdTb, 10)
    for i, v in ipairs(posTb) do
        local gift = import("app.evemoney.node.Gift").new({
            layer  = self,
            id     = giftIdTb[i],
            belong = self,
            posIndex = i
        }):to(self._base):p(v):opacity(0)
        table.insert(self._giftTb, gift)
    end
end

--进场动作
function M:enterAction()
    Tools:openAd(true)
    -- 播放音效[sfx05707001]弹出礼物
    soundEffect:playEffectsfx05707001()
    for i, v in ipairs(self._giftTb) do
        v:line({
            {"Delay", (i - 1) * 0.1},
            {"fn", function ()
                v:enter(function ()
                    if i==#self._giftTb then
                        if self._layer._count == 1 then
                            -- 播放配音[v057069]妙妙喜欢哪个礼物呢？
                            soundVoice:playEffectv057069()
                        else
                            -- 播放配音[v057068]奇奇喜欢哪个礼物呢？
                            soundVoice:playEffectv057068()
                        end
                    end
                end)
            end}
        })
    end
end

--其他礼物退出
function M:otherGiftQuit(gift, callBack)
    local enter = false
    self._chooseGift = gift
    -- 播放音效[sfx05707002]选中后其他两个消失
    soundEffect:playEffectsfx05707002()
    for i, v in ipairs(self._giftTb) do
        if v ~= gift then
            v:quit(function ()
                if not enter then
                    if callBack then
                        callBack()
                    end
                    enter = true
                end
            end)
        end
    end
end

--加载矩形裁剪
function M:loadClip2()
    local rect = cc.rect(0, 39.5, self:cw(), self:ch())
    local clipping = CCNodeExtend.extend(cc.ClippingRectangleNode:create(rect)):to(self, 1):hide():bindTouch()
    self._clip2 = clipping
end

--加载中间的红包
function M:loadRedPackets()
    local redpackets = import("app.evemoney.node.RedPackets").new({
        layer        = self._layer,
        pos        = cc.p(self:cw() / 2, self:ch() / 2 - 40),
        belong    = self,
        isRight    = true
    }):to(self._clip2, 5)
    redpackets:p(self:cw() / 2, self:ch() / 2 - redpackets:ch() - 150)
    table.insert(self._redPacketsTb, redpackets)
    self._redpackets = redpackets
end

--加载其他红包
function M:loadOtherRedPackets()
    local posTb = { cc.p(self:cw() / 2 - 220, self:ch() / 2 - 40),
                    cc.p(self:cw() / 2 + 220, self:ch() / 2 - 40),}
    for i, v in ipairs(posTb) do
        local pos = posTb[i]
        local redpackets = import("app.evemoney.node.RedPackets").new({
            layer        = self._layer,
            belong       = self,
            isRight      = false,
            pos          = pos,
        }):to(self._clip2, 5)
        local x = i == 1 and (0 - redpackets:cw()) or (self:cw() + redpackets:cw())
        redpackets:p(x, pos.y)
        table.insert(self._redPacketsTb, redpackets)
    end
end

--红包进场
function M:redpacketsEnter()
    self._clip2:show()
    Tools:resetParent(self._chooseGift, self._clip2, 7)
    local time = 0.3
    self._chooseGift:line({
        { "union", {
            { "scaleTo", time, 1 },
            { "jumpby", time, cc.p(0, 100), 50, 1 },
        } },
    })
    self._redpackets:enter1(function()
        Tools:resetParent(self._chooseGift, self._redpackets, 2)
        self._chooseGift:unbindTouch()
        -- 播放音效[sfx05707003]礼物进红包袋
        soundEffect:playEffectsfx05707003()
        self._chooseGift:line({
            { "union", {
                { "scaleTo", 0.3, 0.9 },
                { "moveby", 0.3, cc.p(0, -140) },
            } },
            { "fn", function()
                Tools:resetParent(self._redpackets._mask, self._redpackets, 20)
                self._redpackets:line({
                    { "scaleTo", 0.1, 1.05, 0.95 },
                    { "scaleTo", 0.1, 0.95, 1.05 },
                    { "scaleTo", 0.1, 1 },
                    { "fn", function ()
                        --其他红包进场
                        self:otherRedpacketsEnter()
                    end}
                })
            end }
        })
    end)
end

--其他红包进场
function M:otherRedpacketsEnter()
    local first = false
    for i, v in ipairs(self._redPacketsTb) do
        if v ~= self._redpackets then
            v:enter2(function ()
                if not first then
                    first = true
                    --关闭红包
                    self:closeRedPackets()
                end
            end)
        end
    end
end

--关闭红包
function M:closeRedPackets()
    -- 播放音效[sfx05707005]红包袋合上（复用）
    soundEffect:playEffectsfx05707005()
    for i, v in ipairs(self._redPacketsTb) do
        --关闭
        v:closeAct()
        --上升
        v:riseAct(function()
            if i == #self._redPacketsTb then
                self:line({
                    { "delay", 0.3 },
                    { "fn", function()
                        -- 播放音效[sfx05707004]红包滚动（三个红包）
                        soundEffect:playEffectsfx05707004()
                        --开始洗牌count:洗牌次数 递归
                        self:startShuffle(4)
                    end }
                })
            end
        end)
    end
end

--开始洗牌count:洗牌次数 递归
function M:startShuffle(count, tbNum)
    if count == 0 then
        self:finishShuffle()
        return
    end
    tbNum = ifnil(tbNum, 3)
    local ids = self:getNumList(tbNum)
    local redpackets1 = self._redPacketsTb[ids[1]]
    local redpackets2 = self._redPacketsTb[ids[2]]
    redpackets1:z(10)
    redpackets1:z(7)
    local pos1 = redpackets1._pos
    local pos2 = redpackets2._pos
    local time = 0.5
    redpackets1:line({
        { "jumpTo", time, pos2, 55, 1 },
    })
    redpackets2:line({
        { "jumpTo", time, pos1, -55, 1 },
    })
    count = count - 1
    self:line({
        { "delay", time + 0.1 },
        { "fn", function()
            if self._redPacketsTb and not tolua.isnull(redpackets1) then
                redpackets1._pos = pos2
            end
            if self._redPacketsTb and not tolua.isnull(redpackets2) then
                redpackets2._pos = pos1
            end
            self:startShuffle(count,tbNum)
        end }
    })
end

--生成随机数1～len之间的随机序列
function M:getNumList(len)
    local rsList = {}
    for i = 1, len do
        table.insert(rsList, i)
    end
    local num, tmp
    for i = 1, len do
        num = math.random(1, len)
        tmp = rsList[i]
        rsList[i] = rsList[num]
        rsList[num] = tmp
    end
    return rsList
end

--洗牌完成
function M:finishShuffle()
    -- 播放配音[v057070]当当当——礼物在哪里呢~
    self._talkVoice = soundVoice:playEffectv057070()
    -- self:playQuestionVoice(self._trashIds[self._trashCount])
    --开启图标引导
    -- self:openCardGuide()
    self:line({
        { "delay", 0.1 },
        { "fn", function()
            self._canTouch = true
            if self._redPacketsTb then
                for i, v in pairs(self._redPacketsTb) do
                    if not tolua.isnull(v) then
                        v._canTouch = true
                    end
                end
            end
        end }
    })
end

--移除点击过的红包
function M:removeRedPacketsTb(redPackets)
    T.removeOrder(self._redPacketsTb, redPackets)
    --移动到指定位置
    self:movePos()
end

--移动到指定位置
function M:movePos()
    if #self._redPacketsTb == 2 then
        --两个红包，移到指定位置
        self:twoMovePos()
    else
        -- 播放音效[sfx05707009]都没选中
        soundEffect:playEffectsfx05707009()
        --所有都退出
        self:allQuit(function ()
            --抽取失败，爸爸给红包
            self._layer:chooseFail()
        end)
    end
end

--两个红包，移到指定位置
function M:twoMovePos()
    local posTb = { cc.p(self:cw() / 2 - 150, self:ch() / 2),
                    cc.p(self:cw() / 2 + 150, self:ch() / 2),}
    local target1 = self._redPacketsTb[1]
    local target2 = self._redPacketsTb[2]
    if target1:point().x < target2:point().x then
        target1._pos = posTb[1]
        target2._pos = posTb[2]
    else
        target1._pos = posTb[2]
        target2._pos = posTb[1]
    end

    local time = 0.3
    target1:line({
        { "moveto", time, target1._pos }
    })
    target2:line({
        { "moveto", time, target2._pos },
        { "fn", function ()
            -- 播放音效[sfx05707005]红包打开
            soundEffect:playEffectsfx05707005()
            for i, v in ipairs(self._redPacketsTb) do
                --下降
                v:downAct(function()
                    v:line({
                        { "delay", 0.5 },
                        { "fn", function()
                            --上升
                            v:riseAct(function()
                                if i == #self._redPacketsTb then
                                    -- 播放音效[sfx05707007]红包滚动（两个红包）
                                    soundEffect:playEffectsfx05707007()
                                    --开始洗牌count:洗牌次数 递归
                                    self:startShuffle(3, 2)
                                end
                            end)
                            -- 播放音效[sfx05707005]红包袋合上（复用）
                            soundEffect:playEffectsfx05707005()
                            --关闭
                            v:closeAct()
                        end }
                    })
                end)
                --打开
                v:openAct()
            end
        end}
    })
end

--所有都退出
function M:allQuit(callBack)
    local first = false
    for i, v in ipairs(self._redPacketsTb) do
        --退场
        v:quit(function()
            if not first then
                first = true
                if self._clip2 then
                    self._clip2:remove()
                    self._clip2 = nil
                end
                self:quit(callBack)
            end
        end)
    end
end

--其他退出
function M:otherQuit(callBack, exclude)
    local first = false
    for i, v in ipairs(self._redPacketsTb) do
        if v ~= exclude then
            --退场
            v:quit(function()
                if not first then
                    first = true
                    if callBack then
                        callBack()
                    end
                end
            end)
        end
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
