--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 红包类
----------------------
local M     = class("RedPackets", import("app.common.node.BaseNode"))
M.TAG       = "RedPackets"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    --属于谁
    self._belong   = params.belong
    --是否为正确的
    self._isRight = ifnil(params.isRight, false)
    
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("evemoney/redpackets/base2.png")

    local mask = D.img("evemoney/redpackets/mask.png"):to(self, 20):p(self:cw()/2, self:ch() / 2):opacity(255)
    self._mask = mask
end

-- 加载结点
function M:loadPageNode()
    --加载盖子
    self:loadLid()
end

--加载盖子
function M:loadLid()
    local lid = D.img("evemoney/redpackets/7.png"):to(self, 1):p(self:cw() / 2 - 1.8, 170.7)
    self._lid = lid
end

--打开
function M:openAct(callBack, judge)
    judge = ifnil(judge, false)
    if  judge and self._isRight then
        local size = 1
        local strength = 0.5
        self:line({
            { "scaleTo", 0.15, 1.1, 0.85 },
            { "easing", "backin", { "scaleTo", 0.1, 1 } },
            { "scaleTo", 0.1, size + 0.15 * strength, size - 0.1 * strength },
            { "scaleTo", 0.1, size },
            { "scaleTo", 0.1, size + 0.1 * strength, size - 0.05 * strength },
            { "scaleTo", 0.1, size },
        })
    end

    self._lid:line({
        {"image", "evemoney/redpackets/", 5, 1/15},
        { "fn", function()
            self:display("evemoney/redpackets/base2.png")
        end },
        { "imagenames", { "evemoney/redpackets/6.png", "evemoney/redpackets/7.png",}, 1 / 15 },
        {"fn", function ()
            self._lid:z(1)
            if callBack then
                callBack()
            end
            if judge then
               if not self._isRight then
                    --选择错误
                    self:chooseError()
                else
                    --选择正确
                    self:chooseRight()
                end 
            end
        end}
    })
end

--选择错误
function M:chooseError()
    -- 播放音效[sfx05707008]选择错误
    soundEffect:playEffectsfx05707008()
    A.shake({ node = self, time = 0.35, strengthX = 8, strengthY = 0 })
    self:line({
        { "delay", 0.4 },
        {"fn", function ()

        end},
        -- { "easing", "BACKIN", { "scaleTo", 0.5, 0 } },
        { "easing", "backin", { "moveby", 0.5, cc.p(0, -300) } },
        { "remove"},
        -- { "delay", 0.5 },
        { "fn", function()
            --移除点击过的红包
            self._belong:removeRedPacketsTb(self)
        end },
    })
end

--选择正确
function M:chooseRight()
    local mainLayer = self._belong:getParent()
    local aniPos = mainLayer._count ~= 1 and mainLayer._qq:worldpoint() or mainLayer._mm:worldpoint()
    aniPos = cc.p(aniPos.x, aniPos.y + 30)
    -- 播放音效[sfx05707006]选中正确，礼物跳出
    soundEffect:playEffectsfx05707006()
    local gift = self._belong._chooseGift
    gift:line({
        {"moveby", 0.3, cc.p(0, 120)},
        {"fn", function ()
            local pos = gift:point()
            Tools:resetParent(gift,mainLayer , 5000)
            --其他红包退出
            self:otherQuit()
            gift:line({
                { "jumpto", 0.5, cc.p(V.w_2, V.h_2), 50, 1 },
                {"fn", function ()
                    -- 加载居中展示的光和粒子
                    Tools:loadLightAndParticle(gift, mainLayer, nil, 2, 2)
                end},
                { "delay", 2 },
                { "fn", function ()
                    -- 播放音效[sfx05707003]礼物进红包袋
                    soundEffect:playEffectsfx05707003()
                    gift:line({
                        { "union", {
                            { "scaleTo", 0.3, 0.9 },
                            { "jumpby", 0.3, cc.p(0, 110), 50, 1 },
                        } },
                        {"fn", function ()
                            Tools:resetParent(gift, self, 2)
                            gift:line({
                                { "union", {
                                    { "scaleTo", 0.3, 0.9 },
                                    { "moveto", 0.3, cc.p(pos.x, pos.y-130) },
                                } },
                                { "fn", function()
                                    --选择结束
                                    self:chooseFinish(aniPos)
                                end }
                            })
                        end},
                    })
                end}
            })
        end}
    })
end

--其他红包退出
function M:otherQuit()
    self._belong:otherQuit(function()
        self:line({
            { "moveto", 0.5, cc.p(self._belong:cw() / 2, self._belong:ch() / 2 - 40) },
            { "fn", function()
            end }
        })
    end, self)
end

--选择结束
function M:chooseFinish(aniPos)
    local mainLayer = self._belong:getParent()
    Tools:resetParent(self._mask, self, 20)
    self:line({
        { "scaleTo", 0.1, 1.05, 0.95 },
        { "scaleTo", 0.1, 0.95, 1.05 },
        { "scaleTo", 0.1, 1 },
        { "fn", function()
            self:closeAct()
            --上升
            self:riseAct(function()
                Tools:resetParent(self, mainLayer, 9999)
                self._lid:z(30)
                self:display("evemoney/redpackets/base1.png")
                self._lid:display("evemoney/redpackets/1.png")
                self._belong:quit()
                self:line({
                    { "delay", 0.5 },
                    { "fn", function()
                        -- 播放音效[sfx05707014]礼物蹦到奇妙口袋中
                        soundEffect:playEffectsfx05707014()
                    end },
                    { "union", {
                        { "jumpto", 0.5, aniPos, 100, 1 },
                        { "scaleTo", 0.5, 0 },
                    } },
                    { "fn", function()
                        --红包完成激励
                        mainLayer:judgeExcitation()
                    end },
                    { "remove",},
                })
            end)
        end }
    })
end

--关闭
function M:closeAct(callBack)
    self._lid:z(30)
    self._lid:line({
        { "imagenames", { "evemoney/redpackets/7.png", "evemoney/redpackets/6.png", }, 1 / 15 },
        { "fn", function ()
            self:display("evemoney/redpackets/base1.png")
        end},
        A.reverse({ "image", "evemoney/redpackets/", 5, 1 / 15 }),
        { "fn", function()
            if callBack then
                callBack()
            end
            --上升
            -- self:riseAct()
        end }
    })
end

--进场1
function M:enter1(callBack)
    self:line({
        { "moveto", 0.3, self._pos },
        {"fn", function ()
            Tools:resetParent(self._mask, self:getParent(), 20)
            if callBack then
                callBack()
            end
        end}
    })
end

--进场1
function M:enter2(callBack)
    self:line({
        {"easing", "backout", { "moveto", 0.5, self._pos },},
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--退场
function M:quit(callBack)
    self:line({
        { "easing", "backin", {"moveby", 0.5, cc.p(0, -300)}},
        { "fn", function ()
            if callBack then
                callBack()
            end
        end},
        { "remove"}
    })
end

--上升
function M:riseAct(callBack)
    self:line({
        {"moveby", 0.3, cc.p(0, 40) },
        { "fn", function()
            self._pos = self:point()
        end },
        { "delay", 0.1 },
        { "fn", function()
            if callBack then
                callBack()
            end
        end }
    })
end

--下降
function M:downAct(callBack)
    self:line({
        { "moveby", 0.3, cc.p(0, -40) },
        { "fn", function()
            self._pos = self:point()
        end },
        {"delay", 0.1},
        {"fn", function ()
            if callBack then
                callBack()
            end
        end}
    })
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    print("Hello", self._belong._canTouch, self._canTouch)
    if self._belong._canTouch then
        if self._canTouch then
            self._belong._canTouch = false
            self._canTouch = false
            -- 缩放动作
            self:scaleAction()
            -- 点击效果
            Tools:clickEff2(self._belong:getParent(), x, y)
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
end

function M:onTouchEnded(x, y, touches)
    -- 结束缩放动作
    self:stopScaleAction(self, function()
        --下降
        self:downAct()
        -- 播放音效[sfx05707005]红包打开
        soundEffect:playEffectsfx05707005()
        --打开
        self:openAct(nil, true)
    end)
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
