--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = class('Button', BaseButton)


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
	M.super.ctor(self, params)
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self, params)
    -- 跳过按钮
    self:loadSkipBtn()
end

--按钮返回键点击事件其他
function M:btnBackOther()
    umengOP.recordEVEEnd()
end

-- 跳过按钮
function M:loadSkipBtn()
    local button    = U.loadScaleButton({
        imagename       = "tfgoodswalk/ui/btn.png", -- 按钮图片
        parent          = self, -- 父亲节点（选填)
        zorder          = 1000, -- 层深度（选填)
        pos             = ccp(getButtonX_Right() - 10, 70), -- 位置(默认返回键位置)
        -- tabsound    = "effect/19001003.mp3",
        issubmit        = true, -- 是否只点击一次
        fnBegan         = function()                 --开始事件
            --停止呼吸
            self:stopBreath()
        end,
        fnClicked    =        function()
            self:btnSkipEvent()
        end
    }):scale(0):unbindTouch():rotate(-180):hide()
    local light = D.img("tfgoodswalk/ui/btnmask.png"):to(button, -1):p(54, 53):scale(0.85)
    self.btn_skip = button
    self.btn_skip._light = light

    --跳过按钮进场
    -- self:btnSkipEnter()
end

--按钮呼吸
function M:btnBreath()
    A.cycle({
        { "union", {
            { "fadeout", 0.8 },
            { "scaleTo", 0.8, 1.1 },
        } },
        { "scaleTo", 0.1, 0.85 },
        { "fadein", 0.1 },
    }):at(self.btn_skip._light)
    self.btn_skip:cycle({
        { "scaleto", 0.5, 1.05 },
        { "scaleto", 0.5, 1 },
    })
end

--停止呼吸
function M:stopBreath()
    self.btn_skip:stopAllActions():scale(0)
    self.btn_skip._light:stopAllActions():hide()
end


function M:btnSkipEvent()
    --是否结束
    self:getScene():getMainLayer():overEvent()

    self.btn_skip:line({
        { "union", {
            { "easing", "backin", { "rotateby", 0.5, 180 },},
            { "easing", "backin", { "scaleto", 0.5, 0 },},
        } },
        
        { "hide",}
    })
end

--跳过按钮进场
function M:btnSkipEnter()
    self.btn_skip:line({
        {"show"},
        {"union", {
            { "easing", "backout", { "rotateby", 0.8, 180 },},
            { "easing", "backout", { "scaleto", 0.8, 1 },},
        }},
        { "fn", function()
            self.btn_skip:bindTouch()
            --按钮呼吸
            self:btnBreath()
            if callBack then
                callBack()
            end
        end },
    })
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end



return M
