--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch      = true
    --当前轮数
    self._round         = 0
    --椅子
    self._deskTb        = {}
    -- 1：上菜 2：落座 3：吃饭
    self._type          = self: getScene()._type
    --人物
    self._aniTb         = {}
    --喂食总数
    self._eatCount      = 0
    --结束
    self._isOver        = false
    --打钩键出现数目
    self._showSkipCount = 8
    --上菜顺序表
    self._serveAniTb    = {}
    --所有菜的总数
    self._allCount      = 27
    --落座动物表
    self._sitAniTb      = {}
    --获取按顺序的落座表
    self._orderAniTb    = {nil, nil, nil, nil}
    --菜名语音
    self._sayFoodNameVoice = nil
    --张嘴音效（多个音效同时触发时播一个）
    self._isOpenEffect     = false
    -- 是否放置成功的标志位
    self._setMealFlag      = false
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[057BGM07]上菜、吃年夜饭
    sound:play057BGM07()
    if self._type == 1 then
       --进场
        self._dad:enter() 
    elseif self._type == 3 then
        for i, v in ipairs(self._diningTable._foodsTab) do
            v._canTouch = true
        end
        self._diningTable:openGuide()
    end
end

--加载背景
function M:loadBg()
    --远景
    local bgNodeFar = U.loadNode():to(self, 2):bindTouch():p(-100, 0)
    self._bgNodeFar = bgNodeFar
    --中景
    local bgNodeMid = U.loadNode():to(self, 4):bindTouch()
    self._bgNodeMid = bgNodeMid
    --近景
    local bgNodeNear = U.loadNode():to(self, 6):bindTouch():scale(0.85)
    self._bgNodeNear = bgNodeNear

    local bg = U.loadBg("eveputfood/bg/bg.png"):to(self._bgNodeFar):scaleX(BG_SCALE * 1.5)
end

--加载场景
function M:loadGoods()
    local posTb = { cc.p(366.9, 607.4), cc.p(565.5, 692.9),
                    cc.p(1060.5, 598.4), cc.p(886.5, 536.8),
                    cc.p(1269.3, 581.9), cc.p(710.9, 556.8),
                    cc.p(66, 337.3), cc.p(1117.9, 380.2),
                    cc.p(401.9, 601.6), cc.p(106.5, 459),}
    for k = 2, 10 do
       local goods = D.img("eveputfood/bg/" .. k .. ".png"):to(self._bgNodeFar):p(posTb[k])
        if k == 2 then
            local goods = D.img("eveputfood/bg/" .. k .. ".png"):to(self._bgNodeFar):p(cc.p(168, 692.9))
        elseif k == 9 then
            local goods = D.img("eveputfood/bg/" .. k .. ".png"):to(self._bgNodeFar):p(cc.p(829.5, 601.6))
        end 
    end
end

--加载窗户
function M:loadWindow()
    local win = import("app.common.node.BaseWindow").new({
        layer = self,
        id    = 2
    }):to(self._bgNodeFar):p(366.9, 585.4)
end

--加载桌子
function M:loadDesk()
    local diningTable = import("app.eveputfood.node.DiningTable").new({
            layer     = self,
            type      = self._type
    }):to(self._bgNodeNear, 20):p(400.9 + X_OFFSET, 100.6)
    self._diningTable = diningTable
    local posTb1 = {cc.p(58.1 + X_OFFSET + 20, 356.2 - 50),cc.p(270.5 + X_OFFSET + 20, 415.3 - 50),
                    cc.p(484.6 + X_OFFSET + 20, 415.3 - 50),cc.p(730.5 + X_OFFSET + 20, 356.2 - 50),}
    local deskIdTb = {1,2,2,1}
    for i, v in ipairs(posTb1) do
        local desk = import("app.eveputfood.node.Desk").new({
            layer  = self,
            type   = deskIdTb[i],
            id     = i, 
        }):to(self._bgNodeNear):p(v)
        if i == 4 then
            desk:flipX(true)
        end
        if self._type == 3 then
            local ani = nil
            if i == 1 then
                --加载奇奇
                ani = self:loadQq(0)
            elseif i == 2 then
                -- 加载妙妙
                ani = self:loadMm(0)
            elseif i == 3 then
                --加载妈妈
                ani = self:loadMom(0)
            elseif i == 4 then
                --加载爸爸
                ani = self:loadDad(0)
            end
            if ani then
                ani:sitUp(desk, true)
            end
            --加入已坐下动物表
            self:insertSitAniTb(ani, i)
        end

        table.insert(self._deskTb, desk)
    end
end

--获取桌上虚线框的表
function M:getBoxTb(type)
    --获取放置区域表
    return self._diningTable:getAreaTb(type)
end

--获取椅子
function M:getDeskTb()
    return self._deskTb
end

-- 加载结点
function M:loadPageNode()
    if self._type == 2 then
        self._round = 5
    elseif self._type == 3 then
        self._bgNodeNear:p(70, -30):scale(1)
        self._bgNodeFar:p(0, 0):scale(1)
    end
    local tb = { "Qq", "Mm", "Mom" }
    self._serveAniTb = T.shuffle(tb, 10)
    --加载窗户
    self:loadWindow()
    --加载场景
    self:loadGoods()
    --加载桌子
    self:loadDesk()
    --加载新一轮上菜
    self:loadNewServe()
end

--加载爸爸
function M:loadDad(type)
    type = ifnil(type, 1)
    local enterPos = cc.p(840 + X_OFFSET * 1.4, 200)
    local parent = self
    local dad = import("app.eveputfood.node.AniDad").new({
        layer     = self,
        enterPos  = enterPos,
        scaleSize = 1,
        type      = type
    }):to(parent, 100):scale(0.8):p(enterPos.x + 400, enterPos.y + 200)
    self._dad = dad
    if type == 0 then
        table.insert(self._aniTb, dad)
    end
    return dad
end

--加载妙妙
function M:loadMm(type)
    type = ifnil(type, 1)
    local size = type == 0 and 1 or 1.3
    local enterPos = cc.p(840 + X_OFFSET * 1.4, 170)
    local parent = self
    local mm = import("app.eveputfood.node.AniMm").new({
        layer     = self,
        enterPos  = enterPos,
        scaleSize = size,
        type      = type
    }):to(parent, 100):scale(0.8):p(enterPos.x + 400, enterPos.y + 200)
    self._mm = mm
    if type == 0 then
        table.insert(self._aniTb, mm)
    end
    return mm
end

--加载奇奇
function M:loadQq(type)
    type = ifnil(type, 1)
    local size = type == 0 and 1 or 1.3
    local enterPos = cc.p(840 + X_OFFSET * 1.4, 170)
    local parent = self
    local qq = import("app.eveputfood.node.AniQq").new({
        layer     = self,
        enterPos  = enterPos,
        scaleSize = size,
        type      = type
    }):to(parent, 100):scale(0.8):p(enterPos.x + 400, enterPos.y + 200)
    self._qq = qq
    if type == 0 then
        table.insert(self._aniTb, qq)
    end
    return qq
end

--加载妈妈
function M:loadMom(type)
    type = ifnil(type, 1)
    local parent = self
    local enterPos = cc.p(825 + X_OFFSET * 1.3, 185)
    local mom = import("app.eveputfood.node.AniMom").new({
        layer     = self,
        enterPos  = enterPos,
        scaleSize = 1,
        type      = type
    }):to(parent, 100):scale(0.8):p(enterPos.x + 400, enterPos.y + 200)
    self._mom = mom
    if type == 0 then
        table.insert(self._aniTb, mom)
    end
    return mom
end

--获取动物表
function M:getAniTb()
    return self._aniTb
end

--加载新一轮上菜
function M:loadNewServe()
    self._round = self._round + 1
    local ani = nil
    if self._round == 1 then
        --加载爸爸
        self:loadDad(1)
    elseif self._round == 2 or self._round == 3  or self._round == 4 then
        ani = self["load" .. self._serveAniTb[self._round-1]](self)
    elseif self._round == 5 then
        --加载爸爸
        ani = self:loadDad(2)
    else
        self._round = 0
        --加载奇奇
        self:loadQq(0)
        -- 加载妙妙
        self:loadMm(0)
        --加载妈妈
        self:loadMom(0)
        --加载爸爸
        self:loadDad(0)
        self:line({
            {"delay", 0},
            {"fn", function ()
                Tools:closeAd(true, false)
                --加载新一轮上座
                self:loadNewSitUp()      
            end}
        })
    end
    if ani and not tolua.isnull(ani)then
        --进场
        ani:enter()
    end
end

--加载新一轮上座
function M:loadNewSitUp()
    self._round = self._round + 1
    local ani = nil

    if self._round == 1 then
        --进场
        self._qq:enter()
    elseif self._round == 2 then
        --进场
        self._mm:enter()
    elseif self._round == 3 then
        --进场
        self._mom:enter()
    elseif self._round == 4 then
        --进场
        self._dad:enter()
    else
        --开始进食
        self:startEat()
    end
end

--开始进食
function M:startEat()
    self:line({
        {"Delay", 1},
        {"fn", function ()
            self._bgNodeFar:line({
                { "union", {
                    { "scaleto", 0.8, 1 },
                    { "moveto", 0.8, cc.p(0, 0) }
                } },
                {"fn", function ()
                    for i, v in ipairs(self._diningTable._foodsTab) do
                        v._canTouch = true
                    end    
                    self._diningTable:openGuide()
                end}
            })
            self._bgNodeNear:line({
                { "union", {
                    { "scaleto", 0.8, 1 },
                    { "moveto", 0.8, cc.p(70, -30) }
                } }
            })  
        end}
    })
end

-- 加载ok按钮
function M:loadOkBtn(pos)
    local okBtn = import("app.common.node.BaseOkBtn").new({
        imgName = "common/okbtn/line.png",
        pos     = pos,
    }):to(self, 999)
    self._okBtn = okBtn
end

-- 下一个事件
function M:okNextStep()
    --是否结束
    self:overEvent()
end

--喂食总数加1
function M:eatCountAdd()
    self._eatCount = self._eatCount + 1
    if self._eatCount == self._showSkipCount  then
        -- self._okBtn:enter()
        --跳过按钮进场
        self:getScene():getButtonLayer():btnSkipEnter()
    elseif self._eatCount >= self._allCount then
        self._isOver = true
    end
end

--是否结束
function M:overEvent()
    self._isOver = true
    self._canTouch = false
    self._diningTable:closeGuide()
    self._particle = Tools:newParticle("particle/mm_bighappy.plist", V.w_2, V.h_2 + 200):to(self, 1000)
    Tools:insertParticleTb(self, self._particle)
    -- 播放音效[sfx05700013]全屏星星粒子
    soundEffect:playEffectsfx05700013()
    -- 播放音效[sfx05706040]吃完开心庆贺
    soundEffect:playEffectsfx05706040()
    for i, v in ipairs(self._aniTb) do
        --站起
        v:standUpAni()
    end
    self:line({
        {"Delay", 2},
        {"fn", function ()
            --进入下个场景
            self:enterNextScene()
        end}
    })
end

--加入已坐下动物表
function M:insertSitAniTb(aniNode, pos)
    table.insert(self._sitAniTb, aniNode)
    self._orderAniTb[pos] = aniNode
end

--获取按顺序的落座表
function M:getOrderAniTb()
    return self._orderAniTb
end

--喂食等待动作
function M:openWaitFoodAct()
    if self._waitFoodAct then return end
    local index = 1
    local act = A.cycle({
        {"Delay", 5},
        {"fn", function ()
            --等待吃菜动作
            self._sitAniTb[index]:waitEatFoodAni()
            index = index + 1
            if index > #self._sitAniTb then
                index = 1
            end
        end}
    }):at(self)
    self._waitFoodAct = act
end

--关闭喂食等待动作
function M:closeWaitFoodAct()
    if self._waitFoodAct then
        self:stopAction(self._waitFoodAct)
        self._waitFoodAct = nil
    end
end

--获取筷子是否为点击状态
function M:getChopsticksTouch()
    return self._isTouch
end

--手指移动引导
function M:handeGuide(aniNode)
    if self._isHandGuide or self._isOver then return end
    self._isHandGuide = true
    local nodePos = aniNode:worldpoint()
    local endPos = self._deskTb[4]:worldpoint()
    nodePos = cc.p(nodePos.x, nodePos.y + 10)
    Tools:handMoveGuide(self, nodePos, endPos, nil, nil, false, function()

    end)
end

-- 移除手指移动引导
function M:removeHandGuide()
    if not self._isHandGuide then return end
    self._isHandGuide = false
    --移除手指移动引导
    Tools:removeHandMoveGuide(self)
end

--进入下个场景
function M:enterNextScene()
    game:enterScene("evemoney", {}, "fade", 0.5, COLOR3_WHITE)
end

--报菜名
function M:sayFoodName(id)
    if self._sayFoodNameVoice then
        sound.stopSound(self._sayFoodNameVoice)
        self._sayFoodNameVoice = nil
    end
    local foodVoiceName = { "v057073", "v057074", "v057076", "v057077", "v057078", "v057079", "v057075",}
    self._sayFoodNameVoice = soundVoice["playEffect" .. foodVoiceName[id]](soundVoice)
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
