--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 人物骨骼基类
----------------------
local M     = classArmatureTouch("AniBaseServe")
M.TAG       = "AniBaseServe"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer 	     = params.layer
	--触控
	self._canTouch       = false
	-- 骨骼信息
	self._file    		 = ifnil(params.file, "bone/cj_qmb")
	self._armatureName   = ifnil(params.armatureName, "cj_qmb")
	--食物在骨骼上的名字
	self._foodBoneNameTb = ifnil(params.foodBoneNameTb, { "qmb_cai", "qmb_cai1" })
	--食物在骨骼上的大小
	self._foodBoneSize	 = ifnil(params.foodBoneSize, { 0.85, 0.75 })
	--端上来的菜Id
	self._foodIdTb       = {1, 2}
	--端上来的菜
	self._foodTb         = {}
	--进场位置
	self._enterPos       = ifnil(params.enterPos, cc.p(880 + X_OFFSET, 175))
	--缩放大小
	self._scaleSize      = ifnil(params.scaleSize, 1)
	--状态 0:上座 
	self._type           = ifnil(params.type, 1)
	-- 吃的食物总数
	self._foodCount		 = 0
	--正在吃东西
	self._eatNow	     = false
	--吃的是火锅
	self._isHot 	     = false
end



----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
end

--打开食物定时器
function M:openFoodUpdate()
	self:scheduleUpdateWithPriorityLua(function(dt)
		for i, v in ipairs(self._foodTb) do
			local bone = self._armature:getBone(v._boneName)
			local pos = cc.p(bone:getPosition())
			local newPos = self:convertToNodeSpace(pos)
			if self._armatureName == "cj_qq" or  self._armatureName == "cj_mm" then
				newPos = cc.p(newPos.x, newPos.y + 3)
			elseif self._armatureName == "cj_qmb" and self._type == 2 then
				newPos = cc.p(newPos.x, newPos.y + 5)
			end
			v:p(newPos)
			v._shadow1:p(newPos.x, newPos.y + v._shadow1._offsetY)
		end
	end, 10)
end

--加载食物影子
function M:loadFoodShadow(id, pos)
	--加载影子
	local shadowImg = "eveputfood/food/shadow.png"
	if id == 1 then
		shadowImg = "eveputfood/food/1/shadow.png"
	elseif id == 2 then
		shadowImg = "eveputfood/food/2/shadow.png"
	elseif id == 7 then
		shadowImg = "eveputfood/food/7/shadow.png"
	end
	local shadow = D.img(shadowImg):to(self, 19):p(pos):hide():scale(0)
	shadow._offsetY = id == 7 and -20 or 0
	return shadow
end

--初始化菜的位置
function M:initFoodArea()
	local this = self
	--菜的总数
	self._count    = #self._foodBoneNameTb
	local boneNameTb = self._foodBoneNameTb
	local sizeTb = self._foodBoneSize

	for i, v in ipairs(boneNameTb) do
		local bone = self._armature:getBone(v)
		local pos = cc.p(bone:getPosition())
		local newPos = self:convertToNodeSpace(pos)
		bone:hide()

		--加载食物
		local size = sizeTb[i]
		local id = self._foodIdTb[i]
		local food = import("app.eveputfood.node.Food").new({
			layer = self._layer,
			id        = id,
		}):to(self, 20):p(newPos):scale(size)--:hide()

		--加载食物影子
		local shadow = self:loadFoodShadow(id, newPos)
		food._boneName = v
		food._shadow1 = shadow
		table.insert(self._foodTb, food)
		--加载食物区域
		self:loadFoodArea(newPos, food, i, size)
	end
	--打开食物定时器
	self:openFoodUpdate()
end

--加载食物区域
function M:loadFoodArea(newPos, food, index, size)
	local foodArea = U.loadNodeMask({
		contentSize = CCSize(100, 80),
	}):to(self, 50):p(newPos):bindTouch():opacity(0)
	foodArea._food = food
	foodArea._canTouch = true
	foodArea._index = index
	foodArea._size = size

	local this = self
	----------------------
	-- 点击
	----------------------
	function foodArea:onTouchBegan(x, y, touches)
		return this:touchBeganEvent(foodArea, x, y)
	end

	function foodArea:onTouchMoved(x, y, touches)
		this:touchMovedEvent(foodArea,x, y)
	end

	function foodArea:onTouchEnded(x, y, touches)
		this:touchEndEvent(foodArea, x, y)
	end
end

--食物点击事件
function M:touchBeganEvent(foodArea, x, y)
	if self._layer._canTouch then
		if self._canTouch and foodArea._canTouch then
			foodArea._canTouch = false
			self._canTouch     = false
			-- 播放音效[sfx05700001]通用点击
			soundEffect:playEffectsfx05700001()
			--关闭引导
			self:closeGuide()
			--放置区域闪烁
			self._layer._diningTable:putAreaFlash()
			foodArea._food:hide()
			--创建移动的食物
			foodArea._moveFood = self:creatMoveFood(self._foodIdTb[foodArea._index], cc.p(x, y), foodArea:worldpoint(), foodArea._size * self._scaleSize)
			foodArea._moveFood._shadow:hide()
			foodArea._moveFood._fitCascade = false
			return true
		end
	end
end

--食物移动事件
function M:touchMovedEvent(foodArea,x, y)
	if foodArea._moveFood and not tolua.isnull(foodArea._moveFood) then
		foodArea._moveFood:p(x - 45, y + 30)
		local adh = nil
		if foodArea._moveFood._id == 7 then
			adh = 100
			if NV.isMembers() then
				adh = adh - 80
			end
		end
		bb.si.Tool.limitRectMove({
			node = foodArea._moveFood,
			marginTop = adh,
			-- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
		})
		bb.si.Tool.limitButtonMove({node = foodArea._moveFood})
	end
end

--食物最终事件
function M:touchEndEvent(foodArea, x, y)
	--获取当前放置的位置
	self._layer._diningTable:stopPutAreaFlash()
	if foodArea._moveFood and not tolua.isnull(foodArea._moveFood) then
		local result
		--与锅碰撞检测
		result = foodArea._moveFood:collisionDetection()
        A.line({
			{"delay", 2},
			{"fn", function()
				self._canTouch = true
			end}
		}):at(self)

		if not result then
			foodArea._food._shadow1:line({
				{ "show" },
				{ "scaleto", 0.5, foodArea._size },
				{ "hide" },
				{ "fn", function()
					foodArea._food._shadow1:scale(0)
				end }
			})
			foodArea._moveFood:goBack(function()
				foodArea._food:show()
				foodArea._food:downAct()
				foodArea._moveFood = nil
				foodArea._canTouch = true
				--等待上菜
				self:waitPutFoodAni()
				--打开引导
				self:openGuide()
			end)
		else
			--移除食物
			self:removeFoodForTb(foodArea._food)
			self._count = self._count - 1
			if self._count == 0 then
				--上完菜
				self:afterServing()
			else
				--打开引导
				self:openGuide()
			end
		end
	end
end

--移除食物
function M:removeFoodForTb(food)
	T.removeOrder(self._foodTb, food)
end

--打开引导 1:端菜引导 2：上座引导
function M:openGuide(type)
	if self._guide then return end
	type = ifnil(type, 1)
	local time = 5
	local index = 1
    self._guide = A.cycle({
  		{ "delay", time },
		{ "fn", function()
			--等待语气音频
			self:waitEffect()
			if type == 1 then
				--等待上菜
				self:waitPutFoodAni()
				self._foodTb[index]:openGuide()
				index = index + 1
				if index > #self._foodTb then
					index = 1
				end
			else
				self:standbyFoodAni()
			end
        end },
    }):at(self)
end

--等待语气音频
function M:waitEffect()
	local effectTb = { cj_qq = "sfx05706009", cj_mm = "sfx05706006", cj_qmm = "sfx05706012", cj_qmb = "sfx05706003",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
end

--关闭引导
function M:closeGuide()
    if self._guide then
        self:stopAction(self._guide)
        self._guide = nil
    end
    for i, v in ipairs(self._foodTb) do
        v:closeGuide()
    end
end

--创建移动的食物 pos1:点击位置  pos2:返回位置
function M:creatMoveFood(id, pos1, pos2, size)
	local food = import("app.eveputfood.node.Food").new({
		layer     = self._layer,
		id		  = id,
		pos		  = pos2,
		scaleSize = size,
		flag      = self._canTouch
	}):to(self._layer, 120):p(pos1):scale(1)
	return food
end

--上完菜
function M:afterServing()

end

--进场
function M:enter()
	if self._type == 0 then
		--入场落座
		self:enterSitUp()
	else
		--进场
		self:enterFood()
	end
end

--进场
function M:enterFood()
	local effectTb = { cj_qq = "sfx05706008", cj_mm = "sfx05706005", cj_qmm = "sfx05706011", cj_qmb = "sfx05706001",}
	soundEffect["playEffect"..effectTb[self._armatureName]](soundEffect)
	if self._armatureName == "cj_qmb" and self._type == 2 then --火锅开始就报菜名
		--报菜名
		self._layer:sayFoodName(7)
	end
	-- 端菜走
	self:walkFoodAni()
    self:line({
        {"union",{
            {"scaleto", 1.5, self._scaleSize / self:getParent():scale()},
            {"moveto", 1.5, self._enterPos}
		}},
		{"fn", function ()
			--进场动作
			self:enterAct()
		end},
    })
end

--入场落座
function M:enterSitUp()
	local effectTb = { cj_qq = "sfx05706008", cj_mm = "sfx05706005", cj_qmm = "sfx05706011", cj_qmb = "sfx05706001",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
	-- 正面走
	self:walkFrontAni()
	self:line({
		{ "union", {
			{ "scaleto", 1.5, self._scaleSize / self:getParent():scale() },
			{ "moveto", 1.5, self._enterPos }
		} },
		{ "fn", function()
			--播放打招呼音效
			self:playStandByEffect()
			--待机
			self:standbyFoodAni()
			--上座进场其他
			self:enterSitUpOther()

			self:openGuide(2)
		end },
	})
end

--播放打招呼音效
function M:playStandByEffect()
	local effectTb = { cj_qq = "sfx05706018", cj_mm = "sfx05706005", cj_qmm = "sfx05706011", cj_qmb = "sfx05706001",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
end

--进场动作
function M:enterAct()
	
end

--上座进场其他
function M:enterSitUpOther()
	self._canTouch = true
end

--出场
function M:quit()
	local effectTb = { cj_qq = "sfx05706010", cj_mm = "sfx05706007", cj_qmm = "sfx05706013", cj_qmb = "sfx05706004",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
	-- 端菜走
	self:walkFoodAni()
	self:line({
        { "union", {
            { "scaleto", 1.5, 1.7 },
            { "moveto", 1.5, cc.p(self._enterPos.x, self._enterPos.y - 600) }
		} },
		{"fn",function ()
			--加载新一轮上菜
			self._layer:loadNewServe()
		end},
		{"remove",}
	})
end

--与椅子碰撞检测
function M:collisionDetection(x, y)
    local putFrames = {}
    local minNums = {}
    local min = 150
    local minDesk = nil
    local pos = self:worldpoint()
	--获取椅子
	local deskTb = self._layer:getDeskTb()
    for k, v in pairs(deskTb) do
        if not v._occupy then
            --转换成世界坐标
            local point = v:worldpoint()
            local distance = PT.distance(pos, point)
            if distance < min then
                table.insert(putFrames, v)
                table.insert(minNums, distance)
            end
        end
    end

    if #putFrames ~= 0 then
        --判断与哪个虚线框最近
        for k, v in ipairs(minNums) do
            if v < min then
                min = v
                minDesk = putFrames[k]
            end
        end
        --放置上去
        self:sitUp(minDesk)
        return true
	end
	self:goBack(x, y)
    return false
end

--获取人物偏移量
function M:getOffset(desk)
	local offsetX = 0
	local offsetY = 50
	if self._armatureName == "cj_qq" or self._armatureName == "cj_mm" then
		if desk._id == 4 then
			offsetX = -10
			offsetY = 30
		elseif desk._id == 1 then
			offsetX = 10
			offsetY = 30
		elseif desk._id == 2 or desk._id == 3 then
			offsetY = 30
		end
	elseif self._armatureName == "cj_qmm" then
		offsetX = -20
		offsetY = 10
		if desk._id == 1 then
			offsetX = -10
		end
	end
	return offsetX, offsetY
end

--落座
function M:sitUp(desk, direct)
	direct = ifnil(direct, false)
	local deskP = desk:point()
	--获取人物偏移量
	local offsetX, offsetY = self:getOffset(desk)
	local pos 	= cc.p(deskP.x + offsetX, deskP.y + offsetY)
	desk._occupy = true

	Tools:resetParent(self,self._layer._bgNodeNear, 20)
	if direct then
		self:scale(0.8 / 0.85):p(pos):z(10)
		-- 正常呼吸
		self:breathFoodAni3()
		return
	end
	--提起来
	self:putUpAni()
	--放置音效
	self:putDownEffect()
	self:line({
		{"union",{
			{ "scaleto", 0.3, 0.8 / self:getParent():scale() },
			{ "jumpto", 0.3, cc.p(pos.x, pos.y + 100), 50, 1 }
		}},
		{"fn", function ()
			self:z(10)
		end},
		{ "moveto", 0.15, pos},
		{ "fn", function ()
			--坐下
			self:sitFoodAni()
			-- 震动反馈
			desk:shakeAct()
			--加载新一轮上座
			self._layer:loadNewSitUp()
		end},
		{"Delay", 0.2},
		{"fn", function ()
			local newPos = self:worldpoint()
			local offsetTb2 = { cj_qq = 60, cj_mm = 60, cj_qmm = 100, cj_qmb = 100,}
			local offsetX = 0
			local offsetY = offsetTb2[self._armatureName]
			local particle = Tools:newParticle("particle/set.plist", newPos.x + offsetX, newPos.y + offsetY):to(self._layer, 1000)
			Tools:insertParticleTb(self._layer, particle)
			--加入已坐下动物表
			self._layer:insertSitAniTb(self, desk._id)
			--喂食等待动作
			self._layer:openWaitFoodAct()
		end}
	})
end

--返回
function M:goBack(x, y)
	local pos,scaleSize = self:getPutPos(ccp(x, y))
	--放置音效
	self:putDownEffect()
	self:line({
		{"union",{
			{"scaleto",0.5, scaleSize / self:getParent():scale() },
			{"jumpto",0.5, pos, 100, 1}
		}},
		{"fn", function ()
			--落下
			self:putDownAni()
			self:openGuide(2)
			self._canTouch = true
		end}
	})
end

-- 获取放下的坐标
function M:getPutPos()
	local pos = self:point()
    local x = pos.x
    local y = pos.y

	local offsetTb = { cj_qq = 60, cj_mm = 60, cj_qmm = 60, cj_qmb = 33,}
	x = x < (850 + X_OFFSET - offsetTb[self._armatureName]) and (850 + X_OFFSET - offsetTb[self._armatureName]) or x
	x = x > (V.w - offsetTb[self._armatureName]) and 870 + X_OFFSET or x
	y = y < (10 + self:ch() / 2) and (10 + self:ch()/2) or y
	y = y > 250 and 250 or y

	local dis = y - self._enterPos.y
	local offset = dis < 0 and 1 or -1 
	local scaleSize = self._scaleSize * (1 + offset * math.abs(dis)/800)
    return ccp(x,y), scaleSize
end

--获取嘴的坐标
function M:getMousePos()
	local boneNameTb = {cj_qq = "qq_zui", cj_mm = "mm_zui",cj_qmm = "qmm_zui",cj_qmb = "qmb_zui",}
	local bone = self._armature:getBone(boneNameTb[self._armatureName])
	local pos = cc.p(bone:getPosition())
	return pos
end

--张开嘴
function M:openMouseAni()
	local boneNameTb = { cj_qq = "qq_zz", cj_mm = "mm_zz", cj_qmm = "qmm_zz", cj_qmb = "qmb_zz",}
	self:play(boneNameTb[self._armatureName])
	--张嘴音效
	self:openMouseEffect()
end

--张嘴音效
function M:openMouseEffect()
	if self._layer._isOpenEffect then return end
	self._layer._isOpenEffect = true
	self:line({
		{"Delay", 1},
		{"fn", function ()
			self._layer._isOpenEffect = false
		end}
	})
	local effectTb = { cj_qq = "sfx05706030", cj_mm = "sfx05706041", cj_qmm = "sfx05706043", cj_qmb = "sfx05706042",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
end

--张开嘴呼吸
function M:openMouseBreathAni()
    local boneNameTb = { cj_qq = "qq_zzhx", cj_mm = "mm_zzhx", cj_qmm = "qmm_zzhx", cj_qmb = "qmb_zzhx",}
    self:play(boneNameTb[self._armatureName])
end

--咬住
function M:biteFoodAni()
	local boneNameTb = { cj_qq = "qq_yz", cj_mm = "mm_yz", cj_qmm = "qmm_yz", cj_qmb = "qmb_yz",}
	self:play(boneNameTb[self._armatureName])
end

--第一次咀嚼
function M:eatAni1()
	local boneNameTb = { cj_qq = "qq_jj1", cj_mm = "mm_jj1", cj_qmm = "qmm_jj1", cj_qmb = "qmb_jj1",}
	local effectTb = {cj_qq = "sfx05706032", cj_mm = "sfx05706034", cj_qmm = "sfx05706036", cj_qmb = "sfx05706038",}
	if not self._isHot then
		self._eatAni1Effect = soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
	end
	self:play(boneNameTb[self._armatureName])
	--咀嚼粒子
	self:eatParticle()
end

--第二次咀嚼
function M:eatAni2()
	self._foodCount = 0
	local boneNameTb = { cj_qq = "qq_jj2", cj_mm = "mm_jj2", cj_qmm = "qmm_jj2", cj_qmb = "qmb_jj2",}
	local effectTb = { cj_qq = "sfx05706033", cj_mm = "sfx05706035", cj_qmm = "sfx05706037", cj_qmb = "sfx05706039",}
	if not self._isHot then
		self._eatAni2Effect = soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
	end
	self:play(boneNameTb[self._armatureName], nil, {loop = 0})
	--咀嚼粒子
	self:eatParticle()
end

--停止咀嚼音效
function M:stopEatEffect()
    if self._eatAni1Effect then
        sound.stopSound(self._eatAni1Effect)
        self._eatAni1Effect = nil
	end
	if self._eatAni2Effect then
		sound.stopSound(self._eatAni2Effect)
		self._eatAni2Effect = nil
	end
end

--吃火锅的音效
function M:playHotEffect()
	if not self._isHot then return end
	local effectTb = { cj_qq = "sfx05706049", cj_mm = "sfx05706050", cj_qmm = "sfx05706051", cj_qmb = "sfx05706048",}
	self._hotEffect = soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
end

--停止吃火锅音效
function M:stopHotEffect()
	if self._hotEffect then
		sound.stopSound(self._hotEffect)
		self._hotEffect = nil
	end
end

--咀嚼粒子
function M:eatParticle()
	--移除吃的粒子
	self:removeEatParticle()
	--获取嘴的坐标
	local newPos = self:getMousePos()
	self._eatParticle = Tools:newParticle("particle/eat.plist", newPos.x, newPos.y):to(self._layer, 1000)
	Tools:insertParticleTb(self._layer, self._eatParticle)
end

--移除吃的粒子
function M:removeEatParticle()
	if self._eatParticle and not tolua.isnull(self._eatParticle) then
		self._eatParticle:remove()
		self._eatParticle = nil
	end
end

--吞咽
function M:swallowAni2()
    local boneNameTb = { cj_qq = "qq_ty", cj_mm = "mm_ty", cj_qmm = "qmm_ty", cj_qmb = "qmb_ty",}
    self:play(boneNameTb[self._armatureName])
end

--激励
function M:excitationAni1()
	local boneNameTb = { cj_qq = "qq_jl1", cj_mm = "mm_jl1", cj_qmm = "qmm_jl1", cj_qmb = "qmb_jl1",}
	self:play(boneNameTb[self._armatureName])
end

--激励
function M:excitationAni0()
    local boneNameTb = { cj_qq = "qq_jl0", cj_mm = "mm_jl0", cj_qmm = "qmm_gz0", cj_qmb = "qmb_jl0",}
    self:play(boneNameTb[self._armatureName])
end

--站起
function M:standUpAni()
	--移除吃的粒子
	self:removeEatParticle()
    local boneNameTb = { cj_qq = "qq_zhan", cj_mm = "mm_zhan", cj_qmm = "qmm_zhan", cj_qmb = "qmb_zhan",}
    self:play(boneNameTb[self._armatureName])
end

--激激励
function M:excitationAni2()
	local boneNameTb = { cj_qq = "qq_jl2", cj_mm = "mm_jl2", cj_qmm = "qmm_jl2", cj_qmb = "qmb_jl2",}
	self:play(boneNameTb[self._armatureName])
end

--喷火
function M:fireAni()
	local boneNameTb = { cj_qq = "qq_chg", cj_mm = "mm_chg", cj_qmm = "qmm_chg", cj_qmb = "qmb_chg",}
	self:play(boneNameTb[self._armatureName])
end

--等待上菜
function M:waitPutFoodAni()
	local boneNameTb = { cj_qq = "qq_kc", cj_mm = "mm_kc", cj_qmm = "qmm_kc", cj_qmb = "qmb_kc",}
	self:play(boneNameTb[self._armatureName])	
end

--等待吃菜动作
function M:waitEatFoodAni()
	local boneNameTb = { cj_qq = "qq_kx", cj_mm = "mm_kx", cj_qmm = "qmm_hx3_1", cj_qmb = "qmb_hx3_1",}
	self:play(boneNameTb[self._armatureName], nil, { loop = 0 })
	local effectTb = { cj_qq = "sfx05706046", cj_mm = "sfx05706047",}
	if effectTb[self._armatureName] then
		soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
	end
end

-- 菜被端走摆在桌子上，角色点头开心
function M:foodPutRightAni()
	local boneNameTb = { cj_qq = "qq_xiao1", cj_mm = "mm_xiao1", cj_qmm = "qmm_xiao1", cj_qmb = "qmb_xiao1",}
	self:play(boneNameTb[self._armatureName], nil, { loop = 0 })
end

--提起来
function M:putUpEffect()
	if not self._effectAct then
		self._effectAct = A.line({
			{ "delay", 0.1 },
			{ "fn", function()
				if not self._putUpEffec then
					local effectTb = { cj_qq = "sfx05706019", cj_mm = "sfx05706021", cj_qmm = "sfx05706023", cj_qmb = "sfx05706027",}
					self._putUpEffect = soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
				end
			end }
		}):at(self)
	end
end

--停止提起来音效
function M:stopPutUpEffect()
	if self._putUpEffect then
		sound.stopSound(self._putUpEffect)
		self._putUpEffect = nil
	end
	if self._effectAct then
		self:stopAction(self._effectAct)
		self._effectAct = nil
	end
end

--放置音效
function M:putDownEffect()
	local effectTb = { cj_qq = "sfx05706020", cj_mm = "sfx05706022", cj_qmm = "sfx05706024", cj_qmb = "sfx05706028",}
	soundEffect["playEffect" .. effectTb[self._armatureName]](soundEffect)
end

--咀嚼完毕
function M:chewOver(type)
	type = ifnil(type, 1)
	--移除吃的粒子
	self:removeEatParticle()
	--吃火锅
	if self._isHot then
		self._isHot = false
		--喷火
		self:fireAni()
	else
		if type == 1 then
			--激励
			self:excitationAni0()
		else
			--激励
			self:excitationAni1()
		end
	end
end

--激励完毕，判断是否需要张嘴
function M:eatOver()
	if self._layer._isOver then
		local scene = self:getScene()
		local buttonLayer = nil
		if scene and scene.getButtonLayer then
			buttonLayer = scene:getButtonLayer()
		end
		if buttonLayer and buttonLayer.btnSkipEvent then
			buttonLayer:btnSkipEvent()
		end
	else
		local touch = self._layer:getChopsticksTouch()
		self._eatNow = false
		--移除吃的粒子
		self:removeEatParticle()
		if touch then
			--张开嘴
			self:openMouseAni()
		else
			--喂食等待动作
			self._layer:openWaitFoodAct()
			-- 正常呼吸
			self:breathFoodAni3()
		end
	end
end

--判断吃的次数
function M:judgeEatCount()
	--停止咀嚼音效
	self:stopEatEffect()
	--停止吃火锅音效
	self:stopHotEffect()
	--吃火锅的音效
	self:playHotEffect()
	self._foodCount = self._foodCount + 1
	if self._foodCount == 1 then
		--第一次咀嚼
		self:eatAni1()
	elseif self._foodCount == 2 then
		--第二次咀嚼
		self:eatAni2()
	end
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "" then

		end
	elseif __evtType == 2 then

	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
	Tools:removeParticleTb(self)
end
----------------------
-- 点击
----------------------
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch and self._type == 0 then
            self._canTouch = false
            --提起来
			self:putUpAni()
			--提起来
			self:putUpEffect()
			--关闭引导
			self:closeGuide()
			-- 移除手指移动引导
			self._layer:removeHandGuide()
            return true
        end
    end
end

function M:onTouchMoved(x, y, touches)
    self:p(x, y)
end

function M:onTouchEnded(x, y, touches)
	--停止提起来音效
	self:stopPutUpEffect()
    --与椅子碰撞检测
    self:collisionDetection(x, y)
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
