--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 爸爸类
----------------------
local M     = class("AniDad", import("app.eveputfood.node.AniBaseServe"))
M.TAG       = "AniDad"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	-- 骨骼信息
	self._file           = "bone/cj_qmb"
	self._armatureName   = "cj_qmb"
	--状态
	self._type			 = ifnil(params.type, 1)
	--食物在骨骼上的名字
	self._foodBoneNameTb = self._type == 1 and { "qmb_cai", "qmb_cai1" } or { "qmb_cai2"}
	--食物在骨骼上的大小
	self._foodBoneSize   = self._type == 1 and { 0.88, 0.8 } or { 0.85} 
	--端上来的菜Id
	self._foodIdTb       = self._type == 1 and { 1, 2 } or { 7 }
end



----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	if self._type == 1 or self._type == 2 then
		if self._type == 1 then
			self._armature:getBone("qmb_cai2"):hide()
		else
			self._armature:getBone("qmb_cai"):hide()
			self._armature:getBone("qmb_cai1"):hide()
		end
		-- 呼吸
		self:breathFoodAni1()
		--初始化菜的位置
		self:initFoodArea()
	else

	end
end

-- 端菜走
function M:walkFoodAni()
	self:play("qmb_zou")
end

-- 正面走
function M:walkFrontAni()
	self:play("qmb_zou1")
end

-- 端菜呼吸
function M:breathFoodAni1()
    self:play("qmb_hx")
end

-- 端菜微笑呼吸
function M:breathFoodAni2()
    self:play("qmb_hx1")
end

-- 端菜说话（开始)
function M:talkFoodAni1_1()
    self:play("qmb_sh1")
end

-- 端菜说话（循环)
function M:talkFoodAni1_2()
    self:play("qmb_sh1_1")
end

-- 端菜说话（结束)
function M:talkFoodAni1_3()
    self:play("qmb_sh1_2")
end

--菜上桌之后说话
function M:foodFinishTalkAni()
 	self:play("qmb_sh2")
end

-- 菜被端上桌后笑
function M:foodSmileAni()
	self:play("qmb_xiao1")
end

-- 正常呼吸
function M:breathFoodAni2()
    self:play("qmb_hx2")
end

--看着桌面呼吸
function M:breathFoodAni3()
    self:play("qmb_hx3")
end

--呼吸
function M:breathFoodAni4()
    self:play("qmb_hx4")
end

--微笑眼呼吸
function M:breathFoodAni5()
    self:play("qmb_hx5")
end

--待机
function M:standbyFoodAni()
 	self:play("qmb_dj")
end

--提起来
function M:putUpAni()
	self:play("qmb_ling")	
end

--落下
function M:putDownAni()
	self:play("qmb_luo")
end

--坐下
function M:sitFoodAni()
	self:play("qmb_zuo")
end

--开心
function M:happyFoodAni()
	self:play("qmb_kx", nil, {loop = 0})
	-- 播放音效[sfx05706045]放到椅子上爸爸笑
	soundEffect:playEffectsfx05706045()
end

--张嘴
function M:mouthFoodAni()
    self:play("qmb_zz")
end

--张嘴呼吸
function M:mouthBreathFoodAni()
    self:play("qmb_zzhx")
end

--咬住
function M:biteFoodAni()
    self:play("qmb_yz")
end

--进场动作
function M:enterAct()
	if self._type == 1 then
		--进场动作
		self:enterAct1()
	else
		--进场动作
		self:enterAct2()
	end
end

--进场动作
function M:enterAct1()
	-- 播放配音[v057056]上菜咯，把美味的饭菜摆上桌吧~
	soundVoice:playEffectv057056()
	-- 播放音效[sfx05706002]爸爸举手托餐盘
	soundEffect:playEffectsfx05706002()
	local time = soundVoice:soundDuration("v057056", 3) + 0.5
    self:line({
		{ "fn", function()
            -- 端菜说话（开始)
            self:talkFoodAni1_1()
            for i, v in ipairs(self._foodTb) do
                v:line({
                    { "Delay", 0.55 },
                    { "rotateTo", 0.05, 0 + 5 },
                    { "rotateTo", 0.05, 0 - 5 },
                    { "rotateTo", 0.04, 0 + 3 },
                    { "rotateTo", 0.04, 0 - 3 },
                    { "rotateTo", 0.03, 0 + 0 },
                })
            end
        end },
        { "delay", time },
        { "fn", function()
            -- 端菜说话（结束)
			self:talkFoodAni1_3()
			--打开引导
			self:openGuide()
        end },
    })
end

--进场动作
function M:enterAct2()
    -- 端菜呼吸
	self:breathFoodAni1()
	self._canTouch = true
	--打开引导
	self:openGuide()
end

--上完菜
function M:afterServing()
	-- 菜被端走摆在桌子上，角色点头开心
	self:foodPutRightAni()
	if self._type == 2 then
		-- 播放配音[v057057]哈哈哈，真是一桌好菜，去喊大家吃饭咯~
		soundVoice:playEffectv057057()
		self._isEnd = true
	end
end

--最后动作
function M:finishAct()
	--菜上桌之后说话
	self:foodFinishTalkAni()
	local time = soundVoice:soundDuration("v057057", 3) - 2
	self:line({
		{"delay", time},
		{"fn", function ()
			--出场
			self:quit()
		end}
	})
end

function M:movementHandler( __evtType, __moveId )
	-- [超类调用]
	M.super.movementHandler(self)
	if __evtType == 1 then
		if __moveId == "qmb_sh1" then
			self:talkFoodAni1_2()	-- 端菜说话（循环)
		elseif __moveId == "qmb_sh1_2" then
			self._canTouch = true
			self:breathFoodAni1()	-- 端菜呼吸
		elseif __moveId == "qmb_kc" then
			self:breathFoodAni1()	-- 端菜呼吸
		elseif __moveId == "qmb_xiao1" then
			if self._isEnd then
				self:finishAct()	--最后动作
			else
				self:quit()
			end
		elseif __moveId == "qmb_dj" or __moveId == "qmb_jl2" then
			self:breathFoodAni2()	-- 正常呼吸
		elseif __moveId == "qmb_zuo" then
			self:happyFoodAni()		--开心
		elseif __moveId == "qmb_kx" or __moveId == "qmb_hx3_1" then
			-- 正常呼吸
			self:breathFoodAni3()
		elseif __moveId == "qmb_jl1"  or __moveId == "qmb_chg" or __moveId == "qmb_jl0" then
			--激励完毕，判断是否需要张嘴
			self:eatOver()
		elseif __moveId == "qmb_jj1" then
			--咀嚼完毕
			self:chewOver()
		elseif __moveId == "qmb_luo"  then
			-- 正常呼吸
			self:breathFoodAni2()
		elseif __moveId == "qmb_zz"  then
			--张开嘴呼吸
			self:openMouseBreathAni()
		elseif __moveId == "qmb_yz" then
			--判断吃的次数
			self:judgeEatCount()
		elseif __moveId == "qmb_jj2" then
			--移除吃的粒子
			self:removeEatParticle()
			--吞咽
			self:swallowAni2()
		elseif __moveId == "qmb_ty" then
			--咀嚼完毕
			self:chewOver(2)
		elseif __moveId == "qmb_zhan" then
			--激激励
			self:excitationAni2()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

-- function M:onTouchBegan(x, y, touches)

-- 	return true
-- end

-- function M:onTouchMoved(x, y, touches)

-- end

-- function M:onTouchEnded(x, y, touches)
	
-- end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
