--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妙妙类
----------------------
local M     = class("AniMm", import("app.eveputfood.node.AniBaseServe"))
M.TAG       = "AniMm"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)

	-- 骨骼信息
	self._file    = "bone/cj_mm"
	self._armatureName = "cj_mm"
	--食物在骨骼上的名字
	self._foodBoneNameTb 	=  { "mm_cai" }
	--食物在骨骼上的大小
	self._foodBoneSize    	= { 0.57}
	--端上来的菜Id
	self._foodIdTb = { 3}
end



----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	if self._type == 0 then

	else
		-- 呼吸
		self:breathFoodAni1()
		--初始化菜的位置
		self:initFoodArea()
	end
end

-- 端菜走
function M:walkFoodAni()
	self:play("mm_zou")
end

-- 正面走
function M:walkFrontAni()
	self:play("mm_zou1")
end

-- 端菜呼吸
function M:breathFoodAni1()
    self:play("mm_hx1")
end

-- 正常呼吸
function M:breathFoodAni2()
    self:play("mm_hx2")
end

--看着桌面呼吸
function M:breathFoodAni3()
    self:play("mm_hx3")
end

--待机
function M:standbyFoodAni()
 	self:play("mm_dj")
end

--提起来
function M:putUpAni()
	self:play("mm_ling")	
end

--落下
function M:putDownAni()
    self:play("mm_luo")
end

--坐下
function M:sitFoodAni()
	self:play("mm_zuo")
end

--开心
function M:happyFoodAni()
	self:play("mm_kx")
end

--张嘴
function M:mouthFoodAni()
    self:play("mm_zz")
end

--张嘴呼吸
function M:mouthBreathFoodAni()
    self:play("mm_zzhx")
end

--咬住
function M:biteFoodAni()
    self:play("mm_yz")
end

--讲话
function M:talkFoodAni1_1()
	self:play("mm_sh1")
end

--讲话循环
function M:talkFoodAni1_2()
	self:play("mm_sh1_1")
end

--讲话结束
function M:talkFoodAni1_3()
	self:play("mm_sh1_2")
end


--进场动作
function M:enterAct()
	-- 端菜呼吸
	self:breathFoodAni1()
	self._canTouch = true
	--打开引导
	self:openGuide()
end

--上完菜
function M:afterServing()
	-- 菜被端走摆在桌子上，角色点头开心
	self:foodPutRightAni()
end

--讲话 好香呀~
function M:talkEvent()
	-- 播放配音[v057059]好香呀~
	soundVoice:playEffectv057059()
	--讲话循环
	self:talkFoodAni1_2()
	local time = soundVoice:soundDuration("v057059", 2)
	self:line({
		{"Delay", time},
		{"fn", function ()
			--讲话结束
			self:talkFoodAni1_3()
		end}
	})
end


function M:movementHandler( __evtType, __moveId )
	-- [超类调用]
	M.super.movementHandler(self)
	if __evtType == 1 then
		if __moveId == "mm_dj" or __moveId == "mm_jl2" then
			-- 正常呼吸
			self:breathFoodAni2()
		elseif __moveId == "mm_zuo" then
			--讲话
			self:talkFoodAni1_1()
		elseif __moveId == "mm_sh1" then
			--讲话 好香呀~
			self:talkEvent()
		elseif  __moveId == "mm_sh1_2" or __moveId == "mm_kx" then
			-- 正常呼吸
			self:breathFoodAni3()
		elseif __moveId == "mm_jl1"  or __moveId == "mm_chg" or __moveId == "mm_jl0" then 
			--激励完毕，判断是否需要张嘴
			self:eatOver()
		elseif __moveId == "mm_jj1" then
			--咀嚼完毕
			self:chewOver()
		elseif __moveId == "mm_luo" then
			-- 正常呼吸
			self:breathFoodAni2()
		elseif __moveId == "mm_zz" then
			--张开嘴呼吸
			self:openMouseBreathAni()
		elseif __moveId == "mm_yz" then
			--判断吃的次数
			self:judgeEatCount()
		elseif __moveId == "mm_jj2" then
			--移除吃的粒子
			self:removeEatParticle()
			--吞咽
			self:swallowAni2()
		elseif __moveId == "mm_ty" then
			--咀嚼完毕
			self:chewOver(2)
		elseif __moveId == "mm_zhan" then
			--激激励
			self:excitationAni2()
		elseif __moveId == "mm_kc"then
			-- 端菜呼吸
			self:breathFoodAni1()
		elseif  __moveId == "mm_xiao1" then
			--出场
			self:quit()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 点击
----------------------

-- function M:onTouchBegan(x, y, touches)

-- 	return true
-- end

-- function M:onTouchMoved(x, y, touches)

-- end

-- function M:onTouchEnded(x, y, touches)
	
-- end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
