--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 妈妈类
----------------------
local M     = class("AniMom", import("app.eveputfood.node.AniBaseServe"))
M.TAG       = "AniMom"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)

	-- 骨骼信息
	self._file    		    = "bone/cj_qmm"
	self._armatureName 		= "cj_qmm"
	--食物在骨骼上的名字
	self._foodBoneNameTb 	=  { "qmm_cai",  "qmm_cai1",}
	--食物在骨骼上的大小
	self._foodBoneSize    	= { 0.9, 0.9}
	--端上来的菜Id
	self._foodIdTb 			= {5, 6}
end



----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	if self._type == 0 then

	else
		-- 呼吸
		self:breathFoodAni1()
		--初始化菜的位置
		self:initFoodArea()
	end
end

-- 端菜走
function M:walkFoodAni()
	self:play("qmm_zou")
end

-- 正面走
function M:walkFrontAni()
	self:play("qmm_zou1")
end

-- 端菜呼吸
function M:breathFoodAni1()
    self:play("qmm_hx1")
end

-- 正常呼吸
function M:breathFoodAni2()
    self:play("qmm_hx2")
end

--看着桌面呼吸
function M:breathFoodAni3()
    self:play("qmm_hx3")
end

--呼吸
function M:breathFoodAni4()
    self:play("qmm_hx4")
end

--微笑眼呼吸
function M:breathFoodAni5()
    self:play("qmm_hx5")
end

--待机
function M:standbyFoodAni()
 	self:play("qmm_dj")
end

--提起来
function M:putUpAni()
	self:play("qmm_ling")	
end

--落下
function M:putDownAni()
    self:play("qmm_luo")
end

--坐下
function M:sitFoodAni()
	self:play("qmm_zuo")
end

--开心
function M:happyFoodAni()
	self:play("qmm_kx", nil, { loop = 0 })
	-- 播放音效[sfx05706044]放到椅子上妈妈笑
	soundEffect:playEffectsfx05706044()
end

--张嘴
function M:mouthFoodAni()
    self:play("qmm_zz")
end

--张嘴呼吸
function M:mouthBreathFoodAni()
    self:play("qmm_zzhx")
end

--咬住
function M:biteFoodAni()
    self:play("qmm_yz")
end


--进场动作
function M:enterAct()
	-- 端菜呼吸
	self:breathFoodAni1()
	self._canTouch = true
	--打开引导
	self:openGuide()
end

--上完菜
function M:afterServing()
	-- 菜被端走摆在桌子上，角色点头开心
	self:foodPutRightAni()
end

function M:movementHandler( __evtType, __moveId )
	-- [超类调用]
	M.super.movementHandler(self)
	if __evtType == 1 then
		if __moveId == "qmm_dj" or __moveId == "qmm_jl2" then
			-- 正常呼吸
			self:breathFoodAni2()
		elseif __moveId == "qmm_zuo" then
			--开心
			self:happyFoodAni()
		elseif __moveId == "qmm_kx" or __moveId == "qmm_hx3_1" then
   			-- 正常呼吸
			self:breathFoodAni3()
		elseif __moveId == "qmm_jl1" or __moveId == "qmm_chg" or __moveId == "qmm_gz0" then
			--激励完毕，判断是否需要张嘴
			self:eatOver()		
		elseif __moveId == "qmm_jj1" then
			--咀嚼完毕
			self:chewOver()
		elseif __moveId == "qmm_luo" then
			-- 正常呼吸
			self:breathFoodAni2()
		elseif __moveId == "qmm_zz" then
			--张开嘴呼吸
			self:openMouseBreathAni()
		elseif __moveId == "qmm_yz" then
			--判断吃的次数
			self:judgeEatCount()
		elseif __moveId == "qmm_jj2" then
			--移除吃的粒子
			self:removeEatParticle()
			--吞咽
			self:swallowAni2()
		elseif __moveId == "qmm_ty" then
			--咀嚼完毕
			self:chewOver(2)
		elseif __moveId == "qmm_zhan" then
			--激激励
			self:excitationAni2()
		elseif __moveId == "qmm_kc"then
			-- 端菜呼吸
			self:breathFoodAni1()
		elseif __moveId == "qmm_xiao1" then
			--出场
			self:quit()
		end
	end
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end




----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end


return M
