--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 餐桌类
----------------------
local M     = classSpriteTouch("DiningTable")
M.TAG       = "DiningTable"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer       = params.layer
    --触控
    self._canTouch    = false
    --食物虚线框
    self._boxTb       = {}
    --火锅虚线框
    self._hotPotBoxTb = {}
    -- 1：上菜 2：落座 3：吃饭
    self._type        = ifnil(params.type, 1)
    --桌上的食物
    self._foodsTab    = {}
    --可以夹的食物
    self._canChooseFoodTb      = {}
    --食物的大小
    self._foodScaleSize = 1.13
    --碗的表
    self._bowlTb        = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    self:display("eveputfood/desk/3.png")
end

-- 加载结点
function M:loadPageNode()
    --加载碗筷
    self:loadMeal()
    --初始化菜放的区域
    self:initFoodArea()
end

--加载碗筷
function M:loadMeal()
    --筷子
    local posTb = { cc.p(140, 353.4), cc.p(303.9, 408.6), cc.p(503.3, 419.9), cc.p(699.6, 382.5),}
    for k, v in ipairs(posTb) do
        local chopsticks = D.img("eveputfood/desk/other/" .. k .. ".png"):to(self):p(v)
        table.insert(self._foodsTab, chopsticks)
    end
    --碗
    local posTb = { cc.p(183.1, 378.8), cc.p(350.3, 423.7), cc.p(550.1, 421.7), cc.p(729.5, 371.9),}
    for k, v in ipairs(posTb) do
        local meal = D.img("eveputfood/desk/other/meal.png"):to(self):p(v)
        table.insert(self._foodsTab, meal)
        table.insert(self._bowlTb, meal)
    end
end

--初始化菜放的区域
function M:initFoodArea()
    local posTb = { cc.p(330.1, 340.6), cc.p(583, 340.6), 
                    cc.p(199.3, 274.9), cc.p(710.2, 274.9), 
                    cc.p(340.2, 202.5), cc.p(575.5, 202.5),
                    cc.p(455.7, 280.3),}
    for i, v in ipairs(posTb) do
        local box = D.img("eveputfood/desk/box.png"):to(self):p(v):hide():opacity(0)
        box._haveFood = false
        if i == 7 then
            --火锅虚线框
            table.insert(self._hotPotBoxTb, box)
        else
            table.insert(self._boxTb, box)
        end
        if self._type == 2 or self._type == 3 then
            --加载食物
            self:loadFood(box, i) 
        end
    end
end

--放置区域闪烁
function M:putAreaFlash()
    --获取当前放置的位置
    local areaTb = self._layer._round ~= 5  and self._boxTb or self._hotPotBoxTb
    for k, area in pairs(areaTb) do
        --闪烁动画
        if not tolua.isnull(area) and not area._flashAction and not area._haveFood then
            area:show()
            local time2 = 1
            area._flashAction = A.cycle({
                { "fadeTo", time2, 255 },
                { "fadeTo", time2, 0 },
            }):at(area)
        end
    end
end

--停止放置位置闪烁
function M:stopPutAreaFlash()
    --获取当前放置的位置
    local areaTb = self._layer._round ~= 5 and self._boxTb or self._hotPotBoxTb
    for k, area in pairs(areaTb) do
        if not tolua.isnull(area) and area._flashAction then
            area:hide()
            area:opacity(0)
            area:stopAction(area._flashAction)
            area._flashAction = nil
        end
    end
end

--获取放置区域表
function M:getAreaTb(type)
    local boxTb = type == 1 and self._boxTb or self._hotPotBoxTb
    return boxTb
end

--加载食物
function M:loadFood(box, id)
    local pos = box:point()
    local size = self._foodScaleSize
    local food = import("app.eveputfood.node.Food").new({
        layer = self._layer,
        id         = id,
        pos        = pos,
        scaleSize  = size
    }):to(self, 20):p(pos):scale(size)
    table.insert(self._foodsTab, food)
    table.insert(self._canChooseFoodTb, food)
    if self._type == 1 then
        --下落动作
        food:downAct(2) 
    end
end

--加载食物的阴影
function M:loadFoodShadow(box, id)
    local shadowImg = "eveputfood/food/shadow.png"
    local pos = box:point()
    if id == 1 then
        shadowImg = "eveputfood/food/1/shadow.png"
    elseif id == 2 then
        shadowImg = "eveputfood/food/2/shadow.png"
    elseif id == 7 then
        shadowImg = "eveputfood/food/7/shadow.png"
        local pot = D.img("eveputfood/food/7/base.png"):to(self):p(pos):anchor(cc.p(0.5, 0.38)):hide()
        local potShadowP = pot:convertToWorldSpace(cc.p(66.9, 15.9))
        pos = self:convertToNodeSpace(potShadowP)
        pot:remove()
    end
    local shadow = D.img(shadowImg):to(self, 1):p(pos):scale(0)
    shadow:line({
        {"scaleTo", 0.5, 1},
        {"hide",},
        {"remove",}
    })
end

-- 震动反馈
function M:shakeAct()
    -- 震动
    A.line({
        { "scaleTo", 0.15, 1.003, 0.997 },
        { "scaleTo", 0.15, 0.997, 1.003 },
        { "scaleTo", 0.12, 1.002, 0.998 },
        { "scaleTo", 0.12, 0.998, 1.002 },
        { "scaleTo", 0.1, 1 },
    }):at(self)
    -- 跳动
    for i, v in ipairs(self._foodsTab) do
        local number = RD.number(1, 6)
        local time = RD.number(5, 10) * 0.015
        A.line({
            { "moveBy", time, ccp(0, number) },
            { "moveBy", time, ccp(0, -number) },
            { "fn", function()
                commonAct:nodeScale(v, 0.1, 0.1)
            end }
        }):at(v)
    end
end

--移除食物
function M:removeFoodForTb(food)
    T.removeOrder(self._canChooseFoodTb, food)
end

--打开引导
function M:openGuide()
    if self._guide then return end
    local index = 1
    self._guide = A.cycle({
        { "delay", 3 },
        { "fn", function()
            if self._canChooseFoodTb then
                if (not tolua.isnull(self._canChooseFoodTb[index])) then
                    self._canChooseFoodTb[index]:openGuide2()
                    index = index + 1
                    if index > #self._canChooseFoodTb then
                        index = 1
                    end
                end
            end
        end },
    }):at(self)
end

--关闭引导
function M:closeGuide()
    if self._guide then
        self:stopAction(self._guide)
        self._guide = nil
    end
    for i, v in ipairs(self._canChooseFoodTb) do
        if v.closeGuide then
            v:closeGuide2()
        end
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
