--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 食物类
----------------------
local M     = class("Food", import("app.common.node.BaseNode"))
M.TAG       = "Food"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    --菜品种类
    self._id        = ifnil(params.id, 1)
    --菜品坐标
    self._pos       = ifnil(params.pos, cc.p(100,100))
    --缩放大小
    self._scaleSize = ifnil(params.scaleSize, 1)
    -- 食物
    self._foodTb    = {}
    --吃的顺序
    self._orderTb   = {}
    --点的次数
    self._count     = 0 
    -- 标志位
    self._flag      = params.flag
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()

end

-- 图片渲染
function M:loadDisplay()
    local anchor = cc.p(0.5, 0.5)
    local img = "eveputfood/food/plate.png"
    local shadowImg = "eveputfood/food/shadow.png"
    if self._id == 1 then
        img = "eveputfood/food/1/plate.png"
        shadowImg = "eveputfood/food/1/shadow.png"
    elseif self._id == 2 then
        img = "eveputfood/food/2/plate.png"
        shadowImg = "eveputfood/food/2/shadow.png"
    elseif self._id == 7 then
        img = "eveputfood/food/7/base.png"
        shadowImg = "eveputfood/food/7/shadow.png"
        anchor = cc.p(0.5, 0.38)
    elseif self._id == 4 then
        img = "eveputfood/food/4/plate.png"
    end
    self:display(img):anchor(anchor)
    local pos = self._id == 7 and cc.p(66.9, 15.9) or cc.p(self:cw() / 2 - 1, self:ch() / 2 - 4)
    local shadow = D.img(shadowImg):to(self, -1):p(pos)
    self._shadow = shadow
end

-- 加载结点
function M:loadPageNode()
    if self._id == 1 then
        --加载饺子
        self:loadDumplings()
    elseif self._id == 2 then
        --加载鱼
        self:loadFish()
    elseif self._id == 3 then
        --加载菜
        self:loadVegetable()
    elseif self._id == 4 then
        --加载烤鸭
        self:loadDuck()
    elseif self._id == 5 then
        --加载狮子头
        self:loadMeatball()
    elseif self._id == 6 then
        --加载虾
        self:loadShrimp()
    elseif self._id == 7 then
        --加载火锅
        self:loadHotPot()
    end
    self._smokeIndex = 0
    --加载烟雾
    self:loadSmoke()
end

--加载烟雾
function M:loadSmoke()
    self._smokeIndex = self._smokeIndex + 1
    if self._smokeIndex > 4 then
        self._smokeIndex = 1
    end
    local index = self._smokeIndex
    local pos = { cc.p(24.2,  47.3), cc.p(53.6,  63.7), cc.p(69.6,  31.6), cc.p(102.9,  52.6), }
    local moveByPos = { cc.p(-20, 60), cc.p(0, 350), cc.p(150, 350) }
    local newPos = pos[index]
    local offset = self._id == 7 and 25 or 0
    local smoke = D.img("eveputfood/food/smoke/"..math.random(1, 2)..".png"):p(newPos.x, newPos.y + offset):to(self, self:z() + 100):scale(0)
    smoke:line({
        { "union", {
            { "moveBy", 1.5, cc.p(math.random(-30, 30), math.random(50, 80)) },
            { "line", {
                { "scaleTo", 1, 1 },
                { "fadeOut", 1 },
                { "sinBy", 1, ccp(0, 20), 20, 2 },
            } },
            { "line", {
                { "delay", 0.5 },
                { "fn", function()
                    if not self._isStopSmoke then
                        self:loadSmoke()
                    end
                end },
            } },
        } },
        { "remove" },
    })
end


--加载饺子
function M:loadDumplings()
    local posTb = { cc.p(49.7, 58.8), cc.p(28.3, 42.1), cc.p(35.4, 25.3), cc.p(55.8, 16.3),}
    for i, v in ipairs(posTb) do
        local dumplings = D.img("eveputfood/food/1/dumpling.png"):to(self):p(v):anchor(cc.p(0.5, 0))
        table.insert(self._foodTb, dumplings)
    end
    local dish = D.img("eveputfood/food/1/dish/"..G_DUMPLINGS_ADD..".png"):to(self):p(91.9, 50.4)
    self._dish = dish 
    local light = D.img("eveputfood/food/1/light.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2):hide():opacity(0)
    self._light = light
end

--加载鱼
function M:loadFish()
    local fish = D.img("eveputfood/food/2/fish.png"):to(self):p(67.3, 40.8)
    table.insert(self._foodTb, fish)
    local light = D.img("eveputfood/food/2/light.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2 - 2):scale(1.7):hide():opacity(0)
    self._light = light
end

--加载菜
function M:loadVegetable()
    local posTb = { cc.p(37.5, 53.3), cc.p(58.6, 47.1), cc.p(64.5, 36.9)}
    for i, v in ipairs(posTb) do
        local vegetable = D.img("eveputfood/food/3/"..i..".png"):to(self):p(v)
        table.insert(self._foodTb, vegetable)
    end 
    local light = D.img("eveputfood/food/3/light.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2 - 2):scale(1.05):hide():opacity(0)
    self._light = light
end

--加载烤鸭
function M:loadDuck()
    local duck = D.img("eveputfood/food/4/1.png"):to(self):p(65.1, 41.1)
    table.insert(self._foodTb, duck)
    local light = D.img("eveputfood/food/4/light.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2 - 2):scale(1.05):hide():opacity(0)
    self._light = light
end

--加载狮子头
function M:loadMeatball()
    local posTb = { cc.p(41, 38.5), cc.p(74.6, 39.6), cc.p(37.8, 14.3), cc.p(73.7, 13.2),}
    for i, v in ipairs(posTb) do
        local meatball = D.img("eveputfood/food/5/1.png"):to(self):p(v):anchor(cc.p(0.5, 0))
        table.insert(self._foodTb, meatball)
    end
    local light = D.img("eveputfood/food/5/light.png"):to(self, -1):p(self:cw() / 2 + 2, self:ch() / 2 - 3):scale(1.45):hide():opacity(0)
    self._light = light
end

--加载虾
function M:loadShrimp()
    local posTb = { cc.p(30.7, 50.9), cc.p(48.7, 49.7), cc.p(66.5, 46.6), cc.p(82.9, 47.1),}
    for i, v in ipairs(posTb) do
        local shrimp = D.img("eveputfood/food/6/1.png"):to(self):p(v)
        table.insert(self._foodTb, shrimp)
    end
    local light = D.img("eveputfood/food/3/light.png"):to(self, -1):p(self:cw() / 2 + 2, self:ch() / 2 - 3):scale(1.05):hide():opacity(0)
    self._light = light
end

--加载火锅
function M:loadHotPot()
    local mask = D.img("eveputfood/food/7/mask.png"):to(self, 100):p(67.8, 61.2)
    local posTb = { cc.p(49.5, 79.1), cc.p(26.8, 87.1), cc.p(34.5, 117.3), cc.p(94.3, 87.2), cc.p(106.3, 105.1), }
    local zorder = {11, 8, 5, 14, 2}

    for i, v in ipairs(posTb) do
        local food = D.img("eveputfood/food/7/"..i..".png"):to(self):p(v):z(zorder[i])
        local time = RD.number(7, 10) * 0.1
        table.insert(self._foodTb, food)
        self:hotFoodBreath(food)
    end
    local posTb = { cc.p(111.3, 85.4), cc.p(29.6, 81.8), cc.p(48, 69.9),  cc.p(86.8, 68.9), cc.p(67.3, 103.9),}
    local zorder = { 15, 9, 15, 15, 6 }
    for i, v in ipairs(posTb) do
        local mask = D.img("eveputfood/food/7/" .. i .. "_1.png"):to(self, zorder[i]):p(v)
    end

    --加载辣椒
    local posTb = { cc.p(110.3, 86.4), cc.p(48, 69.9), cc.p(83.8, 70.9), cc.p(30.3, 81.9),}
    local zorder = { 10, 15, 15, 8 }
    local flipXTb  = { true, true, false, true}
    for i, v in ipairs(posTb) do
        local pepper = D.img("eveputfood/food/7/6.png"):to(self, zorder[i]):p(v):flipX(flipXTb[i])
        self:hotFoodBreath(pepper)
    end

    local light = D.img("eveputfood/food/7/light.png"):to(self, -1):p(self:cw() / 2 + 1, self:ch() / 2 + 7):scale(1):hide():opacity(0)
    self._light = light

    local pos = cc.p(self:cw() / 2 , self:ch() / 2 + 40)
    local particle = P.newParticle("particle/hotpot_reqi.plist"):p(pos):to(self, 110)
    Tools:insertParticleTb(self, particle)
    self._hotParticle = particle
end

--火锅里食物动
function M:hotFoodBreath(food)
    local time = RD.number(7, 10) * 0.1
    food:cycle({
        { "moveBy", time, cc.p(0, 3) },
        { "moveBy", time, cc.p(0, -3) },
    })
    -- 食物缩放动作
    food:cycle({
        { "scaleTo", time, 0.99 * 1 },
        { "scaleTo", time, 1.01 * 1 },
    })
end

--打开引导
function M:openGuide()
    if self._lightGuideAct then return end
    self._lightGuideAct = A.line({
        { "show"},
        { "fadeTo", 0.5, 200 },
        { "fadeTo", 0.5, 0 },
        { "fadeTo", 0.5, 200 },
        { "fadeTo", 0.5, 0 },
        { "hide" },
        { "fn", function ()
            --关闭引导
            self:closeGuide()
        end}
    }):at(self._light)
end

--关闭引导
function M:closeGuide()
    if self._lightGuideAct then
        self._light:hide():opacity(0)
        self._light:stopAction(self._lightGuideAct)
        self._lightGuideAct = nil
    end
end

--打开引导
function M:openGuide2(callBack)
    if self._guideAct then return end
    self._guideAct = A.line({
        { "fn", function ()
            -- 播放音效[sfx05700004]缩放等待
            soundEffect:playEffectsfx05700004()
        end},
        { "scaleto", 0.25, self._scaleSize * 1.1 },
        { "scaleto", 0.25, self._scaleSize * 1 },
        { "scaleto", 0.25, self._scaleSize * 1.1 },
        { "scaleto", 0.25, self._scaleSize * 1 },
        { "fn", function()
            --关闭引导
            self:closeGuide2()
            if callBack then
                callBack()
            end
        end }
    }):at(self)
end

--关闭引导
function M:closeGuide2()
    if self._guideAct then
        self:scale(self._scaleSize)
        self:stopAction(self._guideAct)
        self._guideAct = nil
    end
end

-- 返回
function M:goBack(callBack)
    -- 播放音效[sfx05700008]没放对地方弹回
    soundEffect:playEffectsfx05700008()
    self:line({
        {"union",{
            {"jumpto", 0.5, self._pos, 100, 1},
            {"scaleTo",0.5, self._scaleSize}
        }},
        {"hide"},
        {"fn", function ()
            if callBack then
                callBack()
            end
        end},
        -- {"remove"}
    })
end

--下落动作
function M:downAct(type)
    local angle = 0
    local sizeX, sizeY = self:scaleX(), self:scaleY()
    type = ifnil(type, 1)
    local strength = 0.5
    local act = type == 1 and 
    A.line({
        { "scaleTo", 0.1, sizeX + 0.15 * strength, sizeY - 0.1 * strength },
        { "scaleTo", 0.1, sizeX },
        { "scaleTo", 0.1, sizeX + 0.1 * strength, sizeY - 0.05 * strength },
        { "scaleTo", 0.1, sizeX },
    })
    or 
    A.line({
        { "scaleTo", 0.15, sizeX * 1.1, sizeY * 0.85 },
        { "scaleTo", 0.15, sizeX },
        { "scaleTo", 0.1, sizeX + 0.15 * strength, sizeY - 0.1 * strength },
        { "scaleTo", 0.1, sizeX },
        { "scaleTo", 0.1, sizeX + 0.1 * strength, sizeY - 0.05 * strength },
        { "scaleTo", 0.1, sizeX },
    })
    self:line({
        { "fn", function()
            -- 食物晃动
            self:foodShake()
        end },
        act,
    })
end

-- 食物晃动
function M:foodShake()
    local time = 0
    local tab = { 0.15, 0.12, 0.07, 0.2, 0.22, 0.1, 0.05, 0.08,}
    for k, v in pairs(self._foodTb) do
        local size = v:scale()
        v:line({
            { "delay", (k - 1) / 30 },
            { "union", {
                { "jumpBy", 0.15, cc.p(0, 0), 6, 1 },
                { "rotateBy", 0.15, 4 },
            } },
            { "union", {
                { "jumpBy", 0.15, cc.p(0, 0), 5, 1 },
                { "rotateBy", 0.15, -4 },
            } },
            { "union", {
                { "jumpBy", 0.1, cc.p(0, 0), 3, 1 },
                { "rotateBy", 0.1, 2 },
            } },
            { "union", {
                { "jumpBy", 0.1, cc.p(0, 0), 2, 1 },
                { "rotateBy", 0.1, -2 },
            } },
        })
    end
end

--与椅子碰撞检测
function M:collisionDetection()
    local putFrames = {}
    local minNums = {}
    local min = 130
    local minFrame = nil
    local pos = self:worldpoint()
    local type = self._id ~= 7 and 1 or 2
    --获取桌上虚线框的表
    local boxTb = self._layer:getBoxTb(type)
    for k, v in pairs(boxTb) do
        if not v._haveFood then
            --转换成世界坐标
            local point = v:worldpoint()
            local distance = PT.distance(pos, point)
            if distance < min then
                table.insert(putFrames, v)
                table.insert(minNums, distance)
            end
        end
    end
    if #putFrames ~= 0 then
        --判断与哪个虚线框最近
        for k, v in ipairs(minNums) do
            if v < min then
                min = v
                minFrame = putFrames[k]
            end
        end
        --放置上去
        self:putFood1(minFrame)
        return true
    end
    return false
end

--放置菜品
function M:putFood1(box)
    box._haveFood = true
    local diningTable = self._layer._diningTable
    local pos = box:worldpoint()
    local size = diningTable:getParent():scale() * diningTable._foodScaleSize

    --加载食物的阴影
    diningTable:loadFoodShadow(box, self._id)

    local effectName = {"sfx05706014", "sfx05706015","sfx05706014","sfx05706015","sfx05706016","sfx05706016","sfx05706017",}
    soundEffect["playEffect" .. effectName[self._id]](soundEffect)

    self:line({
        {"union", {
            {"jumpto", 0.5, pos, 80, 1},
            {"scaleTo", 0.5, size}
        }},
        {"hide",},
        {"fn", function ()
            if self._id ~= 7 then
                --报菜名
                self._layer:sayFoodName(self._id) 
            end
            self._flag = true
            local name = self._id ~= 7 and "shangcai" or "shangcai_hot"
            local newPos = self:worldpoint()
            local offset   = self._id ~= 7 and 0 or 30
            local particle = Tools:newParticle("particle/"..name..".plist", newPos.x, newPos.y + offset):to(self._layer, 500)
            Tools:insertParticleTb(self._layer, particle)
            -- 震动反馈
            diningTable:shakeAct()
            --加载食物
            diningTable:loadFood(box, self._id)
        end},
        {"remove",}
    })
end


--返回食物
function M:getFood()
    local food = nil
    local callBack = nil
    local foodPos = cc.p(self:cw()/2, self:ch() / 2)
    local foodZ = 2
    if self._id == 2 then       --鱼
        --获取鱼的肉
        food, foodPos, foodZ= self:getFishFood()
    elseif self._id == 4 then   -- 烤鸭
        --获取烤鸭的肉
        food, foodPos, foodZ = self:getDuckFood()
    else
        --获取其他食物的肉
        food, foodPos, foodZ = self:getOtherFood()
    end

    if food == nil then
        --移除食物
        self._layer._diningTable:removeFoodForTb(self)
    else
        food._pos = foodPos
        food._foodZ = foodZ
    end
    return food, callBack
end

--获取鱼的肉
function M:getFishFood()
    local food = nil
    local foodPos,foodZ
    if self._count < 3 then
        self._count = self._count + 1
        food = D.img("eveputfood/food/2/fish2.png"):to(self):p(100 - ((self._count - 1) * 20), 45.8):hide()
        self._foodTb[1]:display("eveputfood/food/2/" .. self._count .. ".png")
        food:show()
        foodPos = food:worldpoint()
        foodZ = food:z()
    end
    if self._count == 3 then
        self._isStopSmoke = true
    end
    return food, foodPos, foodZ
end

--获取烤鸭的肉
function M:getDuckFood()
    local food = nil
    local foodPos, foodZ = nil, nil
    if self._count < 4 then
        self._count = self._count + 1
        if self._count == 4 then
            food = self._foodTb[1]
            foodPos = food:worldpoint()
            foodZ = food:z()
        else
            local posTb = { cc.p(40, 45.8), cc.p(40, 50.8), cc.p(60, 45.8),}
            food = D.img("eveputfood/food/4/" .. self._count + 1 .. "_1.png"):to(self):p(posTb[self._count]):hide()
            self._foodTb[1]:display("eveputfood/food/4/" .. self._count + 1 .. ".png")
            food:show()
            Tools:changeAnchorP(food, cc.p(0.35, 0.7))
            foodPos = food:worldpoint()
            foodZ = food:z()
        end
    end
    if self._count == 4 then
        self._isStopSmoke = true
    end
    return food, foodPos, foodZ
end

--获取其他食物的肉
function M:getOtherFood()
    local food = nil
    local foodPos, foodZ = nil, nil
    if #self._foodTb ~= 0 then
        food = self._foodTb[#self._foodTb]
        Tools:changeAnchorP(food, cc.p(0.5, 0.45))
        foodPos = food:worldpoint()
        foodZ = food:z()
    end
    if #self._foodTb == 1 then
        self._isStopSmoke = true
    end
    return food, foodPos, foodZ
end

--夹完了, 其他菜缩放
function M:overAct()
    -- local angle = 4
    -- self:line({
    --     { "rotateby", 0.05, angle },
    --     { "rotateby", 0.05, -angle },
    --     { "rotateby", 0.05, -angle },
    --     { "rotateby", 0.05, angle },
    --     { "rotateby", 0.05, angle },
    --     { "rotateby", 0.05, -angle },
    --     { "rotateby", 0.05, -angle },
    --     { "rotateby", 0.05, angle },
    --     { "fn", function ()
    --         self._canTouch = true
    --     end}
    -- })

    if self._layer and self._layer._diningTable and self._layer._diningTable._canChooseFoodTb then
        local foodTb = self._layer._diningTable._canChooseFoodTb
        if (not tolua.isnull(foodTb[1])) then
            foodTb[1]:openGuide2(function ()
                self._canTouch = true
            end)
        end
    end
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._canTouch = false
            self._layer._diningTable:closeGuide()
            --关闭喂食等待动作
            self._layer:closeWaitFoodAct()

            --创建移动食物
            return self:creatMoveFood()
        end
    end
end

function M:onTouchMoved(x, y, touches)
    if self._moveFood then
        self._moveFood:p(x - 20, y + 20)
        bb.si.Tool.limitRectMove({
            node = self._moveFood,
            -- marginTop = adh,
        -- boundingRect = cc.rect(20, 0, self:size().width - 40, self:size().height)
        })
        bb.si.Tool.limitButtonMove({node = self._moveFood})
    end
end

function M:onTouchEnded(x, y, touches)
    --正在点击
    self._layer._isTouch = false
    if self._openEffect then
        sound.stopSound(self._openEffect)
        self._openEffect = nil
    end
    if self._effectAct then
        self:stopAction(self._effectAct)
        self._effectAct = nil
    end
    --与人物碰撞检测
    self:collisionDetection2()
end

--创建移动食物
function M:creatMoveFood()
    if not self._moveFood then
        local food, callBack = self:getFood()
        if not food then
            --夹完了
            self:overAct()
            self._layer._diningTable:openGuide()
            return false
        end
        Tools:resetParent(food, self._layer, 9999)
        self._moveFood = food 
    end
    --正在点击
    self._layer._isTouch = true
    if not self._effectAct then
        self._effectAct = A.line({
            { "delay", 0.2 },
            { "fn", function()
                if not self._openEffec then
                    -- 播放音效[sfx05706030]四人张嘴
                    self._openEffect = soundEffect:playEffectsfx05706030()
                end
            end }
        }):at(self)
    end
    for i, v in ipairs(self._layer:getAniTb()) do
        if not v._eatNow then
            --张开嘴
            v:openMouseAni()
        end
    end
    return true
end

--移动食物返回
function M:moveFoodGoBack()
    local function scaleAct()
        local action = A.line({
            { "scaleto", 0.1, self._scaleSize * 1.1, self._scaleSize * 0.95 },
            { "scaleto", 0.1, self._scaleSize * 0.98, self._scaleSize * 1.05 },
            { "scaleto", 0.1, self._scaleSize * 1.05, self._scaleSize * 0.95 },
            { "scaleto", 0.1, self._scaleSize, self._scaleSize },
        })
        if self._id==2 or self._id == 4 or self._id == 7 then
            action = A.line({
                {"fn", function ()
                    
                end}
            })
        end
        return action
    end
    if self._moveFood then
        self._moveFood:line({
            { "union", {
                { "jumpto", 0.5, self._moveFood._pos, 100, 1 },
                { "scaleTo", 0.5, self._scaleSize }
            } },
            scaleAct(),
            {"fn", function ()
                --移动食物返回结束
                self:moveFoodGoBackOver()
            end}
        })
    end
end

--移动食物返回结束
function M:moveFoodGoBackOver()
    Tools:resetParent(self._moveFood, self, self._moveFood._foodZ)
    if self._id == 2 then       --鱼
        --鱼移动食物返回结束
        self:moveFoodFishGoBackOver()
    elseif self._id == 4 then --烤鸭
        --烤鸭移动食物返回结束
        self:moveFoodDuckGoBackOver()
    elseif self._id == 7 then
        --火锅里食物动
        self:hotFoodBreath(self._moveFood)
    end
    self._moveFood = nil
    self._canTouch = true
    self._layer._diningTable:openGuide()
end

--鱼移动食物返回结束
function M:moveFoodFishGoBackOver()
    self._moveFood:hide()
    self._count = self._count - 1
    if self._count == 0 then
        self._foodTb[1]:display("eveputfood/food/2/fish.png")
    else
        self._foodTb[1]:display("eveputfood/food/2/" .. self._count .. ".png")
    end
    --烤鸭弹动
    local size = self._foodTb[1]:scale()
    self._foodTb[1]:line({
        { "scaleto", 0.1, size * 1.1, size * 0.95 },
        { "scaleto", 0.1, size * 0.98, size * 1.05 },
        { "scaleto", 0.1, size * 1.05, size * 0.95 },
        { "scaleto", 0.1, size, size },
    })
end

--烤鸭移动食物返回结束
function M:moveFoodDuckGoBackOver()
    if self._count ~= 4 then
        self._moveFood:hide()
    end
    self._count = self._count - 1
    if self._count == 0 then
        self._foodTb[1]:display("eveputfood/food/4/1.png")
    else
        self._foodTb[1]:display("eveputfood/food/4/" .. self._count + 1 .. ".png")
    end
    --烤鸭弹动
    local size = self._foodTb[1]:scale()
    self._foodTb[1]:line({
        { "scaleto", 0.1, size * 1.1, size * 0.95 },
        { "scaleto", 0.1, size * 0.98, size * 1.05 },
        { "scaleto", 0.1, size * 1.05, size * 0.95 },
        { "scaleto", 0.1, size, size },
    })
end

--与食物碰撞检测
function M:collisionDetection2()
    local putFrames = {}
    local minNums = {}
    local min = 90
    local minFrame = nil
    local pos = self._moveFood:worldpoint()
    --获取动物表
    local boxTb = self._layer:getAniTb()
    for k, v in pairs(boxTb) do
        if not v._haveFood then
            --转换成世界坐标
            local point = v:getMousePos()--获取嘴的坐标
            local distance = PT.distance(pos, point)
            if distance < min then
                table.insert(putFrames, v)
                table.insert(minNums, distance)
            end
        end
    end
    if #putFrames ~= 0 then
        --判断与哪个虚线框最近
        for k, v in ipairs(minNums) do
            if v < min then
                min = v
                minFrame = putFrames[k]
            end
        end
        --检测完毕
        self:checkOver(true, minFrame)
    else
        --与桌上碗碰撞检测
        self:collisionDetectionByBowl()
    end
end

--与桌上碗碰撞检测
function M:collisionDetectionByBowl()
    local putFrames = {}
    local minNums = {}
    local min = 50
    local minFrame = nil
    local pos = self._moveFood:worldpoint()
    --碗的表
    local bowlTb = self._layer._diningTable._bowlTb
    --获取按顺序的落座表
    local aniTb = self._layer:getOrderAniTb()
    for k, v in pairs(bowlTb) do
        --转换成世界坐标
        local point = v:worldpoint()
        local distance = PT.distance(pos, point)
        if distance < min then
            table.insert(putFrames, aniTb[k])
            table.insert(minNums, distance)
        end
    end
    if #putFrames ~= 0 then
        --判断与哪个虚线框最近
        for k, v in ipairs(minNums) do
            if v < min then
                min = v
                minFrame = putFrames[k]
            end
        end
        --检测完毕
        self:checkOver(true, minFrame)
    else
        --检测完毕
        self:checkOver(false)
    end
end

--检测完毕
function M:checkOver(isRight, minFrame)
    isRight = ifnil(isRight, false)
    if isRight then
        for i, v in ipairs(self._layer:getAniTb()) do
            if v ~= minFrame and not v._eatNow then
                -- 正常呼吸
                v:breathFoodAni3()
            end
        end
        --放置上去
        self:putFood(minFrame)
    else
        self:moveFoodGoBack()
        for i, v in ipairs(self._layer:getAniTb()) do
            if not v._eatNow then
                -- 正常呼吸
                v:breathFoodAni3()
            end
        end
        --喂食等待动作
        self._layer:openWaitFoodAct()
    end
end

--移除食物
function M:removeFood()
    if self._id ~= 2 and self._id ~= 4 then
        if #self._foodTb ~= 0 then
            table.remove(self._foodTb, #self._foodTb)
            if #self._foodTb == 0 then
                --移除食物
                self._layer._diningTable:removeFoodForTb(self)
            end
        end
    elseif self._id == 2 then
        if self._count == 3 then
            self._foodTb[1]:unbindTouch()
            --移除食物
            self._layer._diningTable:removeFoodForTb(self)
        end
    elseif self._id == 4 then
        if self._count == 4 then
            --移除食物
            self._layer._diningTable:removeFoodForTb(self)
        end
    end
end

--放置上去
function M:putFood(ani)
    ani._eatNow = true
    if ani._isHot then
        ani._isHot = false
    end
    if self._id == 7 then
        ani._isHot = true
    end
    -- 播放音效[sfx05706031]食物入嘴
    soundEffect:playEffectsfx05706031()
    --移除食物
    self:removeFood()
    local pos = ani:getMousePos()
    self:line({
        { "Delay", 0.1 },
        { "fn", function()
            --咬住
            ani:biteFoodAni()
        end }
    })
    self._moveFood:line({
        { "union", {
            { "scaleto", 0.3, 0.2 },
            { "jumpto", 0.3, pos, 50, 1 }
        } },
        { "fn", function()
            --喂食总数加1
            self._layer:eatCountAdd()
            self._layer._diningTable:openGuide()
        end },
        { "hide",},
        { "remove",}
    })
    self._moveFood = nil
    self._canTouch = true
end

--食物绑定触控
function M:foodBindTouch(food)
    function food:onTouchBegan(x, y, touches)

    end

    function food:onTouchMoved(x, y, touches)
           
    end

    function food:onTouchEnded(x, y, touches)
    end
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    if self._hotParticle  and not tolua.isnull(self._hotParticle) then
        self._hotParticle:remove()
        self._hotParticle = nil
    end
    Tools:removeParticleTb(self)
end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
