--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch = true
    --1:歌谣界面 2:图鉴页面
    self._sceneType = self:getScene()._sceneType
    --图标表
    self._itemTb  = {}
    --1：图鉴选择页面  2：图鉴详情页面
    self._nowType = 1
    --当前图鉴
    self._nowItem = nil
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载背景
    self:loadBg()
    -- 加载结点
    self:loadPageNode()
    -- 加载渲染以外的其他操作
    self:loadRenderOtherwise()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    if self._sceneType == 1 then
        --开始歌谣
        self:startOpenAni()
    end
end

--加载背景
function M:loadBg()
    if self._sceneType == 1 then
        local bg = U.loadBg("handbook/bg.png"):to(self)
    else
        self:loadHandBookBg()
    end
end

--加载图鉴背景
function M:loadHandBookBg()
    local bg = U.loadBg("handbook/handbookBg/bg.png"):to(self)
    local cloud1 = D.img("handbook/handbookBg/2.png"):to(self, 8):p(V.w_2, -5):anchor(ccp(0.5, 0)):scaleX(X_FACTOR)
    local cloud2 = D.img("handbook/handbookBg/3.png"):to(self, 5):p(V.w_2, 15):anchor(ccp(0.5, 0)):scaleX(X_FACTOR)
    local cloud3 = D.img("handbook/handbookBg/4.png"):to(self, 2):p(V.w_2, 100):anchor(ccp(0.5, 0)):scaleX(X_FACTOR)
    local function scaleAct(node, time, sizeX, sizeY)
        node:cycle({
            { "scaleto", time, sizeX, sizeY },
            { "scaleto", time, sizeX, 1 }
        })
    end
    scaleAct(cloud1, 1, X_FACTOR, 1.03)
    scaleAct(cloud2, 1.2, X_FACTOR, 1.03)
    scaleAct(cloud3, 1.3, X_FACTOR, 1.03)
    --加载金币及红包
    self:loadMonetary()
    --加载树
    self:loadTree()
end

--加载金币及红包
function M:loadMonetary()
    --金币及其他
    local config = {
        { pos = cc.p(145.2, 149.2), z = 3 }, { pos = cc.p(518  , 137.6), z = 3 }, { pos = cc.p(757.2, 128.3), z = 3 },
        { pos = cc.p(396  , 84.2 ), z = 6 }, { pos = cc.p(179.1, 43   ), z = 6 }, { pos = cc.p(852.9, 40.6), z = 6 },
        { pos = cc.p(46.5 , -0.4 ), z = 9 }, { pos = cc.p(354  , 12.1 ), z = 9 }, { pos = cc.p(548.9, 10.6), z = 9 },{ pos = cc.p(746.7, 1.9 ), z = 9 },
    }
    local function moveAct2(node)
        local dis = math.random(6, 8)
        local time = math.random(15, 20) / 10
        node:line({
            { "moveBy", time, cc.p(0, dis) },
            { "moveBy", time, cc.p(0, -dis) },
            { "fn", function()
                return moveAct2(node)
            end }
        })
    end
    for i, v in ipairs(config) do
        local tree = D.img("handbook/handbookBg/down/"..math.random(1, 6)..".png"):to(self, v.z):p(v.pos)
        moveAct2(tree)
    end
end

--加载树
function M:loadTree()
    local tree1 = D.img("handbook/handbookBg/tree/7.png"):to(self):p(-120.7 + X_OFFSET, 548.3):anchor(ccp(0.01, 0.1))
    local tree2 = D.img("handbook/handbookBg/tree/5.png"):to(self):p(1079 + X_OFFSET* 2, 368):anchor(ccp(1, 0.11))
    local tree3 = D.img("handbook/handbookBg/tree/6.png"):to(self):p(1003 + X_OFFSET* 2, 488.6):anchor(ccp(0.98, 0.07))
    commonAct:breathing(tree1)
    commonAct:breathing(tree2)
    commonAct:breathing(tree3)
    local config = {
        { id = 1, pos = cc.p(912.1 + X_OFFSET * 2, 486.9) },{ id = 2, pos = cc.p(1.6 + X_OFFSET, 485.1) },{ id = 4, pos = cc.p(190 + X_OFFSET, 509.2) },
        { id = 3, pos = cc.p(776.5 + X_OFFSET * 2, 431.4) },{ id = 3, pos = cc.p(127.9 + X_OFFSET, 561) },{ id = 4, pos = cc.p(87.2 + X_OFFSET, 401.3) },
    }
    for i, v in ipairs(config) do
        local tree = D.img("handbook/handbookBg/tree/"..v.id..".png"):to(self):p(v.pos)
        self:upDownAct(tree)
    end
end

--运动
function M:upDownAct(node)
    local time = math.random(150, 200) / 100
    node:line({
        { "moveBY", time, cc.p(10, 0) },
        { "moveBY", time, cc.p(-10, 0) },
        { "fn", function ()
            return self:upDownAct(node)
        end}
    })
end

-- 加载结点
function M:loadPageNode()
    if self._sceneType == 1 then
        --加载歌谣书本
        self:loadOpenAni()
    else
        --加载一级页面
        self:loadFirstHandbook()
    end
end

--加载歌谣书本
function M:loadOpenAni()
    local enterPos = cc.p(V.w_2 + 20, V.h_2 - 40)
    -- 加载书本节点
    local bookNode = self:createNode("Book", {
        layer    = self,
        autoFlip = true,
        bookType = 1, 
    }):to(self):p(V.w_2 - 150, V.h_2 - 40)--
    self._bookNode = bookNode
end

--开始歌谣
function M:startOpenAni()
    local enterPos = cc.p(V.w_2 + 20, V.h_2 - 40)
    self._bookNode:line({
        { "delay", 0.5},
        { "moveto", 0.6, enterPos}
    })
    --开场动画打开书本
    self._bookNode:openAniOpenBook()
end

--整体放大
function M:zoomIn()
    self:line({
        { "union", {
            { "scaleto", 0.5, 1.2 },
            { "moveby", 0.5, cc.p(0, 50) }
        } }
    })
end

--整体恢复
function M:zoomOut()
    self:line({
        { "union", {
            { "scaleto", 0.8, 1 },
            { "moveto", 0.8, cc.p(0, 0) }
        } },
        {"delay", 0.4},
        {"fn", function ()
            game:enterScene("openani", {}, "fade", 0.5, COLOR3_WHITE)
        end}
    })
    local enterPos = cc.p(V.w_2 - 150, V.h_2 - 40)
    self._bookNode:line({
        { "moveto", 0.8, enterPos }
    })
end

--加载一级页面
function M:loadFirstHandbook()
    for i = 1, 2 do
        local item = import("app.handbook.node.Item").new({
            layer  = self,
            id     = i
        }):to(self, 50)
        table.insert(self._itemTb, item)
    end
end

--改变状态
function M:changeType(item)
    self._nowType = 2
    --关闭返回按钮触控
    -- self:closeBackBtnTouch()
    --当前图鉴
    self._nowItem = item
end

--返回图鉴选择
function M:backItem()
    self._nowItem:bookHide()
    self._nowType = 1
end

--关闭返回按钮触控
function M:closeBackBtnTouch()
    local nowScene = self:getScene()
    local buttonLayer = nowScene:getButtonLayer()
    buttonLayer:closeTouch()
end

--开启返回按钮触控
function M:openBackBtnTouch()
    local nowScene = self:getScene()
    local buttonLayer = nowScene:getButtonLayer()
    buttonLayer:openTouch()
end

--播放歌谣音乐
function M:playBookType1Music()
    if self._isPlayMusic then
        return
    end
    self._isPlayMusic = true
    -- 播放音效[057BGM02]开场动画、图鉴-春节歌谣
    sound:play057BGM02()
end

--停止播放歌谣音乐
function M:closeBookType1Music()
    if self._isPlayMusic then
        self._isPlayMusic = false
        -- 播放音效[057BGM03]选择界面
        sound:play057BGM03()
    end
end

-- 加载其他
function M:loadRenderOtherwise()

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    return true
end

function M:onTouchMoved(x, y, touches)
  
end

function M:onTouchEnded(x, y, touches)
    --  
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)

end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    --停止播放歌谣音乐
    self:closeBookType1Music()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
