
--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSpriteTouch("Book")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
	self._layer       = params.layer
	--触控锁
	self._canTouch    = false
 	-- 是否在翻页
	self._isFlipPage  = false
	-- 翻页方向
	self._flipDir     = ""
	-- 是否拖动
	self._isDrag      = false
	-- 存储的照片数据
	self._storePhoto  = {}
	--翻页数目
	self._flipCount   = 1
	--图本是否需要自动翻页
	self._autoFlip    = ifnil(params.autoFlip, true)
	--书本类型 1:春节歌谣 2:春节小知识
	self._bookType    = ifnil(params.bookType, 1)
	--翻页音效触发总数
	self._effectCount = 0
	--当前书本打开或者关闭
	self._isOpen      = false
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

	 -- [本类调用]
	 --初始化
	self:initDate()
	-- 加载书本背景
	self:loadBookBg() 
	
end 

--初始化
function M:initDate()
	local imgTb = {"handbook/book/page/1.png", "handbook/book2/page/1.png"}
	local a = D.img(imgTb[self._bookType])
	local size = a:getContentSize()
	size = cc.size(size.width, size.height)
	self._size = size
end

-- 加载书本背景
function M:loadBookBg()
	--加载打开书的动画
	self:loadBookClose()
	-- self:loadBookOpen()
end 

--加载打开书的动画
function M:loadBookClose()
	local width = self._size.width * 2
	local height = self._size.height
	local pos = cc.p(0, 0)
	local closeBook = import("app.handbook.node.BookClose").new({
		layer = self._layer,
		bookType = self._bookType
	}):to(self):anchor(cc.p(0, 0)):p(pos):unbindTouch()
	self._closeBook = closeBook
end

--开场动画打开书本
function M:openAniOpenBook()
	self:line({
		{ "Delay", 0.5 },
		{ "fn", function()
			--打开书本
			self._closeBook:openBook(function()
				--整体放大
				self._layer:zoomIn()
				self._flipCount = 1
				self:loadBookOpen()
				self._openBook:show()
				--开始自动翻页
				self:startAutoMove()
			end, true)
		end }
	})
end

--图鉴打开书本
function M:handbookOpenBook(callBack)
	--打开书本
	self._closeBook:openBook(function()
		self._flipCount = 1
		self:loadBookOpen()
		self._openBook:show()
		local time = soundVoice:soundDuration("v057176", 1.5)
		time = (time - 0.5) < 0 and 0 or (time - 0.5)
		self:line({
			{"Delay", time},
			{"fn", function ()
				if self._isOpen then
					--播放进入语音
					self._openBook:playEnterVoice()
				end
			end}
		})
		--开始动
		self:startPaperAct()
		self._canTouch        = true
		self._layer._canTouch = true
		self._isOpen          = true
		if callBack then
			callBack()
		end
	end)
end

--关闭书本
function M:closeBook()
	self._isOpen        = false
	--停止播放语音
	self._openBook:stopEnterVoice()
	self._openBook:hide()
	-- 拍下书页
	local path, id = self._openBook:takePhoto()
	self._openBook:show()

	self:line({
		{"Delay",0.1},
		{"fn", function ()
			self._closeBook:resetPage(path, id)
			self._openBook:hide()
		end},
		{"Delay",0.1},
		{"fn", function ()
			-- 播放音效[sfx05701012]书本合上
			soundEffect:playEffectsfx05701012()
			--关闭书本
			self._closeBook:closeBook(function()
				Tools:openAd(true)
				if self._bookType == 1 then
					--停止播放歌谣音乐
					self._layer:closeBookType1Music()
				end
				--开启返回按钮触控
				self._layer:openBackBtnTouch()
			end)
		end}
	})
end

--加载展开书页
function M:loadBookOpen()
	if self._openBook then
		self._openBook:remove()
		self._openBook = nil
	end
	if self._flipPage then
		self._flipPage:remove()
		self._flipPage = nil
	end
 	local pageIndex_L = 1
	local pageIndex_R = 2
	 
	local width  = self._size.width * 2
	local height = self._size.height
	local x =  -(self._size.width + 21)
	local y =  -(self._size.height / 2 - 2)
	local FlipPage = import("app.handbook.node.flippage.FlipPage")
	local Book    = import("app.handbook.node.BookOpen")
 	-- 主体书本
	self._openBook       = Book.new({
								storePhoto 	= self._storePhoto,
								pageIndex_L = pageIndex_L, 
								pageIndex_R = pageIndex_R, 
								width 		= width, 
								height 		= height,
								bookType 	= self._bookType
							}):to(self):anchor(cc.p(0, 0)):p(x, y):hide()
	self._openBook:initShow(pageIndex_L, pageIndex_R)

	-- 翻页逻辑
	self._flipPage   = FlipPage.new({
								pageWidth 	= width, 
								pageHeight 	= height, 
								book 		= self._openBook}
								):to(self, 20):anchor(cc.p(0, 0)):p(x, y)
end

--开始自动翻页
function M:startAutoMove()
	self._flipCount = self._flipCount + 1
	--顺序播放剪纸
	local time1 = 2
	local time2 = 2
	local time3 = 2
	self:line({
		{"fn", function ()
			--剪纸动起来
			self._openBook.bookLeft._paper:paperOpenAct()		
		end},
		{ "delay", time1 },
		{ "fn", function()
			--剪纸动起来
			self._openBook.bookLeft._paper:paperPauseAct()
			--剪纸动起来
			self._openBook.bookRight._paper:paperOpenAct()    
		end },
		{ "delay", time2 },
		{ "fn", function()
			--剪纸动起来
			self._openBook.bookRight._paper:paperPauseAct()
			if self._flipCount <= 5 then
				-- 自动翻页
				self:startAutoFlip("right")
			else
				--关闭书本
				self:closeBook()
				--整体恢复
				self._layer:zoomOut()
			end
		end },
	})
end



--------------------------
-- 析构
--------------------------
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouch then return end
	if not self._canTouch then return end
	if self._isFlipPage then return false end

	self._flipDir = self._openBook:isTouchHotRect(x, y)
	if self._flipDir then
		self.x = x
		self.y = y
		if self:isTrigger(self._flipDir) then
			-- 点击热区，加载下个页面
			self._flipPage:addNewPage(self._flipDir)
			self.beganPos = ccp(x, y)
		end	
	end
	return SIGN_TOUCH_BEGAN_SWALLOWS 
end

function M:onTouchMoved(x, y, touches)
	-- 判断是否拖动页面
	if self._flipDir == "left" and not self._isDrag and self:isTrigger(self._flipDir) and x - self.x > 2 then
		self._isDrag = true
	elseif self._flipDir == "right" and not self._isDrag and self:isTrigger(self._flipDir) and x - self.x < -2 then
		self._isDrag = true
	end
	if self._flipDir and not self._isDrag then
		self.x = x
		self.y = y
	end

	-- 拖动页面
	if self._flipDir and self._isDrag then
		self:dragFlip(x, y, self._flipDir)
	end
end

function M:onTouchEnded(x, y, touches)
	if self.dragEffect then
		sound.stopSound(self.dragEffect)
		self.dragEffect = nil
	end
	-- 点击翻页
	if self._flipDir and not self._isDrag then
		-- 二选一
		-- 允许点击自动翻页
		-- self:startAutoFlip(self._flipDir)
		-- 不允许点击自动翻页
		self._flipPage:notpageMoveComplete()
	-- 拖动翻页
	elseif self._flipDir and self._isDrag then
		self:startHandFlip(self._flipDir)
	end
	self._isDrag = false
end

--------------------------
-- 功能函数
--------------------------
-- 拖动翻页
function M:dragFlip(x, y, dir)
	self._isFlipPage = true
	self._flipPage:dragFlip(x, y, dir)
end

--翻页音效
function M:flipEffect()
	self._effectCount = self._effectCount + 1
	if self._effectCount % 2 == 0 then
		-- 播放音效[sfx05701009]书本翻页1
		soundEffect:playEffectsfx05701009()
	else
		-- 播放音效[sfx05701010]书本翻页2
		soundEffect:playEffectsfx05701010()
	end
end

-- 点击自动翻页
function M:startAutoFlip(dir)
	--翻页音效
	self:flipEffect()
	-- 判断是否翻到头
	if self:isTrigger(dir) then
		if dir == "right" then
			self._flipPage:next()
			print("自动翻页开始，下一页")
		elseif dir == "left" then
			self._flipPage:prev()
			print("自动翻页开始，上一页")
		end
		self._isFlipPage = true
	else
		self._isFlipPage = false
		return false
	end	
	return true
end

--是否可以翻页到前夜
function M:canFlipNext()
	return self._openBook:canFlipNext()
end

--是否可以翻页到后夜
function M:canFlipPrev()
   return self._openBook:canFlipPrev()
end

-- 是否触发翻页，
function M:isTrigger(dir)
	if dir == "right" and self:canFlipNext() then
		return true
	elseif dir == "left" and self:canFlipPrev() then
		return true
	else
		return false
	end
end

-- 手动翻页
function M:startHandFlip(flipDir)
	--翻页音效
	self:flipEffect()
	self._flipPage:adjustFlip(flipDir)
end

function M:overFlip(success)
	print("翻页完毕")
	self._isFlipPage = false
	-- self._layer:removeSwallowNode()
	if not self._isOpen then return end
	self._layer._canTouch = true
	if self._autoFlip then
		--开始自动翻页
		self:startAutoMove()
	end
	if success then
		--播放进入语音
		self._openBook:playEnterVoice()
	end
	--开始动
	self:startPaperAct()
end

--开始动
function M:startPaperAct()
	if self._bookType == 1 then
		--剪纸动起来
		self._openBook.bookLeft._paper:paperOpenAct()
		--剪纸动起来
		self._openBook.bookRight._paper:paperOpenAct()
	end
end

--停止动
function M:stopPaperAct()
	if self._bookType == 1 then
		--剪纸动起来
		self._openBook.bookLeft._paper:paperPauseAct()
		self._openBook.bookRight._paper:paperPauseAct()
	end
end

-- 语音播放(以翻页左边为主)
function M:playVoice(index)
	index = index or 1
	-- 当前页数显示的动物id
	local id = (index + 1) / 2
	self:stopVoice()
end

-- 停止语音播放
function M:stopVoice()
	if self.voiceHandler then
		sound.stopSound(self.voiceHandler)
		self.voiceHandler = nil
	end
end
--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






