--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
-- 书上的内容
-- 左右纸的位置

--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSpriteTouch("Book")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	-- 当前页数
 	self.pageIndex_L = params.pageIndex_L or 1  
	self.pageIndex_R = params.pageIndex_R or 2  
	

 	-- 摊开的书本宽度
 	self.pageWidth   = params.width or 680
 	-- 书本的高度
 	self.pageHeight  = params.height or 410

 	self.storePhoto  = params.storePhoto or {}

	 -- 左边点击热区
	self.hotLeftRect    = cc.rect(0, 0, self.pageWidth / 4, self.pageHeight)
	-- 右边点击热区
	self.hotRightRect = cc.rect(self.pageWidth / 4 * 3, 0, self.pageWidth / 4, self.pageHeight)
	--书本类型 1:春节歌谣 2:春节小知识
	self._bookType = ifnil(params.bookType, 2)
end

function M:onRender()
	self._bookNum = self._bookType == 1 and 10 or 18
end

-- 初始页面
function M:initShow(index_l, index_r)
	index_l = index_l or 1
	index_r = index_r or 2
	self.bookLeft  = self:loadOnePage(index_l)
	self.bookRight = self:loadOnePage(index_r)
end


-- 加载一页
function M:loadOnePage(index, parent, anchorP, pos)
	index  		= index or 1
	parent 		= parent or self
	
	-- 方向
	local page  = nil
	if index % 2 == 1 then
		page 	= self:loadLeftPage(index, parent, anchorP, pos)
	else
		page 	= self:loadRightPage(index, parent, anchorP, pos)
	end
	return page
end

-- 加载左边一页
function M:loadLeftPage(index, parent, anchorP, pos)
	anchorP = ifnil(anchorP, cc.p(0, 0))
	pos = ifnil(pos, cc.p(0, 0))
	local bg  	= D.img("handbook/book/page/1.png"):to(parent):anchor(anchorP):p(pos)
	-- 当前页数显示的动物id
	local id = index % self._bookNum--index
	if id == 0 then
		id = self._bookNum
	end
	--加载窗花
	local paper = self:loadPaper(bg, id)
	bg._paper = paper
	return bg
end

-- 加载右边一页
function M:loadRightPage(index, parent, anchorP, pos)
	anchorP = ifnil(anchorP, cc.p(0, 0))
	pos = ifnil(pos, cc.p(self.pageWidth / 2, 0))
	local bg  	= D.img("handbook/book/page/2.png"):to(parent):anchor(anchorP):p(pos)
	-- 当前页数显示的动物id
	local id = index % self._bookNum--index--
	if id == 0 then
		id = self._bookNum
	end
	-- --加载窗花
	local paper = self:loadPaper(bg, id)
	bg._paper = paper
	return bg
end

--加载窗花
function M:loadPaper(parent, id, anchorP, pos)
	if tolua.isnull(parent) then return end
 	local book = self._bookType == 1 and import("app.handbook.node.BookPage1") or import("app.handbook.node.BookPage2")
	local paper = book.new({
		layer   = self,
		scaleX  = 1,
		id		= id
	}):to(parent, 1000):p(parent:cw()/2, parent:ch()/2)
	return paper
end

-- 拍下书页
function M:takePhoto()
	local id = self.bookLeft._paper._id
	-- self.bookLeft._paper:scaleX(-1)
	local photoPath = PH.combine(G_CAMERA_PHOTO_PATH, "/page/left/" .. self._bookType .. "/" .. id .. ".png")
	print("==============================", self._id, photoPath)
	if IO.exists(photoPath) then
		       -- 存在图片，清空缓存
        R.removeSpriteFrameByImageName(photoPath)

		-- return photoPath, id
	end
    -- -- 过滤已有的拍照截图
    -- local paths = self._layer._photoPaths
    -- local index = T.indexOf(paths, photoPath)
    -- if index ~= -1 then
    --     self._path = paths[index]
    --     return
    -- end
    -- -- 创建新的拍照截图
    -- if self._pageId >= 1 and self._pageId <= self._totalPage then
        local box = self.bookLeft._paper:getBoundingBox()
        local color = ccc4(255, 230, 201, 0)
        local path = SO.shot({
            renderBackground    = true,
            rect                = box,
            path                = photoPath,
            nodes            	= { self.bookLeft._paper },
            backgroundColor     = color,
        })
		-- self._path = path
		return path, id
    -- end
end

--播放进入语音
function M:playEnterVoice()
	if self._bookType ~= 2 then return end
	--停止播放语音
	self:stopEnterVoice()
	local id = self.bookLeft._paper._id
	id = (id + 1) / 2
	local voiceId = {"057159", "057161", "057163", "057165", "057167", "057169", "057171", "057196","273388"}
	self._titleVoice = soundVoice["playEffectv" .. voiceId[id]](soundVoice)
	local time = soundVoice:soundDuration("v"..voiceId[id], 1.5)
	self._delayVoiceAct = A.line({
		{"Delay", time},
		{"fn", function ()
			local voiceId = { "057160", "057162", "057164", "057166", "057168", "057170", "057172", "057197" ,"273389"}
			self._introduceVoice = soundVoice["playEffectv" .. voiceId[id]](soundVoice)
		end}
	}):at(self)
end

--停止播放语音
function M:stopEnterVoice()
	if self._bookType ~= 2 then
		return
	end
	if self._titleVoice then
		sound.stopSound(self._titleVoice)
		self._titleVoice = nil
	end
	if self._delayVoiceAct then
		self:stopAction(self._delayVoiceAct)
		self._delayVoiceAct = nil
	end
	if self._introduceVoice then
		sound.stopSound(self._introduceVoice)
		self._introduceVoice = nil
	end
end

--------------------------
-- 功能函数
--------------------------
-- 是否点击在热区上
function M:isTouchHotRect(x, y)
	-- local point = cc.p(x, y)
	local point = self:convertToNodeSpace(cc.p(x, y))
	if cc.rectContainsPoint(self.hotLeftRect, point) then
		print("点击左边热区")
		return "left"
	elseif cc.rectContainsPoint(self.hotRightRect, point) then
		print("点击右边热区")
		return "right"
	else
		return nil
	end
end

-- 能否下翻
function M:canFlipNext()
	-- print("能否下翻",self.pageIndex_R)
	-- if self.pageIndex_R < self._bookNum then
	-- 	return true
	-- else
	-- 	return false
	-- end
	return true
end

-- 能否上翻
function M:canFlipPrev( )
	-- print("能否上翻", self.pageIndex_L)
	-- if self.pageIndex_L > 1 then
	-- 	return true
	-- else
	-- 	return false
	-- end
	return true
end

-- 改变页面显示
function M:changeBookShow(flipDir)
	if flipDir == "left" then
		self.pageIndex_L, self.pageIndex_R = self:getPrevStr()
	elseif flipDir == "right" then
		self.pageIndex_L, self.pageIndex_R = self:getNextStr()
	end

	if not tolua.isnull(self.bookLeft) then
		self.bookLeft:remove()
	end
	if not tolua.isnull(self.bookRight) then
		self.bookRight:remove()
	end
	self.bookLeft 	= self:loadOnePage(self.pageIndex_L)
	self.bookRight 	= self:loadOnePage(self.pageIndex_R)
	self:getParent():playVoice(self.pageIndex_L)
end

-- 下一页地址
function M:getNextStr()
	local left 	= self.pageIndex_L + 2
	local right = self.pageIndex_R + 2
	if right > self._bookNum then
		-- 回到起始页
		right = 2
		left  = 1
	end
	return left, right
end

-- 上一页地址
function M:getPrevStr()
	local left 	= self.pageIndex_L - 2
	local right = self.pageIndex_R - 2
	if left < 1 then
		-- 回到起始页
		left  = self._bookNum - 1
		right = self._bookNum 
	end
	return left, right
end

--------------------------
-- 属性
--------------------------



--------------------------
-- 父类重写
-------------------------- 

function M:onTouchBegan(x, y, touches)
	return SIGN_TOUCH_BEGAN_NO_SWALLOWS 
end
--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]
end

return M






