--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = class("BookPage2", import("app.handbook.node.BasePage"))
M.TAG       = "BookPage2"
local DateConfig = import("app.handbook.config.Config")

----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer     = params.layer
    --触控
    self._canTouch  = false
    -- id
    self._id        = ifnil(params.id, 1)
    --是否需要翻转
    self._scaleX    = ifnil(params.scaleX, 1)
    --需要拍照
    self._needPhoto = ifnil(params.needPhoto, false)
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    if self._needPhoto then
        -- 延迟拍照
        self:delayTakePhoto()
    end
end


-- 加载书本内容
function M:loadPageContent()
    -- 图片渲染
    self:loadDisplay()
    self:removeCurrentPhotos()
    -- 加载结点
    self:loadPageNode()
end

-- 图片渲染
function M:loadDisplay()
    local img = "handbook/book2/page/1.png"
    if self._id % 2 == 0 then
        img = "handbook/book2/page/2.png"
    end
    self:display(img):scaleX(self._scaleX)
end

-- 加载结点
function M:loadPageNode()
    local moveNode = U.loadNode({}):to(self, 999):p(self:cw() / 2, self:ch() / 2):bindTouch()
    self._moveNode = moveNode

    local configTb = {}
    if device.language == "zh" then
        T.copyTable(configTb, DateConfig.HandbookConfig[self._id])
    else
        T.copyTable(configTb, DateConfig.HandbookConfigInternational[self._id])
    end

    for i, config in ipairs(configTb) do
    
        local id    = config.id
        local angle = config.angle == nil and 0 or config.angle
        local paper
        if config.type then
            if config.type == "title" then
                --加载标题文字
                paper = self:loadTitle(config.pos, config.z, id, config.titleId)
            elseif config.type == "describe" then
                --加载描述
                paper = self:loadDescribe(config.pos, config.z, id)
            end
        else
            paper = D.img("handbook/book2/item/" .. self._id .. "/" .. id .. ".png")
            :to(moveNode, config.z):p(config.pos):anchor(config.anchor):rotate(angle)
        end
    end
end

--加载标题文字
function M:loadTitle(pos, z, id, titleId)
    pos = ifnil(pos, cc.p(self:cw()/2, self:ch() / 2))
    id = ifnil(id, 1)
    z  = ifnil(z, 1)
    titleId = ifnil(titleId, 1)

    local base = {}

    if device.language == "zh" then
        base  = D.img("handbook/book2/base.png"):to(self._moveNode, z):p(pos):bindTouchLocate()
        local title = D.img(id..".png"):to(base):p(base:cw()/2, base:ch()/2)--:bindTouchLocate()
    else
        local size = {}
        size = {1, 1, 1, 1, 1, 1, 1, 1}
        -- {0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8, 0.8}
        if device.language == "es" then
            size = {0.6, 0.68, 0.8, 0.6, 0.45, 0.7, 0.5, 0.7}
        elseif device.language == "ar" then
            size = {0.8, 0.8, 1, 0.8, 0.7, 0.8, 0.7, 0.8}
        elseif device.language == "en" then
            size = {0.8, 0.8, 0.8, 0.8, 0.5, 0.8, 0.5, 0.8}
        elseif device.language == "fr" then
            size = {0.7, 0.5, 0.8, 0.8, 0.5, 0.8, 0.48, 0.75}
        elseif device.language == "id" then
            size = {0.7, 0.6, 0.8, 0.6, 0.5, 0.8, 0.5, 0.8}
        elseif device.language == "pt" then
            size = {0.6, 0.7, 0.8, 0.45, 0.5, 0.7, 0.5, 0.7}
        elseif device.language == "ru" then
            size = {0.7, 0.8, 0.47, 0.58, 0.4, 0.8, 0.5, 0.8}
        elseif device.language == "th" then
            size = {1, 0.7, 0.8, 0.6, 0.8, 0.8, 0.8, 1}
        elseif device.language == "vi" then
            size = {0.8, 0.7, 0.8, 0.7, 0.8, 0.8, 0.5, 0.8}
        elseif device.language == "ja" then
            size = {0.5, 0.8, 0.8, 0.5, 0.5, 0.8, 1, 1}
        end
        if device.language ~= "zh" then
            if id == 58 then
                local scaleSize = size[titleId]
                --获取调整大小
                scaleSize = self:getAdjustmentSize(scaleSize)
                base  = D.img(id..".png"):to(self._moveNode, z):p(pos.x + 50, pos.y):bindTouchLocate():scale(scaleSize)
            elseif id ~= 59 then
                base  = D.img(id..".png"):to(self._moveNode, z):p(pos):bindTouchLocate():scaleX(size[titleId])
            end
        else
            base  = D.img(id..".png"):to(self._moveNode, z):p(pos):bindTouchLocate():scaleX(size[titleId])
        end
    end

    return base
end

--获取调整大小
function M:getAdjustmentSize(size)
    local adjustmentSize = ifnil(size, 1)
    if device.language == "zht" or device.language == "en" or device.language == "ru" then
        adjustmentSize = 1.2
    elseif device.language == "ar" or device.language == "fr" or device.language == "pt" 
    or device.language == "es" then
        adjustmentSize = 1
    elseif device.language == "id" or device.language == "ja" then
        adjustmentSize = 1
    end
    return adjustmentSize
end



--加载描述
function M:loadDescribe(pos, z, id)
    pos = ifnil(pos, cc.p(self:cw() / 2, self:ch() / 2))
    id = ifnil(id, 1)
    z = ifnil(z, 1)
    local describe = D.img(id .. ".png"):to(self._moveNode, z):p(pos):anchor(ccp(0, 1))
    return describe
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    -- if self._layer._canTouch then
    --     if self._canTouch then
    --         return true
    --     end
    -- end
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
