--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类
----------------------
local M     = classSpriteTouch("Btn")
M.TAG       = "Btn"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer = params.layer
    --触控
    self._canTouch = false
    -- 1:左按钮   2：右按钮
    self._id   = params.id or 1
    -- 书本
    self._book = params.book
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    --按钮呼吸
    -- self:btnBreath()
end

-- 图片渲染
function M:loadDisplay()
    local angleTb = {180, -180}
    self._angle = angleTb[self._id]
    self:display("handbook/btn/btn.png"):rotate(self._angle):scale(0)
end

-- 加载结点
function M:loadPageNode()
    self:bindTouch()
    local arrow = D.img("handbook/btn/arrow.png"):to(self):p(self:cw()/2, self:ch() / 2):rotate(self._angle)
    if self._id == 1 then
        arrow:flipX(true)--:anchor(ccp(1, 0.5))
    end
    self._arrow = arrow
    local light = D.img("handbook/btn/base.png"):to(self, -1):p(self:cw() / 2, self:ch() / 2):scale(0.88)
    self._light = light
end

--按钮呼吸
function M:btnBreath()
    self._light:show()
    A.cycle({
        { "union", {
            { "fadeout", 0.8 },
            { "scaleTo", 0.8, 1.1 },
        } },
        { "scaleTo", 0.1, 0.88 },
        { "fadein", 0.1 },
    }):at(self._light)
    self:cycle({
        { "scaleto", 0.5, 1.05 },
        { "scaleto", 0.5, 1 },
    })
end

--停止呼吸
function M:stopBreath()
    self:stopAllActions():scale(0)
    self._light:stopAllActions():hide()
end

--按钮进场
function M:enter(callBack)
    if self._enter then return end
    local turn = { "left", "right" }
    -- 是否触发翻页，
    local result = self._book:isTrigger(turn[self._id])
    if not result then return end
    self._enter = true
    self:line({
        { "show"},
        { "union", {
            { "easing", "backout", { "rotateto", 0.8, 0 },},
            { "easing", "backout", { "scaleto", 0.8, 1 },},
            { "fadeTo", 0.5, 255 },
        } },
        { "fn", function()
            self:bindTouch()
            --按钮呼吸
            self:btnBreath()
            self._canTouch = true
            if callBack then
                callBack()
            end
        end },
    })
end

--退场
function M:quit()
    if not self._enter then return end
    self._enter = false
    self._canTouch = false
    self:stopAllActions():scale(1)
    self._arrow:stopAllActions():scale(0.88):opacity(255)
    self:line({
        { "union", {
            { "union", {
                { "rotateby", 0.5, self._angle },
                { "easing", "backin", { "scaleto", 0.5, 0 },},
            } },
        } },
        {"hide",},
        {"fn", function ()
            self:stopBreath()
        end}
    })
end

--需不需要退出
function M:needQuit()
    local turn = { "left", "right" }
    -- 是否触发翻页，
    local result = self._book:isTrigger(turn[self._id])
    if not result then
        self:quit()
    end
end
--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
	if not self._layer._canTouch then return end
    if not self._canTouch then return end
    if self._book._isFlipPage then return end
    self._book._isFlipPage = true
    -- 播放音效[sfx05700001]通用点击
    soundEffect:playEffectsfx05700001()
    self:scaleX(0.8)
    -- --  触控有效
    return SIGN_TOUCH_BEGAN_SWALLOWS
end

function M:onTouchEnded(x, y, touches)
    -- self._layer.bookNode:stopVoice()
    local turn = { "left", "right" }
    local result = self._book:startAutoFlip(turn[self._id])
    if result then
        -- self._layer:loadSwallowNode()
        self._layer._canTouch = false
    end
    self:touchEffect()
end

function M:touchEffect()
    local direction = -1
    if self._id == 2 then
        direction = 1
    end
    self:line({
        A.union({
            { "moveby", 0.1, ccp(-10 * direction, 0) },
            { "scaleTo", 0.1, 0.8, 1.2 },
        }),
        A.union({
            { "moveby", 0.2, ccp(50 * direction, 0) },
            { "fadeTo", 0.2, 50 },
            { "scaleTo", 0.2, 1.3, 0.5 },
        }),
        A.union({
            { "easing", "backout", { "moveby", 0.3, ccp(-40 * direction, 0) } },
            { "fadeTo", 0.3, 255 },
            { "scaleTo", 0.3, 1, 1 },
        }),
    })
    self._arrow:line({
        A.union({
            { "moveby", 0.1, ccp(-15 * direction, 0) },
            { "scaleTo", 0.1, 0.8, 1.2 },
        }),
        A.union({
            { "moveby", 0.2, ccp(20 * direction, 0) },
            { "fadeTo", 0.2, 50 },
            { "scaleTo", 0.2, 1.3, 0.5 },
        }),
        A.union({
            { "easing", "backout", { "moveby", 0.3, ccp(-5 * direction, 0) } },
            { "fadeTo", 0.3, 255 },
            { "scaleTo", 0.3, 1, 1 },
        }),
    })
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
