--[[

Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 图鉴按键
----------------------
local M    = class("Item", import("app.common.node.BaseNode"))


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    --J.assert(M.TAG, params.images ~= nil and #params.images == 4,"images size must be 4")
    -- [超类调用]
    M.super.ctor(self, params)
    --层
    self._layer    = params.layer
    --触控
    self._canTouch = false
    --id
    self._id       = ifnil(params.id, 1)
    --是否在屏幕内
    self._inScreen = true
    --按钮
    self._btnTb    = {}
end




----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- [超类调用]
    M.super.onRender(self)
    -- 图片渲染
    self:loadDisplay()
    -- 加载结点
    self:loadPageNode()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    self._canTouch = true
    local time = self._id == 1 and 
    self:cycle({
        { "moveBy", 1, cc.p(0, 15) },
        { "moveBy", 1, cc.p(0, -15) },
    })
    or 
    self:cycle({
        { "moveBy", 1, cc.p(0, -15) },
        { "moveBy", 1, cc.p(0, 15) },
    })
end

-- 图片渲染
function M:loadDisplay()
    local posTb = {cc.p(V.w_2 - 200, V.h_2), cc.p(V.w_2 + 200, V.h_2)} 
    self._pos = posTb[self._id]
    self:display(8 + self._id..".png"):p(self._pos)
end

-- 加载结点
function M:loadPageNode()
    --加载书本
    self:loadBook()
end

--加载书本
function M:loadBook()
    -- 加载书本节点
    local bookNode = import("app.handbook.node.Book").new({
        layer      = self._layer,
        autoFlip   = false, 
        bookType   = self._id
    }):to(self._layer, 100):p(self._pos):scale(0):rotate(-30):hide()
    self._bookNode = bookNode
    --加载按钮
    self:loadBtn()
end

--加载按钮
function M:loadBtn()
    local posTb = {
        ccp(getButtonX_Left(), 280 + Y_OFFSET), ccp(getButtonX_Right(), 280 + Y_OFFSET)
    }
    for i = 1, 2 do
        local button = import("app.handbook.node.Btn").new({
            id       = i,
            layer    = self._layer,
            book     = self._bookNode
        }):to(self._layer, 999):p(posTb[i]):hide()
        if i == 1 then
            button:flipX(true)
        end
        table.insert(self._btnTb, button)
    end
end

--按钮进场
function M:btnEnter()
    for i, v in ipairs(self._btnTb) do
        v:enter()
    end
end

--按钮退场
function M:btnQuit()
    for i, v in ipairs(self._btnTb) do
        v:quit()
    end
end

--判断按钮是否需要退出
function M:btnNeedQuit()
    for i, v in ipairs(self._btnTb) do
        --需不需要退出
        v:needQuit()
    end
end

--退出
function M:quit()
    if not self._inScreen then return end
    local posTb = { cc.p(-self:cw(), self._pos.y), cc.p(V.w + self:cw(), self._pos.y)}
    local pos = posTb[self._id]
    self._inScreen = false
    self:line({
        { "easing", "backin", { "moveto", 0.5, pos },},
        { "fn", function ()
            self._canTouch = false
        end}
    })
end

--进场
function M:enter()
    if self._inScreen then return end
    self:line({
        { "easing", "backout", { "moveto", 0.5, self._pos },},
        { "fn", function()
            self._canTouch = true
            self._inScreen = true
        end }
    })
end

--书本出现
function M:bookShow()
    for i, v in ipairs(self._layer._itemTb) do
        if v ~= self then
            -- 播放音效[sfx05701007]另一本书退下
            soundEffect:playEffectsfx05701007()
            --退出
            v:quit()
        end
    end
    self:line({
        { "easing", "backin", { "scaleto", 0.5, 0 },},
        {"fn", function ()
            if self._id == 1 then
                --播放歌谣音乐
                self._layer:playBookType1Music()
            end
            -- 播放音效[sfx05701008]书本打开
            soundEffect:playEffectsfx05701008()
            --图鉴打开书本
            self._bookNode:handbookOpenBook(function ()
                --改变状态
                self._layer:changeType(self)
                --按钮进场
                self:btnEnter()
            end)
            self._bookNode:line({
                {"show"},
                {"union", {
                    { "easing", "backout", { "scaleto", 0.5, 1 },},
                    { "rotateto", 0.5, 0},
                    { "jumpto", 0.5, cc.p(V.w_2 + 21, V.h_2), 100, 1}
                }},
                { "scaleto", 0.2, self._scaleSize * 1.1, self._scaleSize * 0.95 },
                { "scaleto", 0.2, self._scaleSize * 0.98, self._scaleSize * 1.05 },
                { "scaleto", 0.1, self._scaleSize * 1.02, self._scaleSize * 0.98 },
                { "scaleto", 0.1, self._scaleSize, self._scaleSize },
            })
        end}
    })
end

--书本隐藏
function M:bookHide()
    -- self._layer:loadSwallowNode()
    self._layer._canTouch = false
    --按钮退场
    self:btnQuit()
    --关闭书本
    self._bookNode:closeBook()
    self._bookNode:line({
        { "delay", 0.2},
        { "union", {
            { "easing", "backin", { "scaleto", 0.8, 0 },},
            { "rotateto", 0.8, -30 },
            { "jumpto", 0.8, self._pos, 100, 1 }
        } },
        {"hide"},
        { "fn", function()
            self:line({
                { "easing", "backout", { "scaleto", 0.5, 1 },},
                { "fn", function ()
                    -- -- 删除吞噬触控的节点
                    -- self._layer:removeSwallowNode()
                    self._layer._canTouch = true
                    self._canTouch = true
                end}
            })
            for i, v in ipairs(self._layer._itemTb) do
                if v ~= self then
                    v:enter()
                end
            end
        end }
    })
end

--播放音频
function M:playItemVoive()
    local voiceId = { "75", "76" }
    soundVoice["playEffectv0571" .. voiceId[self._id]](soundVoice)
end

--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if self._layer._canTouch then
        if self._canTouch then
            self._layer._canTouch = false
            self._canTouch = false
            -- 播放音效[sfx05700001]通用点击
            soundEffect:playEffectsfx05700001()
            self:scale(self._scaleSize * 1.1)
            Tools:closeAd(false, false)
            --  触控有效
            return true
        end
    end

end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --播放音频
    self:playItemVoive()
    --书本出现
    self:bookShow()
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
    M.super.onDestructor(self)
end

----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()

end



----------------------
-- 点击
----------------------
--[[--

判断是否点击到内容区域

### Example:

### Parameters:
-   string **event**    事件名称
-   number **x**        点击位置x(相对于屏幕)
-   number **y**        点击位置y(相对于屏幕)

]]
function M:onTouchHandled(event, x, y)

end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
    
end


return M
