--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]


--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSprite("CheckPoint")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
 	-- [本类调用]
 	self.pageWidth  = 0 -- page宽
 	self.pageHeight = 0 -- page高
 	self.rDown      = 0 -- 下面半圆的半径
 	self.rUp        = 0 -- 上面半圆的半径 

 	self.cPoint     = cc.p(0, 0) -- c点
 	self.dPoint     = cc.p(0, 0) -- d点
 	self.bPoint     = cc.p(0, 0) -- b点
 	self.aPoint     = nil -- a点

 	self.targetPoint = cc.p(0, 0) -- 松开鼠标时，此点为c点。控制该点运动，c点跟随。

 	self.lineAngle = 0            -- 两页书交线的角度
 	self.pageAngle = 0            -- 角度 
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	-- [超类调用]
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay() 
	-- 加载渲染以外的其他操作
	self:loadRenderOtherwise()
end 

-- 加载节点
function M:loadDisplay()
	-- 
end 

-- 加载渲染以外的其他操作
function M:loadRenderOtherwise()
	-- 

	self:bindTouch() 
end




--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end










--------------------------
-- 功能函数
--------------------------
-- 计算c点位置
-- mouse_X 鼠标所在的横坐标
-- mouse_Y 鼠标所在的纵坐标
-- flipDir 起始页脚的名称
function M:judgeCpointPosition(mouse_X, mouse_Y, flipDir)
	local cPointY = 0
	-- 设置c点横坐标值
	if mouse_X >= self.pageWidth then  --如果鼠标滑出书的右边
		self.cPoint.x = self.pageWidth
	elseif mouse_X <= 0 then           --如果鼠标滑出书的左边
		self.cPoint.x = 0
	else
		self.cPoint.x = mouse_X
	end

	if flipDir == "right" or flipDir == "left" then
		-- 计算c点纵坐标值
		if mouse_Y < 0 then 
		    --如果鼠标在书的下边的下方
			cPointY = -math.sqrt(self.rDown * self.rDown- (self.cPoint.x  - self.pageWidth/2) * (self.cPoint.x - self.pageWidth/2)) + self.pageHeight
			if cPointY > mouse_Y then 
			    --如果在半圆外
				self.cPoint.y = cPointY
			else --如果在半圆内
				self.cPoint.y = mouse_Y
			end
		else 
		    --如果鼠标在书的下边的上方
			cPointY = math.sqrt(self.rUp * self.rUp - (self.cPoint.x - self.pageWidth/2) * (self.cPoint.x - self.pageWidth/2)) + 0
			if cPointY < mouse_Y then
			    --如果在半圆外
				self.cPoint.y = cPointY
			else --如果在半圆内
				self.cPoint.y = mouse_Y
			end
		end
	end
end

-- 计算d、b、a点坐标
-- mouse_X 鼠标所在的横坐标
-- mouse_Y 鼠标所在的纵坐标
-- flipDir 起始页脚的名称
function M:judgeOtherPointPosition(mouse_X, mouse_Y, flipDir)
	if flipDir == "right" then
		self:judgeOtherPointPositionRight(mouse_X, mouse_Y, flipDir)
	elseif flipDir == "left" then
		self:judgeOtherPointPositionLeft(mouse_X, mouse_Y, flipDir)
	end
	self:checkPageAngle(self.cPoint, self.dPoint)
end

-- 计算d、b、a点坐标
-- mouse_X 鼠标所在的横坐标
-- mouse_Y 鼠标所在的纵坐标
-- flipDir 起始页脚的名称
function M:judgeOtherPointPositionRight(mouse_X, mouse_Y, flipDir)
	-- B:between
	-- C:c点
	-- S：StartCorner 起始角
	local pointBCS_X -- c点和起点的中点的横坐标
	local pointBCS_Y -- c点和起点的中点的纵坐标
	local k          -- 垂直于c点和起点连线的直线的斜率
	local bPoint_X   -- b点的横坐标
	local cx         -- a点（和起点在同一个书边的角的中点）的横坐标
	local cy         -- a点（和起点在同一个书边的角的中点）的纵坐标

	-- 计算c点和起点页脚的中心点
	pointBCS_X = self.cPoint.x + (self.pageWidth - self.cPoint.x) / 2
	pointBCS_Y = self.cPoint.y + (0 - self.cPoint.y) / 2
	-- 计算垂直于c点和起点连线的直线的斜率
	k = self:getK0(self.cPoint, cc.p(self.pageWidth, 0))            
	-- 计算d点坐标
	self.dPoint.y = 0
	self.dPoint.x = (self.dPoint.y - pointBCS_Y) / k + pointBCS_X
	-- 计算b、a点
	bPoint_X = (self.pageHeight - pointBCS_Y) / k + pointBCS_X -- b点横坐标
	if bPoint_X > self.pageWidth then
		-- 如果b点横坐标在横着的书边以外，则必点沿着竖着的树边走
		self.aPoint = nil
		-- 计算b点坐标
		self.bPoint.x = self.pageWidth
		self.bPoint.y = (self.pageWidth - pointBCS_X) * k + pointBCS_Y
	else
		-- 如果b点横坐标在横着的书边以内，则b点沿着横着着的树边走
		if self.aPoint == nil then
			self.aPoint = cc.p(0, 0)
		end
		-- 计算a点坐标
		cx = (self.pageWidth + self.pageHeight * k - k * pointBCS_Y + k * k * pointBCS_X) / (1 + k * k)
		cy = k * (cx - pointBCS_X) + pointBCS_Y
		self.aPoint.x = 2 * cx - self.pageWidth
		self.aPoint.y = 2 * cy - self.pageHeight
		-- 计算b点坐标
		self.bPoint.y = self.pageHeight
		self.bPoint.x = (self.pageHeight - pointBCS_Y) / k + pointBCS_X
	end
end

-- 计算d、b、a点坐标-- mouse_X 鼠标所在的横坐标-- mouse_Y 鼠标所在的纵坐标-- flipDir 起始页脚的名称
function M:judgeOtherPointPositionLeft(mouse_X, mouse_Y, flipDir)
	-- B:between
	-- C:c点
	-- S：StartCorner 起始角
	local pointBCS_X -- c点和起点的中点的横坐标
	local pointBCS_Y -- c点和起点的中点的纵坐标
	local k          -- 垂直于c点和起点连线的直线的斜率
	local bPoint_X   -- b点的横坐标
	local cx         -- a点（和起点在同一个书边的角的中点）的横坐标
	local cy         -- a点（和起点在同一个书边的角的中点）的纵坐标

	-- 计算c点和起点页脚的中心点
	pointBCS_X = self.cPoint.x + (0 - self.cPoint.x) / 2
	pointBCS_Y = self.cPoint.y + (0 - self.cPoint.y) / 2
	-- 计算垂直于c点和起点连线的直线的斜率
	k = self:getK0(self.cPoint, cc.p(0, 0))
	-- 计算d点坐标
	self.dPoint.y = 0
	self.dPoint.x = (self.dPoint.y - pointBCS_Y) / k + pointBCS_X

	-- 计算b、a点
	bPoint_X = (self.pageHeight - pointBCS_Y) / k + pointBCS_X-- b点横坐标
	if bPoint_X < 0 then
		-- 如果b点横坐标在横着的书边以外，则必点沿着竖着的树边走
		self.aPoint = null
		-- 计算b点坐标
		self.bPoint.x = 0
		self.bPoint.y = (0 - pointBCS_X) * k + pointBCS_Y
	else
		-- 如果b点横坐标在横着的书边以内，则b点沿着横着着的树边走
		if self.aPoint == nil then
			self.aPoint = cc.p(0, 0)
		end
		-- 计算a点坐标
		cx = (0 + self.pageHeight * k - k * pointBCS_Y + k * k * pointBCS_X) / (1 + k * k)
		cy = k * (cx - pointBCS_X) + pointBCS_Y
		self.aPoint.x = 2 * cx - 0
		self.aPoint.y = 2 * cy - self.pageHeight
		-- 计算b点坐标
		self.bPoint.y = self.pageHeight
		self.bPoint.x = (self.pageHeight - pointBCS_Y) / k + pointBCS_X
	end
end


-- 计算c点和起点连线垂直平分线的斜率
-- cPoint c点
-- pointCorner 起点
function M:getK0(cPoint, pointCorner)
	local disX = pointCorner.x - cPoint.x
	local disY = pointCorner.y - cPoint.y
	if disX == 0 then
		disX = 0.0001
	end
	local k = disY/disX -- c点和起点连线的斜率
	if k == 0 then 
		k = 0.0001
	end	
	self.lineAngle = math.atan2(pointCorner.y - cPoint.y, pointCorner.x - cPoint.x) * 180 / math.pi
	return -1*1/k
end

function M:checkPageAngle(cPoint, dPoint)
	self.pageAngle = math.atan2(dPoint.y - cPoint.y, dPoint.x - cPoint.x) * 180 / math.pi
end



















-- flipDir 翻页方向
function M:autoFlip(flipDir)
	local _targetPoint = cc.p(0, 0)
	if flipDir == "right" then
		self.targetPoint = cc.p(self.pageWidth, 0)
		_targetPoint = cc.p(self.pageWidth - 200, 0 + 200)
	elseif flipDir == "left" then
		self.targetPoint = cc.p(0, 0)
		_targetPoint = cc.p(200, 200)
	end

	local node = U.loadNode():to(self):p(self.targetPoint) -- 翻页移动结点
	local action = A.actionBezierTo({
		time = .3,
		startPosition   = node:point(),
		endPosition     = _targetPoint,
		high            = 20
		})
	
	node:line({
		action,
		{"fn", function (  )
			node:stopAllActions()
			self:pageFirstMoveCompleteHandler(node, flipDir)
		end}
		})
	node:cycle({
		{"fn", function ( )
			self:pageMovingHandler(node, flipDir)
		end},
		{"delay", 1/60}
		})
end

-- 自动翻页过程中调用
function M:pageMovingHandler(node, flipDir)
	self:checkPoints(node:px(), node:py(), flipDir)
end

-- 翻页完成
function M:pageFirstMoveCompleteHandler(node, flipDir)
	local node = U.loadNode():to(self):p(node:point()) -- 翻页移动结点
	local _targetPoint = cc.p(0, 0)
	if flipDir == "right" then
		_targetPoint = cc.p(0, 0)
	elseif flipDir == "left" then
		_targetPoint = cc.p(self.pageWidth, 0)
	end

	local dis  = cc.pGetDistance(node:point(), _targetPoint)
	local t    = dis / 1200
	local high = node:py() > 0 and 50 or -50

	if t < .2 then
		t = .2
	end

	local action = A.actionBezierTo({
		time = t,
		startPosition   = node:point(),
		endPosition     = _targetPoint,
		high            = high
		})

	node:line({
		action,
		{"fn", function (  )
			node:stopAllActions()
			self:pageMoveCompleteHandler()
		end}
		})
	node:cycle({
		{"fn", function (  )
			self:pageMovingHandler(node, flipDir)
		end},
		{"delay", 1/60}
		})
end

-- 翻页不成功，倒回
function M:notPageFlipCompleteHandler(node, flipDir)
	self.isSlowClose = false -- 缓缓合并
	local node = U.loadNode():to(self):p(node:point()) -- 翻页移动结点
	local _targetPoint = cc.p(0, 0)
	if node:py() < 0 then
		self.isSlowClose = true
		if flipDir == "right" then
			_targetPoint = cc.p(self.pageWidth - 30, 0)
		elseif flipDir == "left" then
			_targetPoint = cc.p(30, 0)
		end
	else
		if flipDir == "right" then
			_targetPoint = cc.p(self.pageWidth, 0)
		elseif flipDir == "left" then
			_targetPoint = cc.p(0, 0)
		end
	end
	node:line({
		{"moveTo", .3, _targetPoint},
		{"fn", function (  )
			node:stopAllActions()
			if self.isSlowClose then
				self:slowClose(node, flipDir)
			else
				self:notpageMoveCompleteHandler()
			end	
		end}
		})
	node:cycle({
		{"fn", function (  )
			self:pageMovingHandler(node, flipDir)
		end},
		{"delay", 1/60}
		})
end

function M:slowClose(node, flipDir)
	local node = U.loadNode():to(self):p(node:point()) -- 翻页移动结点
	local _targetPoint = cc.p(0, 0)
	if flipDir == "right" then
		_targetPoint = cc.p(self.pageWidth, 0)
	elseif flipDir == "left" then
		_targetPoint = cc.p(0, 0)
	end

	node:line({
		{"moveTo", .1, _targetPoint},
		{"fn", function (  )
			node:stopAllActions()
			self:notpageMoveCompleteHandler()
		end}
		})
	node:cycle({
		{"fn", function (  )
			self:pageMovingHandler(node, flipDir)
		end},
		{"delay", 1/60}
		})
end









-- 翻页成功完毕
function M:pageMoveCompleteHandler()
	self:getParent():pageMoveComplete()
end

-- 翻页不成功完毕
function M:notpageMoveCompleteHandler()
	self:getParent():notpageMoveComplete()
end

-- 计算各个点
-- mouse_X 鼠标所在的横坐标
-- mouse_Y 鼠标所在的纵坐标
-- flipDir 方向
function M:checkPoints(mouse_X, mouse_Y, flipDir)
	self:judgeCpointPosition(mouse_X,mouse_Y, flipDir)
	self:judgeOtherPointPosition(mouse_X, mouse_Y, flipDir)
	self:getParent():moveHandler()
end


-- 设置尺寸
function M:setSize(pageWidth, pageHeight)
	self.pageWidth  = pageWidth
	self.pageHeight = pageHeight

	--下面半圆的半径
	self.rDown = math.sqrt(self.pageHeight * self.pageHeight + (self.pageWidth/2) * (self.pageWidth/2))
	-- 上面半圆的半径
	self.rUp = self.pageWidth / 2
end


--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






