--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]




--------------------------
-- 引入命名空间
--------------------------
local StaticMask    = import("app.handbook.node.flippage.StaticMask")
local DragedMask    = import("app.handbook.node.flippage.DragedMask")
local ShadowMask    = import("app.handbook.node.flippage.ShadowMask")
local CheckPoint    = import("app.handbook.node.flippage.CheckPoint")
local HalfPage      = import("app.handbook.node.flippage.HalfPage")
local ShadowManager = import("app.handbook.node.flippage.ShadowManager")
local Shadow        = import("app.handbook.node.flippage.Shadow")
--[[
	类
--]]


local M 	= classSprite("FlipPage")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	self.pageWidth  = params.pageWidth
 	self.pageHeight = params.pageHeight
 	-- 翻页方向
 	self.flipDir    = nil
 	-- 书本
 	self.book       = params.book

 	-- 是否加载完翻页页面
 	self.loadOk     = false
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay()
end 

-- 加载节点
function M:loadDisplay()
    -- 不动的页面的遮罩
	self.staticPageMask  = StaticMask.new({}):to(self):p(0, 0)
	-- 被拖动的页面的遮罩
	self.dragedPageMask  = DragedMask.new({}):to(self):p(0, 0)
	-- 翻页点运算
	self.checkPoint      = CheckPoint.new({}):to(self):p(0, 0)
	self.checkPoint:setSize(self.pageWidth, self.pageHeight)
	-- 
	local maskAll  = self.staticPageMask
	local maskHalf = self.dragedPageMask
	self.halfPage  = HalfPage.new({
									book 	   = self.book,
									pageWidth  = self.pageWidth,
									pageHeight = self.pageHeight,
									staticPageMask = maskAll,
									dragedPageMask = maskHalf
									}):to(self, 10):p(0, 0)



	-- ******设置阴影*******
	-- 跟随移动的阴影的遮罩
	-- self.downShadowMask = ShadowMask.new({}):to(self):p(0, 0)
	-- self.downShadowMask:creat(self.pageWidth, self.pageHeight + 10)
	self.downShadowMask = U.loadNode():anchor(cc.p(0, -1)):p(0, 0):scale(1)
	-- page1、page2的纵坐标可能需要微调，视情况而定
	-- 作用，用于裁剪翻页时的阴影
	local page1, page2
	page1 = D.img("handbook/book/page/1.png"):to(self.downShadowMask):anchor(cc.p(0, 0)):p(0, 0)
	page2 = D.img("handbook/book/page/2.png"):to(self.downShadowMask):anchor(cc.p(0, 0)):p(cc.p(self.pageWidth / 2, 0))

	-- 加载阴影图片
	self.downShadow = D.img("handbook/book/page/shadow_1.png"):p(0, 0)
	self:clipFunShadow()

	-- 阴影管理
	self.shadowManager = ShadowManager.new({}):to(self):p(0, 0)
	self.shadowManager:setdownShadow(self.downShadow)
end 

-- 遮罩 CCClippingNode
function M:clipFunShadow()
	self.clipDownShadow = CCNodeExtend.extend(cc.ClippingNode:create(self.downShadowMask)):to(self, 100)
	self.clipDownShadow:setInverted(false)
	self.clipDownShadow:setAlphaThreshold(0) -- 显示透明区域
	self.clipDownShadow:addChild(self.downShadow)

	-- U.loadNodeMask({
	-- 	contentSize = cc.size(V.w * 10, V.h * 10)
	-- 	}):to(self.clipDownShadow):anchor(0, 0)
end

--------------------------
-- 功能函数
--------------------------
-- 拖动翻页
function M:dragFlip(x, y, flipDir)
	self.dragX, self.dragY = self:dragRange(x, y, flipDir)
	self.checkPoint:checkPoints(self.dragX, self.dragY, flipDir)
end

-- 拖动范围
function M:dragRange(x, y, flipDir)
	local point = self:convertToNodeSpace(cc.p(x, y))
	if point.x > self.pageWidth then -- 如果鼠标滑出书的右边
		point.x = self.pageWidth
	elseif point.x < 0 then          -- 如果鼠标滑出书的左边
		point.x = 0
	end

	-- 越靠近书页中间，书的上下翻动幅度越大
	local disx = 0
	if flipDir == "left" then
		disx = point.x
	elseif flipDir == "right" then
		disx = self.pageWidth - point.x
	end
	local maxPyY = disx/(self.pageWidth/2) * 200 -- 最大幅度200/4，用200不用50，是要扩大拉动范围


	local disy  = point.y - self.pageHeight/2    -- 书本高度的一半为界限
	if disy > maxPyY then
		disy = maxPyY
	elseif disy < -maxPyY then
		disy = -maxPyY
	end
	point.y = 0 + disy/4
	return point.x, point.y
end

-- 判断是否手动翻页
function M:adjustFlip(flipDir)
	if flipDir == "right" then
		if self.dragX < self.pageWidth/4 * 3 then
			local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
			self.checkPoint:pageFirstMoveCompleteHandler(node, flipDir)
		else
			print("不翻下一页")
			local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
			self.checkPoint:notPageFlipCompleteHandler(node, flipDir)
		end
	elseif flipDir == "left" then
		if self.dragX > self.pageWidth/4 then
			local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
			self.checkPoint:pageFirstMoveCompleteHandler(node, flipDir)
		else
			print("不翻下一页")
			local node = U.loadNode():to(self.checkPoint):p(cc.p(self.dragX, self.dragY))
			self.checkPoint:notPageFlipCompleteHandler(node, flipDir)
		end
	end 
end

-- 加载下个页面
function M:addNewPage(flipDir)
	if flipDir == "right" then
		self.flipDir = "right"
		self:addNextPage()
	elseif flipDir == "left" then
		self.flipDir = "left"
		self:addPrevPage()
	end
end

-- 加载下一页
function M:addNextPage( )
	if self.loadOk then return end
	self.flipDir = "right"
	local str1, str2 = self.book:getNextStr()
	self.halfPage:addAllPage(str1, str2, "right")
	self.loadOk = true
end


-- 预加载上一页
function M:addPrevPage( )
	if self.loadOk then return end
	self.flipDir = "left"
	local str1, str2 = self.book:getPrevStr()
	self.halfPage:addAllPage(str1, str2, "left")
	self.loadOk = true
end

-- 下一页
function M:next( )
	self:addNextPage()
	self.checkPoint:autoFlip("right")
end

-- 上一页
function M:prev( )
	self:addPrevPage()
	self.checkPoint:autoFlip("left")
end

-- 运动过程中
function M:moveHandler( )
	local checkPoint = self.checkPoint
	self.dragedPageMask:drawMask(checkPoint.cPoint, checkPoint.dPoint, checkPoint.bPoint, checkPoint.aPoint) -- 调整遮罩
	self.staticPageMask:drawMask(self.pageWidth, self.pageHeight, checkPoint.dPoint, checkPoint.bPoint, checkPoint.aPoint, self.flipDir) -- 调整遮罩
	self.halfPage:onDrag(checkPoint.cPoint, checkPoint.pageAngle, self.flipDir) -- 调整运动的半页的状态
	self.shadowManager:setShadow(checkPoint.dPoint, checkPoint.bPoint, checkPoint.lineAngle, self.flipDir, self.pageWidth); -- 调整阴影状态
	-- self.upShadowMask:drawMask(checkPoint.cPoint, checkPoint.dPoint, checkPoint.bPoint, checkPoint.aPoint); -- 调整遮罩
end

-- 翻页完成
function M:pageMoveComplete( )
	self.halfPage:free()
	self.dragedPageMask:clear()
	self.staticPageMask:clear()
	self.book:changeBookShow(self.flipDir)
	self.shadowManager:flipCompleteHandler()
	self:getParent():overFlip(true)
	self.loadOk  = false
	self.flipDir = nil
end

-- 翻页不成功完成
function M:notpageMoveComplete( )
	self.halfPage:free()
	self.dragedPageMask:clear()
	self.staticPageMask:clear()
	self.shadowManager:flipCompleteHandler()
	self:getParent():overFlip(false)
	self.loadOk  = false
	self.flipDir = nil
end

--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]
end



return M






