--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]
--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSprite("HalfPage")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	self.book 		= params.book
 	self.pageWidth  = params.pageWidth
 	self.pageHeight = params.pageHeight
 	self.staticPageMask = params.staticPageMask
 	self.dragedPageMask = params.dragedPageMask
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay() 
end 

-- 加载节点
function M:loadDisplay()
	-- 
end 


--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end

--------------------------
-- 功能函数
--------------------------
-- str1:左页
-- str2:右页
-- dir:方向
function M:addAllPage(str1, str2, dir)
	if not str1 or not str2 then return end
	self.allPage  = U.loadNode():anchor(cc.p(0, 0))
	self.halfPage = U.loadNode():anchor(cc.p(0, 0))--:to(self:getParent())
	local page1, page2, page3
	print(str1, str2)
	-- 要显示的一页(静态)
	-- 左页
	page1 = self.book:loadOnePage(str1, self.allPage, ccp(0, 0), cc.p(0, 0))
	-- 右页
	page2 = self.book:loadOnePage(str2, self.allPage, ccp(0, 0), cc.p(self.pageWidth / 2, 0))
	-- 要显示的一页(动态)
	if dir == "right" then	
		page3 = self.book:loadOnePage(str1, self.halfPage, ccp(0, 0), ccp(0, 0))
	elseif dir == "left" then
		page3 = self.book:loadOnePage(str2, self.halfPage, ccp(1, 0), ccp(0, 0))
	end
	self:clipFunAll()
	self:clipFunHalf()
end

-- 遮罩 CCClippingNode
function M:clipFunAll()
	self.clip1 = CCNodeExtend.extend(cc.ClippingNode:create(self.staticPageMask)):to(self:getParent(), 10)
	self.clip1:setInverted(false)
	self.clip1:setAlphaThreshold(1) -- 显示透明区域
	self.clip1:addChild(self.allPage)
end
-- 遮罩 CCClippingNode
function M:clipFunHalf()
	self.clip2 = CCNodeExtend.extend(cc.ClippingNode:create(self.dragedPageMask)):to(self:getParent(), 10)
	self.clip2:setInverted(false)
	self.clip2:setAlphaThreshold(1) -- 显示透明区域
	self.clip2:addChild(self.halfPage)
end

function M:onDrag(cPoint, angle, dir)
	if dir == "right" then
		self.halfPage:p(cPoint)
		self.halfPage:rotation(-angle)
	elseif dir == "left" then
		self.halfPage:p(cPoint.x, cPoint.y)
		self.halfPage:rotation(-angle - 180)
	end	
end

-- 释放内存
function M:free( )
	if self.allPage then
		self.allPage:remove()
		self.allPage = nil
	end
	if self.halfPage then
		self.halfPage:remove()
		self.halfPage = nil
	end
	if self.clip1 then
		self.clip1:remove()
		self.clip1    = nil
	end
	if self.clip2 then
		self.clip2:remove()
		self.clip2    = nil
	end
end



--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






