--[[
Copyright (c) 2012-2020 baby-bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]


--------------------------
-- 引入命名空间
--------------------------
-- local BaseLayer = import("app.common.layer.BaseLayer")




--[[
	类
--]]


local M 	= classSprite("ShadowManager")




--------------------------
-- 构造函数
--------------------------

function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
 	-- [本类调用]
 	self.upShadow     = nil
 	self.downShadow   = nil
 	self.staticShadow = nil

 	-- 阴影透明度
 	self.shadowAlpha  = 155
 	-- 翻页完毕后是否显示阴影
 	self.showShadowOnFlipComplete = false
end

--------------------------
-- 渲染
--------------------------

function M:onRender()
	M.super.onRender(self)

 	-- [本类调用]
	-- 加载节点
	self:loadDisplay() 
end 

-- 加载节点
function M:loadDisplay()
	
end 



--------------------------
-- 析构
--------------------------

function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
 	-- [本类调用]

end







--------------------------
-- 功能函数
--------------------------
-- 翻页过程中调整阴影状态
-- d点、b点、角度
function M:setShadow(dPoint, bPoint, rotation, flipDir, pageWidth)
	if self.downShadow:getOpacity() == 0 then
		self.downShadow:line({
			{"fadeTo", .1, self.shadowAlpha},
		})
		self.downShadow:scaleX(0)
	end
	self.downShadow:stopAllActions()
	self.downShadow:opacity(self.shadowAlpha)
	self.downShadow:show()
	self.downShadow:px((bPoint.x + dPoint.x) / 2)
	self.downShadow:py((dPoint.y + bPoint.y) / 2)
	self.downShadow:rotation(-rotation)

	self:setShadowScale(flipDir, pageWidth)
end


function M:setShadowScale(flipDir, pageWidth)
	local disx = 0
	if flipDir == "left" then
		disx = self.downShadow:px()
	elseif flipDir == "right" then
		disx = pageWidth - self.downShadow:px()
	end
	local scale = disx/100
	if scale > 1 then
		scale = 1
	elseif scale < 0 then
		scale = 0
	end
	self.downShadow:scaleX(scale)
end














-- 翻页完毕后调用
-- type:翻页结果
function M:flipCompleteHandler(type, forceHideShadow)
	self.downShadow:line({
		{"fadeTo", 0.2, 0}
		})
end







function M:setdownShadow(shadow)
	self.downShadow = shadow
	self.downShadow:show()
	self.downShadow:opacity(0)
end


--------------------------
-- 属性
--------------------------




--------------------------
-- 父类重写
-------------------------- 




return M






