--[[

Copyright (c) 2012-2019 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    
    --下一场景名称
    self._nextScene= self:getScene()._nextScene
    --是否需要过度
    self._needScale = self:getScene()._needScale
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    --加载背景
    self:loadBg()
    --加载奇奇
    self:loadQi()
    --加载新年快乐
    self:loadWord()
    --加载金币
    self:loadMoney()
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    --延迟三秒进入下个场景
    self:delayEnterNextScene()
end

--延迟三秒进入下个场景
function M:delayEnterNextScene()
    if self._needScale then
        local title = "common/help1.png"
        local time = 0.8
        Tools:enterSceneScale(self, title, time)
        self:line({
            { "delay", time - 0.3 },
            { "fn", function()
                --加载音效
                self:loadEffect()
            end },
        })
    else
        --加载音效
        self:loadEffect()
    end
    self:line({
        { "delay", 3 },
        { "fn", function()
            --进入下个场景
            self:enterNextScene()
        end }
    })
end


--加载背景
function M:loadBg()
	local bg = U.loadBg("loading/bg.png"):to(self)
	self._bg = bg
end

--加载音效
function M:loadEffect()
     -- 播放音效[sfx05701011]木马摇晃
    self._loadingEffect = soundEffect:playEffectsfx05701011()
end

--停止音效
function M:stopEffect()
    if self._loadingEffect then
        sound.stopSound(self._loadingEffect)
        self._loadingEffect = nil
    end
end

--加载奇奇
function M:loadQi()
    local botton = D.img("loading/1/1.png"):to(self):p(496 + X_OFFSET, 256.4 + Y_OFFSET)
    local qq = D.img("loading/qq/1.png"):to(self):p(481.2 + X_OFFSET, 262.6 + Y_OFFSET)
    qq:cycle({
        { "image", "loading/qq/", 13, 1 / 12 }
    })
end

--加载新年快乐
function M:loadWord()
    if not isZhLanguage() then
        return
    end
    local posTb = {cc.p(389.6, 394 - 10), cc.p(457.7, 412.2), cc.p(527.2, 411.9), cc.p(596.8, 378),}
    for i, v in ipairs(posTb) do
        local word = D.img((i+1)..".png"):to(self, 9999):p(v.x + X_OFFSET, v.y + 10 + Y_OFFSET)
        local function moveAct2(node)
            local dis = 10--math.random(10, 20)
            local time = math.random(7, 10) / 10
            node:cycle({
                { "moveBy", time, cc.p(0, dis) },
                { "moveBy", time, cc.p(0, -dis) },
            })
        end
        moveAct2(word)
    end
end

--加载金币
function M:loadMoney()
    local posTb = { cc.p(3.7, 613.4), cc.p(130.4, 489.4), cc.p(53.9, 225.3), cc.p(7.2, 75.6), cc.p(164.8, 80.1),
        cc.p(269.1, 561), cc.p(288.6, 437.8), cc.p(212.1, 307.7), cc.p(331.8, 214.2), cc.p(289.3, 40.8),
        cc.p(550.1, 615.5), cc.p(611.1, 500.4), cc.p(685.7, 375.8), cc.p(632.1, 177.4), cc.p(701.2, 16.6),
        cc.p(844.4, 591.5), cc.p(874.2, 424.7), cc.p(819, 310.5), cc.p(897.7, 202.9), cc.p(797.4, 100.3),}
    for i, v in ipairs(posTb) do
        local money = D.img("loading/down/" .. math.random(1, 2) .. ".png"):to(self, 111):p(v.x + X_OFFSET, v.y)
        local dir = math.random() < 0.5 and -1 or 1
        local speed = math.random(90, 130)
        local endPy = math.random(0, 50)
        local time = (V.h + 30 - endPy) / speed
        money:line({
            A.union({
                { "moveBy", time, cc.p(0, -(V.h + 30 - endPy)) },
                { "rotateBy", time, dir * math.random(90, 180) },
            }),
            { "fn", function()
                money:stopAllActions()
                money:line({
                    { "fadeTo", 0.5, 0 },
                    { "remove" },
                })
            end }
        })
	end
	--加载金币
    self:loadMoney2(1)
    self:loadMoney2(2)
    ------------------------------
    -- 加载场景中的雪花 #层（父节点） #默认层级Z值 #需要检查Z值的精灵集合（在精灵前面落地Z值高于精灵，在精灵后面落地Z值低于精灵  ）
    ------------------------------
    --雪花
    -- Tools:loadSnows(self, 5, nil, 3, nil, { scaleSize = ccp(10, 10) }, { "loading/down/1.png", "loading/down/2.png",}, true)
end

--加载金币
function M:loadMoney2(offset)
    local posTb = { cc.p(3.7, 613.4), cc.p(130.4, 489.4), cc.p(53.9, 225.3), cc.p(7.2, 75.6), cc.p(164.8, 80.1),
        cc.p(269.1, 561), cc.p(288.6, 437.8), cc.p(212.1, 307.7), cc.p(331.8, 214.2), cc.p(289.3, 40.8),
        cc.p(550.1, 615.5), cc.p(611.1, 500.4), cc.p(685.7, 375.8), cc.p(632.1, 177.4), cc.p(701.2, 16.6),
        cc.p(844.4, 591.5), cc.p(874.2, 424.7), cc.p(819, 310.5), cc.p(897.7, 202.9), cc.p(797.4, 100.3),}
    for i, v in ipairs(posTb) do
        local money = D.img("loading/down/" .. math.random(1, 2) .. ".png"):to(self, 111):p(v.x + X_OFFSET, v.y + V.h * offset)
        local dir = math.random() < 0.5 and -1 or 1
        local speed = math.random(90, 130)
        local endPy = math.random(0, 50)
        local time = (V.h + 30 - endPy) * (offset + 1) / speed 
        money:line({
            A.union({
                { "moveBy", time, cc.p(0, -(V.h  + 30 - endPy)* (offset + 1)) },
                { "rotateBy", time, dir * math.random(90, 180) },
            }),
            { "fn", function()
                money:stopAllActions()
                money:line({
                    { "fadeTo", 0.5, 0 },
                    { "remove" },
                })
            end },
        })
    end
end

--进入下个场景
function M:enterNextScene()
    --停止音效
    self:stopEffect()

    if self._nextScene == "tfgoodswalk" then
        --[友盟][bbgcj004]廿四模块进入
        umengOP.recordbbgcj004()
        umengOP.recordTFBegin()
    elseif self._nextScene == "evekitchen" then
        --[友盟][bbgcj005]除夕模块进入
        umengOP.recordbbgcj005()
        umengOP.recordEVEBegin()
    elseif self._nextScene == "nyvisit" then
        --[友盟][bbgcj006]正月初一模块进入
        umengOP.recordbbgcj006()
        umengOP.recordNYBegin()
    end
    game:enterScene(self._nextScene, {}, "fade", 0.5, COLOR3_WHITE)
end


-- 加载其他
function M:loadRenderOtherwise()

end





--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    --   
end

function M:onTouchEnded(x, y, touches)
    --  
end


----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
