--[[

Copyright (c) 2012-2020 Baby-Bus.com

http://www.baby-bus.com/LizardMan/

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

]]

--[[!--

场景层类，定义层相关操作方法及逻辑实现。

-   定义场景层功能方法。

]]

----------------------
-- 类
----------------------
local M = classLayerTouch("Main")


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..

-- [操作变量]
-- ..








----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义视图实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
    -- [超类调用]
    M.super.ctor(self, params)
    --触控
    self._canTouch     = false
    -- 是否处于待机状态
    self._isScreenMove = true
    -- 游戏收集的心心数量
    self._collect      = 0
    -- 游戏等级
    self._level        = 1
    -- 是否处于引导状态
    self._isStayGuide  = true 
    -- 是否点一次点击完引导
    self._isFirstTouch = false
    -- 游戏是否结束
    self._isGameOver   = false
end








----------------------
-- 结点渲染
----------------------
--[[--

视图渲染，处理视图结点加载、事件绑定等相关操作

]]
function M:onRender()
    -- 加载地图
    self:loadMap()
    -- 加载ui栏
    self:loadUi()
    -- 预加载资源
    -- self:prestrain()
    -- 缓存骨骼
    self:loadSkeleton()
    -- 去广告
    Tools:closeAd()
    -- BG_SCALE = 1.25
end

----------------------
-- 新进场景过度动画播完
----------------------
function M:onEnterTransitionFinish()
    -- 播放音效[bgm10]舞龙
    sound:play057BGM10()
    -- 加载前情
    self._map._mapTile._dragon:talkEvent()
    -- self._canTouch = true
end


-- 游戏开始
function M:gameBegin()
    --播放游戏开始引导配音
    self:playBeginVoice()
    -- 加载引导遮罩
    self:loadMask()
    self._canTouch = true
    self._map._mapTile._dragon:dragonStandBy()
end

--播放游戏开始引导配音
function M:playBeginVoice()
    if not self._beginVoice then
        -- 播放配音
        self._beginVoice = soundVoice:playEffectv057155()
        local time = soundVoice:soundDuration("v057155", 3)
        self:line({
            {"delay", time},
            {"fn", function ()
                --停止播放开始引导语音
                self:stopBeginVoice() 
            end}
        })
    end
end

--停止播放开始引导语音
function M:stopBeginVoice()
    if self._beginVoice then
        sound.stopSound(self._beginVoice)
        self._beginVoice = nil
    end
end

-- 加载地图
function M:loadMap()
	local map  = self:createNode("Map", {
		layer  = self,
	}):to(self, 100):bindTouch()
    self._map = map
end

-- 加载ui栏
function M:loadUi()
    local ui  = self:createNode("Ui", {
		layer  = self,
	}):to(self, 200):unbindTouch()
    self._ui = ui
end

-- 加载首次引导
function M:loadMask()
    -- 创建引导圈
    local circle = D.img("common/guide.png"):scale(0.8):to(self, 300):p(250, 220):opacity(200):scale(0.7)
    -- 保留引用
    self._circle = circle
    -- 创建裁切节点
    local clippingNode = CCNodeExtend.extend(cc.ClippingNode:create(circle))
    -- isInverted：默认值是flase是显示被剪掉的部分，设置为true则是显示剩余的部分
    clippingNode:to(self, 300):setInverted(true)
    -- 创建遮罩
    local mask          = U.loadNodeMask({
        contentSize     = CCSize(V.w, V.h * Y_FACTOR),
        color           = ccc3(0, 0, 0),
        swallowsTouches = true,
        isMultiTouches  = false
    }):anchor(ccp(0, 0)):p(0, 0)
    :to(clippingNode, 300):opacity(200)
    -- 保留引用
    self._clippingNode = clippingNode
    -- 加载手
    self:loadHand()
end

-- 加载手指
function M:loadHand()
    local hand = D.img("common/hand/1.png"):to(self, 400):p(315, 190):unbindTouch()
    self._hand = hand
    self._guideAction = A.cycle({
        {"fadeIn", 0.3},
        {"file", "common/hand/", 3, 0.1},
        {"moveBy", 1, ccp(280, 0)},
        {"delay", 1},
        {"fadeOut", 0.3},
        {"delay", 2},
        {"fn", function()
            self._hand:p(315, 190)
            self._hand:display("common/hand/1.png")
        end},
        {"delay", 1},
    }):at(self._hand)
end

-- 停止遮罩
function M:stopMask()
    if self._circle then 
        -- 移除遮罩
        self._circle:remove()
        self._circle= nil
        self._clippingNode:remove()
        self._clippingNode = nil
        -- 停止手引导
        if self._guideAction then 
             self:stopAction(self._guideAction)
            self._hand:remove()
        end
    end
end

-- 预加载资源
function M:prestrain()
    -- 加载商店
    Tools:addTexture("nylantern/map/store/", 1, 6)
    Tools:addTexture("nylantern/map/store/1_", 1, 3)
    Tools:addTexture("nylantern/map/store/2_", 1, 2)
    Tools:addTexture("nylantern/map/store/2_1_", 1, 2)
    Tools:addTexture("nylantern/map/store/4_2_", 1, 4)
    -- 加载一级场景
    Tools:addTexture("nylantern/map/first/", 1, 3)
    Tools:addTexture("nylantern/map/first/light/", 1, 4)
    Tools:addTexture("nylantern/map/first/tree/", 1, 3)
    Tools:addTexture("nylantern/map/first/windmill/1_", 1, 2)
    Tools:addTexture("nylantern/map/first/windmill/", 1, 1)
    -- 加载二级
    Tools:addTexture("nylantern/map/second/bamboo/2_", 1, 8)
    Tools:addTexture("nylantern/map/second/desk/", 1, 5)
    Tools:addTexture("nylantern/map/second/fireworks/", 1, 5)
    Tools:addTexture("nylantern/map/second/light/", 1, 2)
    Tools:addTexture("nylantern/map/second/prospect/", 1, 17)
    Tools:addTexture("nylantern/map/second/snow/floor/", 1, 11)
    Tools:addTexture("nylantern/map/second/snow/front/", 1, 5)
    Tools:addTexture("nylantern/map/second/snow/shop/", 1, 7)
    -- 加载三级
    Tools:addTexture("nylantern/map/thirdly/", 1, 3)
    Tools:addTexture("nylantern/map/thirdly/pool/", 1, 4)
    Tools:addTexture("nylantern/map/thirdly/pool/1_", 1, 6)
    Tools:addTexture("nylantern/map/thirdly/pool/2_", 1, 4)
    Tools:addTexture("nylantern/map/thirdly/pool/3_", 1, 2)
    Tools:addTexture("nylantern/map/thirdly/pool/4_", 1, 3)
end

-- 缓存骨骼
function M:loadSkeleton()
    -- 加载三个老板
    local file = {"bone/gcj_tzx", "bone/gcj_tzf", "bone/gcj_tzm", "bone/cj_nn", "bone/cj_tyy", "bone/cj_pp", "bone/cj_wc", "bone/cj_zz", "bone/cj_mmls"}
    local armatureName = {"gxn_tzx", "gxn_tzf", "gcj_tzm", "cj_nn", "cj_tyy", "cj_pp", "cj_wc", "cj_zz", "cj_mmls"}
    for i = 1, 9 do 
        local dragon = DragonBone.addFileAndPlay(file[i], armatureName[i]):to(self):p(0, 0):hide()
    end
end

-- 加载其他
function M:loadRenderOtherwise()

end



--------------------------
-- 触控
-------------------------- 
function M:onTouchBegan(x, y, touches)
    if not self._canTouch then return end
    self._map._mapTile._dragon:stopDragonStandBy()
    self:stopMask()
    self._isFirstTouch = true
    self._isScreenMove = false
    self._map._touchPoint = cc.p(x, y)
    self._startX = x
    --  触控有效
    return true
end

function M:onTouchMoved(x, y, touches)
    if not self._canTouch then return end
    self._map._mapTile._dragon:stopDragonStandBy()
    local lastX = x
    self._map._offset = lastX - self._startX
    self._map._touchPoint = cc.p(x, y)
    self._startX = x
end

function M:onTouchEnded(x, y, touches)
    if not self._canTouch then return end
    self._map._mapTile._dragon:breathe()
    self._map._mapTile._dragon._isWalk = false
    self._map._mapTile._dragon._isRun = false
    self._map._mapTile._dragon:dragonStandBy()
    self._isScreenMove = true
    self._map._touchPoint = nil 
    self._map:stopDragon()
    self._map:stopSideBody()
    -- 背景缓存
    self._map:removeBgMove()
end

----------------------
-- 结点析构
----------------------
function M:onDestructor()
    -- [超类调用]
	M.super.onDestructor(self)
end


----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeLayerUnusedResource(self)
    DragonBone.removeAll()
end

return M
