--[[

Copyright (c) 2012-2020 Baby-Bus.com
Author:      babybus
Date:       2020

]]
--[[!--

游戏角色类，定义游戏角色公用操作方法及逻辑实现。

-   定义游戏角色相关信息。

]]

----------------------
-- 类 -- 镰刀龙基类
----------------------
local M     = classArmatureTouch("AniBear")
M.TAG       = "AniBear"


----------------------
-- 公共参数
----------------------
-- [常量]
-- ..






----------------------
-- 构造方法
----------------------
--[[--

构造方法，定义结点实例初始化逻辑

### Parameters:
-   table **params**    参数集合

### Return: 
-   object              对象实例

]]
function M:ctor(params)
	-- [超类调用]
	M.super.ctor(self, params)
	--主层
	self._layer       = params.layer
	-- 所在的地图id
	self._index       = params.index
	-- 是否可以点击
	self._canTouch    = true
	-- 选对次数
	self._count       = 0
	self._standbyTab  = {}
	-- 是否是商人
	self._npcName     = "store"
	-- 是否收可以收集心心
	self._isCanGather = true
	-- 是否可以碰撞检测
	self._isCanCrash  = true
end


----------------------
-- 结点渲染 
----------------------
--[[--

实体渲染，处理实体结点加载、事件绑定等相关操作

]]
function M:onRender()
	-- [超类调用]
	M.super.onRender(self)
	-- 呼吸
	self:breathe()
	-- 待机动画
	self:standby()
	-- 加载爱心
	self:loadLove()
end

----------------------
-- 结点析构
----------------------
--[[--

实体析构，处理实体结点卸载、事件解除绑定等相关操作

]]
function M:onDestructor()
	-- [超类调用]
	M.super.onDestructor(self)
end

-- 收集到爱心
function M:stopWalkHappy()
	-- 收集到心心
	self._layer._layer:collectLove(self, true, self._index)
	self:crashCall()
	self._isCanGather = false
	self._isCanCrash  = false
end

-- 加载爱心
function M:loadLove()
	local love = P.newParticle("particle/drg_jindutiao_tuowei1.plist"):to(self):p(200, 460):scale(3):hide()
	love:setPositionType(kCCPositionTypeRelative)
	--  加载粒子
	local particle = P.newParticle("particle/drg_heart.plist"):to(self, 999):p(200, 470):scale(2.5)
	-- 固定粒子位置
	particle:setPositionType(kCCPositionTypeRelative)
	Tools:insertParticleTb(self, love)
	Tools:insertParticleTb(self, particle)
	self._particleLove = particle
	self._love = love
end

-- 碰撞回调
function M:crashCall()
	soundEffect:playEffectsfx05710028()
	self:stimulate()
	self:stopStandby()
end

-- 星星激励
function M:stimulate()
	self:play("tzx_zh1")
end

--  待机动画
function M:standby()
	if not self._standbyAct then
		self._standbyAct = A.cycle({
			{"fn", function ()
				-- 随机动作
				self:randomAct()
			end},
			{"delay", 5.5},
		}):at(self)
	end
end

-- 随机动作
function M:randomAct()
	local num = self:createRandom(2, self._standbyTab)
	if num == 1 then 
		self:speak1()
	elseif num == 2 then 
		self:call2()
	elseif num == 3 then 
	end
end

-- 停止闲置
function M:stopStandby()
	if self._standbyAct then 
		self:stopAction(self._standbyAct)
		self._standbyAct = nil
	end
end

-- 随机数
function M:createRandom(kind, randomTab)
    if #randomTab == kind then 
		T.clear(randomTab)
    end
    local num = N.randomExcept(1, kind, randomTab)
    table.insert(randomTab, num)
    return num
end

-- 呼吸
function M:breathe()
	self:play("tzx_hx")
end

-- 说话1
function M:speak1()
	self:play("tzx_sh1")
	-- 获取时长
	local time = soundVoice:getVoiceTime("v057028", 5)
	A.line({
		{"delay", time},
		{"fn", function ()
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end}
	}):at(self)
end

-- 说话1
function M:speak2()
	self:play("tzx_sh2")
end

-- 吆喝1
function M:call1()
	self:play("tzx_zh1")
end

-- 吆喝2
function M:call2()
	self:play("tzx_zh2")
end

-- 激励1 选对
function M:right()
	self._count = self._count + 1
	self:play("tzx_dz")
end

-- 激励2 选错
function M:error()
	self:play("tzx_yt")
end

-- 激励3 告别
function M:bye()
	self:play("tzx_gb")
end


function M:movementHandler( __evtType, __moveId )
	if __evtType == 1 then
		if __moveId == "tzx_dz"  then
			if self._count == 2 then 
				self:bye()
			else
				self:breathe()
			end
		elseif __moveId == "tzx_zh1" or "tzx_yt" or "tzx_zh2" then
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end
		if __moveId == "tzx_gb" then
			self._layer:changeScene()
		end
	elseif __evtType == 2 then
		if __moveId ==  "tzx_sh2" then
			self:breathe()
			-- 待机动画
			self:standby()
			self._canTouch = true
		end
	end
end




----------------------
-- 点击
----------------------

function M:onTouchBegan(x, y, touches)
	return true
end

function M:onTouchMoved(x, y, touches)

end

function M:onTouchEnded(x, y, touches)
	if not self._canTouch then return end
end


----------------------
-- 验证
----------------------
-- 验证合法性[构造函数参数]
function M:assertParameters(params)
	
end
----------------------
-- 过度动画开始之前的调用
----------------------
--[[--

1.资源释放，退出场景前的操作准备
2.处理视图结点卸载、事件解除绑定等相关操作

]]
function M:onExitTransitionStart()
    Tools:removeParticleTb(self)
end

return M
